package com.namasoft.contracts.common.dtos.requests;

import java.util.Arrays;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.layout.Owner;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class FetchPreferencesRequest extends PreferencesRequest
{
	private String editLayoutScreenName;
	private String listLayoutScreenName;
	private String searcherLayoutScreenName;

	public FetchPreferencesRequest(Owner owner, List<String> properties)
	{
		super(owner, properties);
	}

	public FetchPreferencesRequest()
	{
		super();
	}

	public String getEditLayoutScreenName()
	{
		return editLayoutScreenName;
	}

	public void setEditLayoutScreenName(String editLayoutScreenName)
	{
		this.editLayoutScreenName = editLayoutScreenName;
	}

	public String getListLayoutScreenName()
	{
		return listLayoutScreenName;
	}

	public void setListLayoutScreenName(String listLayoutScreenName)
	{
		this.listLayoutScreenName = listLayoutScreenName;
	}

	public String getSearcherLayoutScreenName()
	{
		return searcherLayoutScreenName;
	}

	public void setSearcherLayoutScreenName(String searcherLayoutScreenName)
	{
		this.searcherLayoutScreenName = searcherLayoutScreenName;
	}

	public FetchPreferencesRequest layoutId(String layoutId)
	{
		if (ObjectChecker.isEmptyOrNull(getProperties()) || getProperties().size() > 1)
			throw new RuntimeException("Property must be 1");
		if (EDIT_LAYOUT.equals(getProperties().get(0)))
		{
			setEditLayoutScreenName(layoutId);
		}
		else if (LIST_LAYOUT.equals(layoutId))
		{
			setListLayoutScreenName(layoutId);
		}
		else if (SEARCHER_LAYOUT.equals(layoutId) || LIST_LAYOUT_PREFERENCES.equals(layoutId))
		{
			setSearcherLayoutScreenName(layoutId);
		}
		else
		{
			throw new RuntimeException("Property does not have layout id: " + getProperties().get(0));
		}
		return this;
	}

	public static FetchPreferencesRequest editScreen(String entityType, String id)
	{
		return new FetchPreferencesRequest(Owner.entity(entityType), Arrays.asList(EDIT_LAYOUT)).layoutId(id);
	}
	public static FetchPreferencesRequest listScreen(String entityType, String id)
	{
		return new FetchPreferencesRequest(Owner.entity(entityType), Arrays.asList(LIST_LAYOUT)).layoutId(id);
	}
	public static FetchPreferencesRequest viewNames(String entityType)
	{
		return new FetchPreferencesRequest(Owner.entity(entityType), Arrays.asList(VIEW_NAMES));
	}

	public static FetchPreferencesRequest metadata(String entityType)
	{
		return new FetchPreferencesRequest(Owner.entity(entityType), Arrays.asList(META_DATA));
	}

}
