package com.namasoft.contracts.common.dtos.requests;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class FindRequest extends EntityServiceRequest
{

	private static final long serialVersionUID = 5389009384252168130L;
	private Boolean findDraft;

	protected FindRequest()
	{
		super();
	}

	public FindRequest(Boolean findDraft, String entityType)
	{
		this();
		setFindDraft(findDraft);
		setEntityType(entityType);
	}

	public Boolean getFindDraft()
	{
		return findDraft;
	}

	public void setFindDraft(Boolean findDraft)
	{
		this.findDraft = findDraft;
	}

}