package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteria;
import jakarta.xml.bind.annotation.*;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ListPageMatchingRequest extends ListPageRequest
		implements IListOrTabularRequest, HasDoNotRunSqlFieldsInFactories<ListPageMatchingRequest>
{
	private DTOCriteria criteria;
	private DTOCriteria extraCriteria;
	private String extraCriteriaId;
	private String searchInsideFieldId;
	private String searchInsideEntity;
	private Boolean asc;
	private Boolean doNotRunSqlFieldsInFactories;

	public ListPageMatchingRequest()
	{
		super();
	}

	public ListPageMatchingRequest(String entityType, DTOCriteria criteria)
	{
		super(entityType, 0, -1, null, null);
		setCriteria(criteria);
	}

	public ListPageMatchingRequest(String entityType)
	{
		this(entityType, null);
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public ListPageMatchingRequest criteria(DTOCriteria criteria)
	{
		setCriteria(criteria);
		return this;
	}

	public DTOCriteria getExtraCriteria()
	{
		return extraCriteria;
	}

	public void setExtraCriteria(DTOCriteria extraCriteria)
	{
		this.extraCriteria = extraCriteria;
	}

	public ListPageMatchingRequest firstRecord()
	{
		setPageSize(1);
		setPage(0);
		return this;
	}

	@Override
	public String getSearchInsideFieldId()
	{
		return searchInsideFieldId;
	}

	@Override
	public void setSearchInsideFieldId(String searchInsideFieldId)
	{
		this.searchInsideFieldId = searchInsideFieldId;
	}

	@Override
	public String getSearchInsideEntity()
	{
		return searchInsideEntity;
	}

	@Override
	public void setSearchInsideEntity(String searchInsideEntity)
	{
		this.searchInsideEntity = searchInsideEntity;
	}

	public Boolean getAsc()
	{
		return asc;
	}

	public void setAsc(Boolean asc)
	{
		this.asc = asc;
	}

	public String getExtraCriteriaId()
	{
		return extraCriteriaId;
	}

	public void setExtraCriteriaId(String extraCriteriaId)
	{
		this.extraCriteriaId = extraCriteriaId;
	}

	public Boolean getDoNotRunSqlFieldsInFactories()
	{
		return doNotRunSqlFieldsInFactories;
	}

	public void setDoNotRunSqlFieldsInFactories(Boolean doNotRunSqlFieldsInFactories)
	{
		this.doNotRunSqlFieldsInFactories = doNotRunSqlFieldsInFactories;
	}

	public ListPageMatchingRequest oneRecord()
	{
		setPage(0);
		setPageSize(1);
		return this;
	}

	public ListPageMatchingRequest orderBy(String orderBy)
	{
		setOrderBy(orderBy);
		return this;
	}

	public ListPageMatchingRequest desc()
	{
		setAsc(false);
		return this;
	}

	@Override
	public Boolean fetchDoNotRunSqlFieldsInFactories()
	{
		return getDoNotRunSqlFieldsInFactories();
	}

	@Override
	public void updateDoNotRunSqlFieldsInFactories(Boolean doNotRunSqlFieldsInFactories)
	{
		setDoNotRunSqlFieldsInFactories(doNotRunSqlFieldsInFactories);
	}
}
