package com.namasoft.contracts.common.dtos.requests;

import java.util.List;

import com.namasoft.common.layout.list.*;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;

import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.criteria.DTOFilledQuestionField;
import com.namasoft.common.layout.Owner;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class ListRequestBase extends EntityServiceRequest implements IListOrTabularRequest
{

	private String listId;
	private Owner owner;
	private String orderBy;
	private DTOCriteria criteria;
	private List<DTOFilledQuestionField> questionFields;
	private DTOCriteria extraCriteria;
	private String extraCriteriaId;
	private String menuItemExtraCriteriaId;
	private boolean ascending = true;
	private boolean countOnly = false;
	private boolean forSearch;
	private String searchInsideFieldId;
	private String searchInsideEntity;
	private List<ListViewQuickFilterSelectedValues> selectedQuickFilterGroups;

	public ListRequestBase(String entityType)
	{
		super(entityType);
	}

	public ListRequestBase()
	{
		super();
	}

	public ListRequestBase(ListRequestBase request)
	{
		super(request);
		if (request != null)
		{
			this.listId = request.listId;
			this.owner = request.owner;
			this.orderBy = request.orderBy;
			this.criteria = request.criteria;
			this.questionFields = request.questionFields;
		}
	}

	public String getListId()
	{
		return listId;
	}

	public void setListId(String listId)
	{
		this.listId = listId;
	}

	public Owner getOwner()
	{
		return owner;
	}

	public void setOwner(Owner owner)
	{
		this.owner = owner;
	}

	public String getOrderBy()
	{
		return orderBy;
	}

	public void setOrderBy(String orderBy)
	{
		this.orderBy = orderBy;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public List<DTOFilledQuestionField> getQuestionFields()
	{
		return questionFields;
	}

	public void setQuestionFields(List<DTOFilledQuestionField> questionFields)
	{
		this.questionFields = questionFields;
	}

	public boolean isAscending()
	{
		return ascending;
	}

	public void setAscending(boolean ascending)
	{
		this.ascending = ascending;
	}

	public DTOCriteria getExtraCriteria()
	{
		return extraCriteria;
	}

	public void setExtraCriteria(DTOCriteria extraCriteria)
	{
		this.extraCriteria = extraCriteria;
	}

	public boolean isCountOnly()
	{
		return countOnly;
	}

	public void setCountOnly(boolean countOnly)
	{
		this.countOnly = countOnly;
	}

	public String getExtraCriteriaId()
	{
		return extraCriteriaId;
	}

	public void setExtraCriteriaId(String extraCriteriaId)
	{
		this.extraCriteriaId = extraCriteriaId;
	}

	public String getMenuItemExtraCriteriaId()
	{
		return menuItemExtraCriteriaId;
	}

	public void setMenuItemExtraCriteriaId(String menuItemExtraCriteriaId)
	{
		this.menuItemExtraCriteriaId = menuItemExtraCriteriaId;
	}

	public boolean isForSearch()
	{
		return forSearch;
	}

	public void setForSearch(boolean forSearch)
	{
		this.forSearch = forSearch;
	}

	@Override
	public String getSearchInsideFieldId()
	{
		return searchInsideFieldId;
	}

	@Override
	public void setSearchInsideFieldId(String searchInsideFieldId)
	{
		this.searchInsideFieldId = searchInsideFieldId;
	}

	@Override
	public String getSearchInsideEntity()
	{
		return searchInsideEntity;
	}

	@Override
	public void setSearchInsideEntity(String searchInsideEntity)
	{
		this.searchInsideEntity = searchInsideEntity;
	}

	public List<ListViewQuickFilterSelectedValues> getSelectedQuickFilterGroups()
	{
		return selectedQuickFilterGroups;
	}

	public void setSelectedQuickFilterGroups(List<ListViewQuickFilterSelectedValues> selectedQuickFilterGroups)
	{
		this.selectedQuickFilterGroups = selectedQuickFilterGroups;
	}
}