package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.constants.NavigationType;
import com.namasoft.common.utilities.DTOConfirmation;
import jakarta.xml.bind.annotation.*;

import java.util.List;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class NavigationRequest extends ListRequestBase
{
	private static final long serialVersionUID = 8662451133387894766L;
	private String id;
	private NavigationType navigationType;
	private List<DTOConfirmation> confirmations;

	public NavigationRequest()
	{
		super();
	}

	public NavigationRequest(String entityType, String id, String orderBy)
	{
		super(entityType);
		this.id = id;
		setOrderBy(orderBy);
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public NavigationType getNavigationType()
	{
		return navigationType;
	}

	public void setNavigationType(NavigationType navigationType)
	{
		this.navigationType = navigationType;
	}

	public List<DTOConfirmation> getConfirmations()
	{
		return confirmations;
	}

	public void setConfirmations(List<DTOConfirmation> confirmations)
	{
		this.confirmations = confirmations;
	}
}
