package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.criteria.DTOCriteria;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ReportWithSubRepReq extends EntityServiceRequest
{
	private static final long serialVersionUID = 3272049359257036168L;
	private String code;
	private DTOCriteria criteria;
	private String subReportId;

	public ReportWithSubRepReq()
	{
	}

	public ReportWithSubRepReq(String entityType, String code)
	{
		super(entityType);
		this.code = code;
	}

	public ReportWithSubRepReq(String entityType, String code, String subReportId)
	{
		super(entityType);
		this.code = code;
		this.subReportId = subReportId;
	}

	public String getCode()
	{
		return code;
	}

	public void setCode(String code)
	{
		this.code = code;
	}

	public DTOCriteria getCriteria()
	{
		return criteria;
	}

	public void setCriteria(DTOCriteria criteria)
	{
		this.criteria = criteria;
	}

	public String getSubReportId()
	{
		return subReportId;
	}

	public void setSubReportId(String subReportId)
	{
		this.subReportId = subReportId;
	}
}
