package com.namasoft.contracts.common.dtos.requests;

import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.layout.Owner;
import com.namasoft.common.layout.metadata.UIPreferences;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class SavePreferencesRequest extends PreferencesRequest
{
	private UIPreferences preferences;

	public SavePreferencesRequest()
	{
		super();
	}

	public SavePreferencesRequest(Owner owner, List<String> properties, UIPreferences preferences)
	{
		super(owner, properties);
		setPreferences(preferences);
	}

	public UIPreferences getPreferences()
	{
		return preferences;
	}

	public void setPreferences(UIPreferences preferences)
	{
		this.preferences = preferences;
	}

}
