package com.namasoft.contracts.common.dtos.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class ListResult<DTO> extends ServiceResponse implements Serializable
{
	private static final long serialVersionUID = -6569329699770268891L;
	protected List<DTO> list;
	private Integer totalRecords;

	public ListResult(List<DTO> list, ResultDTO result)
	{
		setList(list);
		setResult(result);
	}

	public ListResult(List<DTO> list)
	{
		setList(list);
		setResult(ResultDTO.success());

	}

	public ListResult()
	{
	}

	public List<DTO> getList()
	{
		if (list == null)
			return list = new ArrayList<>();
		return list;
	}

	public void setList(List<DTO> list)
	{
		this.list = list;
	}

	public Integer getTotalRecords()
	{
		return totalRecords;
	}

	public void setTotalRecords(Integer totalRecords)
	{
		this.totalRecords = totalRecords;
	}
}
