package com.namasoft.contracts.common.dtos.results;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.ServiceResponse;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Map;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class MapResult<K,V> extends ServiceResponse implements Serializable
{
	private Map<K,V> data;

	public MapResult()
	{
	}

	public MapResult(Map<K,V> data)
	{
		this(data, ResultDTO.success());
	}

	public MapResult(Map<K,V> data, ResultDTO result)
	{
		super(result);
		setData(data);
	}

	public Map<K,V> getData()
	{
		return data;
	}

	public void setData(Map<K,V> data)
	{
		this.data = data;
	}

}