package com.namasoft.contracts.common.services;

import com.namasoft.common.*;
import com.namasoft.common.constants.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.hijri.HijriInfo;
import com.namasoft.common.layout.ScreenLayout;
import com.namasoft.common.layout.edit.EditScreenLayout;
import com.namasoft.common.layout.list.ListViewQuickFilterGroupVal;
import com.namasoft.common.layout.metadata.*;
import com.namasoft.common.utils.importer.data.DataSet;
import com.namasoft.contracts.NamaBranding;
import com.namasoft.contracts.common.dtos.*;
import com.namasoft.contracts.common.dtos.config.*;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.modules.commonbasic.contracts.entities.DTOMenuDefinition;
import com.namasoft.modules.commonbasic.contracts.requests.*;
import com.namasoft.modules.commonbasic.contracts.valueobjects.*;
import jakarta.jws.*;

import java.util.Collection;

@WebService(name = "corews")
public interface CoreWS
{
	@WebMethod
	GetResult<DTONaMaLayout> getFileById(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTONaMaLayout> getFileByPath(@WebParam(name = "request") ByCodeRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ReadAttachmentResult readAttachment(@WebParam(name = "request") ReadAttachmentRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTONaMaLayout> saveFile(@WebParam(name = "request") PutRequest<DTONaMaLayout> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<ModuleDescription> getAvailableModules(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Triple<Long, Long, Long>> countAwaitingApprovalsAndNotifications(@WebParam(name = "request") ListApprovalsRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ActionResult performAction(@WebParam(name = "request") ActionRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<UIPreferences> fetchPreferences(@WebParam(name = "request") FetchPreferencesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NaMaMetaData> fetchDocTermMetadataForEntity(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NaMaMetaData> fetchConfigEntryMetaDataForModule(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<TermsAndConfigsMetadata> fetchTermsAndConfigurationMetadata(@WebParam(name = "request") ServiceRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<UIPreferences> savePreferences(@WebParam(name = "request") SavePreferencesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ValidateFieldResult validateField(@WebParam(name = "validateFieldRequest") ValidateFieldReuest fieldReuest) throws NaMaServiceExcepption;

	@WebMethod
	LoginResult login(@WebParam(name = "request") LoginRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse removeGrantedDevice(@WebParam(name = "rquestRemove") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	LoginResult loginByGrantId(@WebParam(name = "request") LogInByGrantIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	TranslationsReult getTranslations(@WebParam(name = "request") TranslationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTONaMaFileSystemInfo> listAllFiles(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetDefaultUIs(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetDefaultUIsForApplicableTypes(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<ScreenLayout> fetchUIsDifferencesBeforeScreenModifier(@WebParam(name = "request") ScreenModifierDiffRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<ScreenLayout> fetchLayoutTillScreenModifier(@WebParam(name = "request") ScreenModifierDiffRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> calculateDimensions(@WebParam(name = "request") CalculateDimensionsRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> isMasterEntity(@WebParam(name = "request") EntityServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> isDocumentEntity(@WebParam(name = "request") EntityServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreensMap> fetchTermConfigScreens(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreenLayout> fetchSingleTermConfigScreen(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreensMap> fetchConfigurationScreens(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreenLayout> fetchSingleConfigEntryScreen(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	Collection<EnumMetaData> getEnumMetaData(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOAccountDimensionConfigurations> getDimensionConfigurations(@WebParam(name = "request") ServiceRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOMeasuresConfiguration> getMeasuresConfigurations(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTODocumentRequestStatuses> fetchDocumentRequestsStatus(@WebParam(name = "request") SendRequest<String> request)
			throws NaMaServiceExcepption;

	@WebMethod
	String oqlToSql(String oql, String module) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getReportModuleId(@WebParam(name = "request") SendRequest<String> id) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DateWrapper> getCurrentTimeStamp() throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOLargeData> getReportArabicVersion(@WebParam(name = "request") ReportWithSubRepReq request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOLargeData> getReportEnglishVersion(@WebParam(name = "request") ReportWithSubRepReq request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse relogin(@WebParam(name = "request") SendRequest<ReloginInfo> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse reprocessRequests(@WebParam(name = "request") SendRequest<ReprocessInfo> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> fetchOriginsOfBizRequestStatuses(@WebParam(name = "request") SendRequest<ReprocessInfo> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse modifyInMessages(@WebParam(name = "request") SendRequest<ReprocessInfo> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> findCodeGaps(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetServerSettings(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOTimedQueryResult> executeTimedQuery(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse revertTo(@WebParam(name = "request") SendRequest<Long> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse createBackup(@WebParam(name = "request") SendRequest<Long> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse evictCache(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse changeDB(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOWriteToHOResp> writeToHO(@WebParam(name = "request") SendRequest<DTOWriteToHOReq> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOReadFromHOResp> readFromHO(@WebParam(name = "request") SendRequest<DTOReadFromHOReq> request) throws NaMaServiceExcepption;

	Long generateMessageSequence();

	@WebMethod
	ServiceResponse markAsReadTop5Notification(@WebParam(name = "request") ListApprovalsRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse markNotificationsAsReadByIds(@WebParam(name = "request") SendListRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> listTop5UnreadNotifications(@WebParam(name = "request") ListApprovalsRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOTabularResult> listTop5UnreadNotificationsWithExtraContent(@WebParam(name = "request") ListApprovalsRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOTabularResult> listTop5UnreadApprovals(@WebParam(name = "request") ListApprovalsRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<ListViewQuickFilterGroupVal> fetchQuickFilterValues(@WebParam(name = "request") ListRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse forceReplicationCleanUp(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<CustomGUIComponentsMetadata> getCustomGUIComponentsMetadata(@WebParam(name = "request") ServiceRequest request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DBTranslationResp> getDBTranslations(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<TemplateMetadata> getUserTemplates(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<HijriInfo> getHijriInfo(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<NaMaError> getCriticalErrors(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> getModules(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> canCreateCustomer(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse refreshCriticalErrors(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse migrateAttachments(@WebParam(name = "request") SendRequest<String> request);

	@WebMethod
	ServiceResponse migrateEntityVersion(@WebParam(name = "request") ServiceRequest request);

	@WebMethod
	ListResult<EntityReferenceData> listImportanConfigFiles(@WebParam(name = "request") ServiceRequest request);

	@WebMethod
	ServiceResponse recurDocument(@WebParam(name = "request") SendRequest<DTORecuringRequest> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOServerTask> currentTasks(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> getCompanyName(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<StringPair> getCompanyAndCustomerName(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NamaBranding> getBranding(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> dscCustomAction(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse importDataSet(@WebParam(name = "request") SendRequest<DataSet> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetDisplayColumns(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse killTask(@WebParam(name = "request") SendRequest<String> killtask) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOUser> getAlternativeUsers(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ListOfGenericValues> performCustomPostAction(@WebParam(name = "request") SendRequest<CustomPostActionReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<SuggestionList> runCustomSuggestionProvider(@WebParam(name = "request") SendRequest<CustomPostActionReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ListOfGenericValues> extractDynamicCriteriaFields(@WebParam(name = "request") SendRequest<CustomPostActionReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> shouldStartAlwaysByNewGui(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> isNewGUIEnabled(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOMenuDefinition> getMenuForCurrentUser(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> evaluateTempoDynamicCriteriaFields(@WebParam(name = "request") SendRequest<CustomPostActionReq> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse allowLoginAfterFailedLogins(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> shouldStartInMobileByNewGui(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> filterReferencesBasedOnCurrentDimensionsAndSecurity(
			@WebParam(name = "request") SendListRequest<EntityReferenceData> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOUser> findCurrentUserFullProfile(@WebParam(name = "requsest") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> findWizardMetaData(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ResultDTO> validateWizardStep(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse applyWizardData(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse saveWizardData(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse importJsonFromAnotherServer(@WebParam(name = "request") EntityImportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<String> printMobileRecord(RunMobileHTMLTemplateRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse recordActionsHistoryOfUtils(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOGuiThemeResp> findThemesFromDB(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOVueGUITheme> findVueJSThemesFromDB(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOCacheDescription> readCaches(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NamaAppVersionDTO> fetchServerVersion(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

}
