package com.namasoft.contracts.common.services;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;

import com.namasoft.common.flatobjects.FlatObject;
import com.namasoft.contracts.common.dtos.PagedDTOTabularResult;
import com.namasoft.contracts.common.dtos.requests.EntityServiceRequest;
import com.namasoft.contracts.common.dtos.requests.FindByIDRequest;
import com.namasoft.contracts.common.dtos.requests.FindMatchingSimpleEntitiesParams;
import com.namasoft.contracts.common.dtos.requests.ListPageMatchingRequest;
import com.namasoft.contracts.common.dtos.requests.ListPageRequest;
import com.namasoft.contracts.common.dtos.requests.ListRequest;
import com.namasoft.contracts.common.dtos.requests.NavigationRequest;
import com.namasoft.contracts.common.dtos.requests.SearchRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.requests.TabularRequest;
import com.namasoft.contracts.common.dtos.results.FlatListEntityResult;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.contracts.common.dtos.results.PagedListResult;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.contracts.common.services.base.NaMaUtilityWS;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSimpleEntityRef;

@WebService(name = "simpleentityws")
public interface SimpleEntityWS extends NaMaUtilityWS
{
	@WebMethod
	GetResult<FlatObject> findByID(@WebParam(name = "id") FindByIDRequest id) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<FlatObject> listPageMatching(@WebParam(name = "servicerequest") ListPageMatchingRequest servicerequest) throws NaMaServiceExcepption;

	@WebMethod
	PagedListResult<FlatObject> listPage(@WebParam(name = "request") ListPageRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Long> count(@WebParam(name = "serviceRequest") EntityServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	PagedDTOTabularResult tabularListPage(@WebParam(name = "request") TabularRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<FlatObject> navigate(@WebParam(name = "currentRecord") NavigationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Long> getCurrentRecordOrderInList(@WebParam(name = "currentRecord") NavigationRequest request) throws NaMaServiceExcepption;

	@WebMethod
	PagedDTOTabularResult search(@WebParam(name = "request") SearchRequest request) throws NaMaServiceExcepption;

	@WebMethod
	FlatListEntityResult list(@WebParam(name = "request") ListRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOSimpleEntityRef> findAllSimpleEntitiesMatchingRef(@WebParam(name = "request") SendRequest<FindMatchingSimpleEntitiesParams> request)
			throws NaMaServiceExcepption;

}
