package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOOPResponsibilityLine;
import com.namasoft.modules.commonbasic.contracts.details.DTOOrgPostionSkillLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOOrganizationPosition extends MasterFileDTO implements Serializable
{
	private BigDecimal maxPermissionsHoursPerMonth;
	private BigDecimal maxSinglePermissionHours;
	private BigDecimal requiredYearsOfExperience;
	private EntityReferenceData parent;
	private EntityReferenceData salaryStructure;
	private Integer maxNumOfPositions;
	private Integer maxPermissionsPerMonth;
	private Integer minNumOfPositions;
	private List<DTOOPResponsibilityLine> responsibilities = new ArrayList<DTOOPResponsibilityLine>();
	private List<DTOOrgPostionSkillLine> skills = new ArrayList<DTOOrgPostionSkillLine>();
	private String dutiesAndTasks;
	private String fingerPrintException;
	private String fullHierarchyPath;
	private String hierarchyPath;
	public BigDecimal getMaxPermissionsHoursPerMonth()
	{
		return maxPermissionsHoursPerMonth;
	}

	public BigDecimal getMaxSinglePermissionHours()
	{
		return maxSinglePermissionHours;
	}

	public BigDecimal getRequiredYearsOfExperience()
	{
		return requiredYearsOfExperience;
	}

	public EntityReferenceData getParent()
	{
		return parent;
	}

	public EntityReferenceData getSalaryStructure()
	{
		return salaryStructure;
	}

	public Integer getMaxNumOfPositions()
	{
		return maxNumOfPositions;
	}

	public Integer getMaxPermissionsPerMonth()
	{
		return maxPermissionsPerMonth;
	}

	public Integer getMinNumOfPositions()
	{
		return minNumOfPositions;
	}

	public List<DTOOPResponsibilityLine> getResponsibilities()
	{
		return responsibilities;
	}

	public List<DTOOrgPostionSkillLine> getSkills()
	{
		return skills;
	}

	public String getDutiesAndTasks()
	{
		return dutiesAndTasks;
	}

	public String getFingerPrintException()
	{
		return fingerPrintException;
	}

	public String getFullHierarchyPath()
	{
		return fullHierarchyPath;
	}

	public String getHierarchyPath()
	{
		return hierarchyPath;
	}

	public void setDutiesAndTasks(String dutiesAndTasks)
	{
		this.dutiesAndTasks = dutiesAndTasks;
	}

	public void setFingerPrintException(String fingerPrintException)
	{
		this.fingerPrintException = fingerPrintException;
	}

	public void setFullHierarchyPath(String fullHierarchyPath)
	{
		this.fullHierarchyPath = fullHierarchyPath;
	}

	public void setHierarchyPath(String hierarchyPath)
	{
		this.hierarchyPath = hierarchyPath;
	}

	public void setMaxNumOfPositions(Integer maxNumOfPositions)
	{
		this.maxNumOfPositions = maxNumOfPositions;
	}

	public void setMaxPermissionsHoursPerMonth(BigDecimal maxPermissionsHoursPerMonth)
	{
		this.maxPermissionsHoursPerMonth = maxPermissionsHoursPerMonth;
	}

	public void setMaxPermissionsPerMonth(Integer maxPermissionsPerMonth)
	{
		this.maxPermissionsPerMonth = maxPermissionsPerMonth;
	}

	public void setMaxSinglePermissionHours(BigDecimal maxSinglePermissionHours)
	{
		this.maxSinglePermissionHours = maxSinglePermissionHours;
	}

	public void setMinNumOfPositions(Integer minNumOfPositions)
	{
		this.minNumOfPositions = minNumOfPositions;
	}

	public void setParent(EntityReferenceData parent)
	{
		this.parent = parent;
	}

	public void setRequiredYearsOfExperience(BigDecimal requiredYearsOfExperience)
	{
		this.requiredYearsOfExperience = requiredYearsOfExperience;
	}

	public void setResponsibilities(List<DTOOPResponsibilityLine> responsibilities)
	{
		this.responsibilities = responsibilities;
	}

	public void setSalaryStructure(EntityReferenceData salaryStructure)
	{
		this.salaryStructure = salaryStructure;
	}

	public void setSkills(List<DTOOrgPostionSkillLine> skills)
	{
		this.skills = skills;
	}

}
