/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.upgrader;

import com.github.cliftonlabs.json_simple.JsonObject;
import com.github.cliftonlabs.json_simple.Jsoner;
import com.namasoft.pos.upgrader.POSUpgraderSplashScreen;
import com.namasoft.upgrader.ConsoleProgressHandler;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.FileUtils;
import com.namasoft.upgrader.ProcessesUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.JOptionPane;

public class POSUpgrader {
    private static final String POS_UPGRADER_JAR_NAME = "nama-pos-upgrader.jar";

    public static void upgrade(String[] args) {
        int dialogResult;
        String systemCall = System.getProperty("systemCall");
        if (!(systemCall != null && systemCall.equalsIgnoreCase("true") || (dialogResult = POSUpgrader.showConfirmationDialog()) != 1)) {
            return;
        }
        try {
            POSUpgraderSplashScreen screen = new POSUpgraderSplashScreen("\u062a\u0646\u0632\u064a\u0644 \u0623\u062e\u0631 \u0623\u0635\u062f\u0627\u0631 \u0646\u0642\u0627\u0637 \u0628\u064a\u0639 ", "POS Download");
            Properties properties = POSUpgrader.loadProperties();
            String useDomainServerForRelease = properties.getProperty("useDomainServerForRelease", "false").trim();
            boolean useServerForDomain = useDomainServerForRelease.equals("1") || Boolean.parseBoolean(useDomainServerForRelease);
            String latestVersion = "-from-server";
            if (!useServerForDomain) {
                latestVersion = new Scanner(new URL("https://nlm.namasoft.com/nlm/download.php?releasename=get").openStream(), "UTF-8").useDelimiter("\\A").next();
            }
            String posLatestName = "pos" + latestVersion;
            File releaseFile = new File(posLatestName + ".zip");
            releaseFile.delete();
            if (useServerForDomain) {
                Object serverURL = properties.getProperty("namaServerURL").trim();
                if (!((String)serverURL).endsWith("/")) {
                    serverURL = (String)serverURL + "/";
                }
                releaseFile = FileDownloader.download((String)serverURL + "pos.zip", screen, releaseFile);
            } else {
                releaseFile = FileDownloader.download("https://namasoft.com/bin/pos/" + posLatestName + ".zip", screen, releaseFile);
            }
            File file = new File("pos-0.0.1-SNAPSHOT-jfx.jar");
            do {
                POSUpgrader.shutDownRunningInstance();
                if (file.delete()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                System.out.println("Could not delete pos jar, retrying in 1 second");
            } while (file.exists());
            FileUtils.unZipIt(releaseFile, ".", "pos", new String[0]);
            releaseFile.delete();
            POSUpgrader.launchPosApp();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    public static void shutDownRunningInstance() {
        try {
            Socket clientSocket = new Socket(InetAddress.getLocalHost(), 6253);
            OutputStream out = clientSocket.getOutputStream();
            String string = "SHUTDOWN-POS\n";
            out.write(string.getBytes());
            out.close();
            clientSocket.close();
        }
        catch (ConnectException e) {
            System.out.println("No running instance of POS was found.");
        }
        catch (IOException e) {
            System.err.println("Could not notify instance to shutdown, attempting release downlaod any way");
            e.printStackTrace();
        }
    }

    public static void downloadUpgraderAndStartItWithoutConfirmation() {
        POSUpgrader.downloadUpgraderAndStartIt(false);
    }

    public static void downloadUpgraderAndStartIt() {
        POSUpgrader.downloadUpgraderAndStartIt(true);
    }

    private static void downloadUpgraderAndStartIt(boolean showConfirmation) {
        File downloadDirectory = null;
        File jarFile = null;
        try {
            if (showConfirmation && POSUpgrader.showConfirmationDialog() == 1) {
                return;
            }
            downloadDirectory = new File(".").getAbsoluteFile().getParentFile();
            jarFile = new File(downloadDirectory, POS_UPGRADER_JAR_NAME);
            jarFile.delete();
            FileDownloader.download("https://namasoft.com/bin/nama-pos-upgrader.jar", new ConsoleProgressHandler(), jarFile);
            String configPath = String.valueOf(downloadDirectory) + "\\pos-config.json";
            File configFile = Paths.get(configPath, new String[0]).toFile();
            JsonObject config = (JsonObject)Jsoner.deserialize(new FileReader(configFile));
            String jdkPath = (String)config.get("jdk-path");
            String javaExecutable = "java";
            if (jdkPath != null && !jdkPath.isBlank()) {
                boolean hasBin = jdkPath.toLowerCase().endsWith("bin");
                javaExecutable = hasBin ? Paths.get(jdkPath, "java").toString() : Paths.get(jdkPath, "bin", "java").toString();
            }
            ProcessesUtil.runProcessToConsole(downloadDirectory, "cmd", "/c", "start", javaExecutable, "-DposFolder=\"" + String.valueOf(downloadDirectory) + "\"", "-DsystemCall=true", "-jar", jarFile.getAbsolutePath());
        }
        catch (Exception e) {
            try {
                ProcessesUtil.runProcessToConsole(downloadDirectory, "cmd", "/c", "start", "java", "-DposFolder=\"" + String.valueOf(downloadDirectory) + "\"", "-DsystemCall=true", "-jar", jarFile.getAbsolutePath());
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    public static int showConfirmationDialog() {
        return JOptionPane.showConfirmDialog(null, "This will delete the current release and download the latest one. Are you sure ?\n\u0633\u0648\u0641 \u064a\u062a\u0645 \u0645\u0633\u062d \u0627\u0644\u0646\u0633\u062e\u0629 \u0627\u0644\u062d\u0627\u0644\u064a\u0629 \u0645\u0646 \u0646\u0642\u0627\u0637 \u0627\u0644\u0628\u064a\u0639 \u0648 \u062a\u062d\u0645\u064a\u0644 \u0627\u062e\u0631 \u0625\u0635\u062f\u0627\u0631 \u0647\u0644 \u0627\u0646\u062a \u0645\u062a\u0623\u0643\u062f \u0645\u0646 \u0630\u0644\u0643 \u061f", "Warning", 0);
    }

    public static void main(String[] args) {
        POSUpgrader.launchPosApp();
    }

    public static void launchPosApp() {
        try {
            Runtime.getRuntime().exec("pos-launcher.exe");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Properties loadProperties() throws IOException {
        Properties namaProperties = new Properties();
        File propertiesFile = new File("nama.properties");
        if (propertiesFile.exists()) {
            FileInputStream propertiesStream = new FileInputStream(propertiesFile);
            namaProperties.load(propertiesStream);
            propertiesStream.close();
        }
        return namaProperties;
    }
}

