/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printserve.upgrader;

import com.namasoft.pos.upgrader.POSUpgraderSplashScreen;
import com.namasoft.upgrader.FileDownloader;
import com.namasoft.upgrader.FileUtils;
import com.namasoft.upgrader.ProcessesUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Scanner;

public class PrintServer {
    public static void start(String[] args) throws IOException, InterruptedException {
        File home = new File(System.getProperty("user.home"));
        File namaPrintServer = new File(home, "nama-printing-server/printing-server-0.0.1-SNAPSHOT-jfx.jar");
        if (namaPrintServer.exists()) {
            if (new File(namaPrintServer.getParentFile(), "lib/jasperreports-6.16.0.jar").exists()) {
                FileUtils.deleteDir(namaPrintServer.getParentFile());
            } else {
                PrintServer.launchPrintingServer(namaPrintServer);
                return;
            }
        }
        POSUpgraderSplashScreen screen = new POSUpgraderSplashScreen("\u062a\u0646\u0632\u064a\u0644 \u0627\u0635\u062f\u0627\u0631 \u062e\u0627\u062f\u0645 \u0627\u0644\u0637\u0628\u0627\u0639\u0629 ", "Printing Server Download");
        String latestVersion = new Scanner(new URL("https://nlm.namasoft.com/nlm/download.php?releasename=get").openStream(), "UTF-8").useDelimiter("\\A").next();
        namaPrintServer.getParentFile().mkdirs();
        String posLatestName = "printing-server" + latestVersion;
        File releaseFile = new File(posLatestName + ".zip");
        releaseFile.delete();
        releaseFile = FileDownloader.download("https://namasoft.com/bin/printing-server/" + posLatestName + ".zip", screen, releaseFile);
        FileUtils.unZipIt(releaseFile, namaPrintServer.getParentFile().getAbsolutePath(), "printing-server", new String[0]);
        PrintServer.launchPrintingServer(namaPrintServer);
    }

    private static void launchPrintingServer(File namaPrintServer) throws IOException, InterruptedException {
        ProcessesUtil.runProcessToConsole(namaPrintServer.getParentFile(), "cmd", "/c", "start", "javaw", "-jar", namaPrintServer.getAbsolutePath());
    }
}

