/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.POSPaymentMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class CashDenominationsBox
extends NamaVBox {
    private Stage stage;
    private Map<String, Consumer<BigDecimal>> denominationChangeListenersMap;
    private NamaComboBox<POSPaymentMethod> paymentMethodsComboBox;
    private Map<String, Integer> denominationValueMap;
    private NamaHBox denominationsContainer = new NamaHBox(5);

    public CashDenominationsBox(Stage stage, IHasToolBar screen, Map<String, Consumer<BigDecimal>> denominationChangeListenersMap) {
        List denominations = StringUtils.csvLineToList((String)POSResourcesUtil.fetchPOSConfig().getCashDenominations());
        if (ObjectChecker.isEmptyOrNull((Object)denominations)) {
            return;
        }
        this.stage = stage;
        this.denominationChangeListenersMap = denominationChangeListenersMap;
        NamaLabel paymentMethodLabel = new NamaLabel("paymentMethod");
        this.paymentMethodsComboBox = new NamaComboBox<POSPaymentMethod>(POSResourcesUtil.methods, screen, "");
        this.paymentMethodsComboBox.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (ObjectChecker.areEqual((Object)oldValue, (Object)newValue)) {
                return;
            }
            this.clear((List<Node>)this.denominationsContainer.getChildren());
        });
        this.denominationValueMap = new HashMap<String, Integer>();
        this.setStyle("-fx-border-width: 1;-fx-border-style: Solid");
        this.setSpacing(5.0);
        this.setPadding(new Insets(5.0));
        for (String denomination : denominations) {
            this.denominationsContainer.getChildren().add((Object)this.createDenominationField(denomination));
        }
        NamaHBox paymentMethodBox = new NamaHBox(new Node[]{paymentMethodLabel, this.paymentMethodsComboBox});
        paymentMethodBox.setSpacing(5.0);
        this.getChildren().addAll((Object[])new Node[]{paymentMethodBox, this.denominationsContainer});
    }

    private NamaVBox createDenominationField(String denomination) {
        NamaLabel denominationName = new NamaLabel(denomination);
        denominationName.setAlignment(Pos.CENTER);
        denominationName.setFont(Font.font((String)"Times New Romans", (FontWeight)FontWeight.BOLD, (double)16.0));
        NamaTextField denominationCountField = this.createDenominationCountInputField(denomination);
        NamaVBox denominationField = new NamaVBox(new Node[]{denominationName, denominationCountField});
        return denominationField;
    }

    private NamaTextField createDenominationCountInputField(String denomination) {
        NamaTextField denominationCountField = new NamaTextField(POSFieldType.Integer);
        denominationCountField.textProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (ObjectChecker.isEmptyOrNull((Object)denominationCountField.getText())) {
                    return;
                }
                POSPaymentMethod paymentMethod = (POSPaymentMethod)this.paymentMethodsComboBox.fetchValue();
                if (ObjectChecker.isEmptyOrNull((Object)paymentMethod)) {
                    POSErrorAndInfoMessagesUtil.showError("Please select payment method", this.stage);
                    return;
                }
                Integer denominationCount = new Integer(denominationCountField.getText());
                this.denominationValueMap.put(denomination, Math.multiplyExact(denominationCount, (int)Integer.valueOf(denomination)));
                BigDecimal total = CollectionsUtility.totalize(new ArrayList<Integer>(this.denominationValueMap.values()), l -> BigDecimal.valueOf(l.intValue()));
                this.denominationChangeListenersMap.get(paymentMethod.nameByLanguage()).accept(total);
            }
            catch (NumberFormatException exception) {
                POSErrorAndInfoMessagesUtil.showError("You should enter valid number", this.stage);
            }
        });
        return denominationCountField;
    }

    public void setDenominationChangeListenersMap(Map<String, Consumer<BigDecimal>> denominationChangeListenersMap) {
        this.denominationChangeListenersMap = denominationChangeListenersMap;
    }

    public void clear() {
        if (this.paymentMethodsComboBox == null) {
            return;
        }
        this.paymentMethodsComboBox.clear();
        this.clear((List<Node>)this.denominationsContainer.getChildren());
    }

    private void clear(List<Node> nodes) {
        for (Node node : nodes) {
            if (node instanceof Pane) {
                this.clear((List<Node>)((Pane)node).getChildren());
            }
            if (!(node instanceof TextField)) continue;
            ((TextField)node).clear();
        }
    }
}

