/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSResourcesUtil;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;

public class NamaCheckBox
extends CheckBox
implements POSField,
IHasFont {
    private String text;

    public NamaCheckBox(String text) {
        super(POSResourcesUtil.id(text, new Object[0]));
        this.text = text;
        NamaTextField.addEnterAndTabEvents((Control)this);
    }

    @Override
    public void updateValue(Object value) {
        this.setSelected((Boolean)value);
    }

    @Override
    public Object fetchValue() {
        return this.isSelected();
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        this.setText(ObjectChecker.toStringOrEmpty(value));
    }

    @Override
    public void setTitle(String text) {
        this.text = text;
    }

    @Override
    public String getTitle() {
        return this.text;
    }

    @Override
    public POSFieldType fetchFieldType() {
        return POSFieldType.Boolean;
    }

    @Override
    public void refreshContent() {
        this.setTitle(POSResourcesUtil.id(this.text, new Object[0]));
    }
}

