/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.domain.POSMasterFile;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;

public class NamaComboBox<E>
extends ComboBox<E>
implements POSField {
    private String title;
    private IHasToolBar screen;
    private String fieldId;
    private Function<Object, Void> changeValueFunc;

    public NamaComboBox(IHasToolBar screen, String fieldId) {
        this(new ArrayList(), screen, fieldId);
    }

    public NamaComboBox(List<E> values, IHasToolBar screen, String fieldId) {
        this(values, screen, fieldId, null);
    }

    public NamaComboBox(List<E> values, IHasToolBar screen, String fieldId, Function func) {
        this((List<E>)FXCollections.observableList(values));
        this.changeValueFunc = func;
        this.screen = screen;
        this.fieldId = fieldId;
        this.applyConverter();
        NamaSearchBox.setDefaultValueIfNeeded(screen, fieldId, this);
    }

    public NamaComboBox(List<E> values) {
        super(FXCollections.observableList(values));
    }

    @Override
    public void updateValue(Object value) {
        this.getSelectionModel().select(value);
    }

    @Override
    public Object fetchValue() {
        return this.getValue();
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        if (this.getSelectionModel() != null) {
            this.getSelectionModel().select((Object)ObjectChecker.toStringOrEmpty(value));
        }
        if (this.changeValueFunc != null) {
            this.changeValueFunc.apply(value);
        }
    }

    private void applyConverter() {
        this.setConverter(new StringConverter<E>(this){

            public String toString(E object) {
                if (object == null) {
                    return null;
                }
                String val = object.toString();
                if (object instanceof POSMasterFile) {
                    val = ((POSMasterFile)object).nameByLanguage();
                }
                return val;
            }

            public E fromString(String string) {
                return null;
            }
        });
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void clear() {
        this.setValue(null);
        NamaSearchBox.setDefaultValueIfNeeded(this.screen, this.fieldId, this);
    }
}

