/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.ISpecDimsNamaContext;
import com.namasoft.namacontrols.tablecells.POSSalesTableFields;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import java.util.Map;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.stage.Stage;
import javafx.stage.Window;

public class NamaContextMenu
extends ContextMenu {
    private Map<String, String> menuItems;
    private Stage stage;
    private ISpecDimsNamaContext iSpecDims;
    private TableCell cell;
    private TableColumn<?, ?> col;

    public NamaContextMenu(Map<String, String> items, TableCell onCell, Stage stage, ISpecDimsNamaContext specDims, TableColumn<?, ?> onCol) {
        this.setMenuItems(items);
        this.setCell(onCell);
        this.setStage(stage);
        this.setiSpecDims(specDims);
        this.setCol(onCol);
    }

    public TableColumn<?, ?> getCol() {
        return this.col;
    }

    public void setCol(TableColumn<?, ?> col) {
        this.col = col;
    }

    public void show(Double x, Double y) {
        for (Map.Entry<String, String> item : this.menuItems.entrySet()) {
            MenuItem menuItem = new MenuItem(this.joiningCodeAndName(item.getKey(), item.getValue(), " - "));
            this.getItems().add((Object)menuItem);
            menuItem.setOnAction(event -> {
                String tableId;
                AbsPOSSalesLine line = (AbsPOSSalesLine)this.col.getTableView().getSelectionModel().getSelectedItem();
                if (line == null) {
                    return;
                }
                if (ObjectChecker.isNotEmptyOrNull((Object)this.getCell())) {
                    this.getCell().setText(menuItem.getText());
                }
                if (ObjectChecker.areEqual((Object)(tableId = this.col.getId()), (Object)POSSalesTableFields.UOM_Col)) {
                    line.getQty().setUom((POSUnit)POSPersister.findByCode(POSUnit.class, (String)item.getKey()));
                }
                POSItemSpecificDimensions itemDimensions = line.getItemDimensions();
                if (ObjectChecker.isAnyEqualToFirst((Object)tableId, (Object[])new String[]{POSSalesTableFields.Size_CodeName_Col, POSSalesTableFields.Size_Col, POSSalesTableFields.Size_Name_Col, POSSalesTableFields.Color_CodeName_Col, POSSalesTableFields.Color_Col, POSSalesTableFields.Color_Name_Col})) {
                    NamaContextMenu.fillColorOrSizeCols(tableId, itemDimensions, item);
                }
                if (ObjectChecker.areEqual((Object)tableId, (Object)POSSalesTableFields.Revision_Col)) {
                    itemDimensions.setRevisionId((String)item.getKey());
                }
                if (ObjectChecker.areEqual((Object)tableId, (Object)POSSalesTableFields.Locator_Col)) {
                    line.setLocation((POSLocation)POSPersister.findByCode(POSLocation.class, menuItem.getText()));
                }
                this.getiSpecDims().doSpecDimsSelectAction();
            });
        }
        if (this.getItems().size() > 0) {
            this.show((Window)this.stage, x, y);
        }
    }

    private String joiningCodeAndName(String key, String value, String separator) {
        return ObjectChecker.isEmptyOrNull((Object)value) ? key : key + separator + value;
    }

    public static void fillColorOrSizeCols(String tableCol, POSItemSpecificDimensions itemDimensions, Map.Entry<String, String> codeAndName) {
        if (ObjectChecker.isAnyEqualToFirst((Object)tableCol, (Object[])new String[]{POSSalesTableFields.Size_CodeName_Col, POSSalesTableFields.Size_Col, POSSalesTableFields.Size_Name_Col})) {
            itemDimensions.setSize(codeAndName.getKey());
            itemDimensions.setSizeName(codeAndName.getValue());
        } else {
            itemDimensions.setColor(codeAndName.getKey());
            itemDimensions.setColorName(codeAndName.getValue());
        }
    }

    public Map<String, String> getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(Map<String, String> menuItems) {
        this.menuItems = menuItems;
    }

    public TableCell getCell() {
        return this.cell;
    }

    public void setCell(TableCell cell) {
        this.cell = cell;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public ISpecDimsNamaContext getiSpecDims() {
        return this.iSpecDims;
    }

    public void setiSpecDims(ISpecDimsNamaContext iSpecDims) {
        this.iSpecDims = iSpecDims;
    }
}

