/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import javafx.scene.control.DatePicker;

public class NamaDatePicker
extends DatePicker
implements POSField {
    private String title;
    private IHasToolBar screen;
    private String fieldId;

    public NamaDatePicker() {
        this(null, null);
    }

    public NamaDatePicker(IHasToolBar screen, String fieldId) {
        this.setPrefWidth(240.0);
        this.screen = screen;
        this.fieldId = fieldId;
        NamaSearchBox.setDefaultValueIfNeeded(screen, fieldId, this);
    }

    @Override
    public void updateValue(Object value) {
        this.setValue((LocalDate)value);
    }

    @Override
    public Object fetchValue() {
        return this.fetchValueAsDate();
    }

    public Date fetchValueAsDate() {
        if (this.getValue() == null) {
            return null;
        }
        return Date.from(((LocalDate)this.getValue()).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        if (value instanceof DateWrapper) {
            value = ((DateWrapper)value).toDate();
        }
        if (value instanceof Date) {
            this.setValue(((Date)value).toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public POSFieldType fetchFieldType() {
        return POSFieldType.Date;
    }

    public void clear() {
        NamaSearchBox.setDefaultValueIfNeeded(this.screen, this.fieldId, this);
    }
}

