/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaBorderPane;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSResourcesUtil;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class NamaDialog<T>
extends Dialog<T> {
    private NamaHBox titlePane;
    private NamaLabel titleLabel;
    private NamaHBox headerPane;
    private NamaText headerLabel;
    private NamaHBox contentPane;
    private NamaHBox footerPane;
    private Consumer<ActionEvent> okAction;
    private NamaButton ok;
    private NamaButton cancel;
    private Dialog fromDialog;
    private boolean hasErrors;
    private boolean validFailureFirstTime = true;

    public NamaDialog(String title, Consumer<ActionEvent> okAction) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.initStyle(StageStyle.UNDECORATED);
        this.getDialogPane().setNodeOrientation(POSResourcesUtil.getOrientation());
        this.getDialogPane().setCenterShape(true);
        Stage stage = POSResourcesUtil.fetchCurrentScreenStage();
        if (stage != null) {
            this.initOwner((Window)stage);
        }
        this.okAction = okAction;
        this.getDialogPane().getStyleClass().add((Object)"nama-dialog");
        this.getDialogPane().getScene().setFill((Paint)Color.TRANSPARENT);
        this.createTitlePane(title);
        this.createHeaderPane();
        this.createContentPane();
        this.createFooterPane();
        NamaVBox root = new NamaVBox(new Node[]{this.headerPane, this.contentPane, this.footerPane});
        NamaHBox.setHgrow((Node)root, (Priority)Priority.ALWAYS);
        root.getStyleClass().add((Object)"dialog-root");
        this.getDialogPane().setContent((Node)root);
        POSSettingsUtil.addStyleSheetFor("css/searchdialog.css", (Parent)this.getDialogPane());
        IHasToolBar screen = POSResourcesUtil.currentScreen;
        if (screen != null) {
            ColorAdjust colorAdjust = new ColorAdjust();
            colorAdjust.setBrightness(-0.4);
            POSSettingsUtil.updateScreenColor((Parent)this.getDialogPane(), screen.documentType());
            this.setOnShowing(e -> {
                if (this.fromDialog == null) {
                    NamaDialog.fetchCurrentScreenRoot().setEffect((Effect)colorAdjust);
                } else {
                    this.fromDialog.getDialogPane().setEffect((Effect)colorAdjust);
                }
            });
            this.setOnHiding(e -> {
                if (this.fromDialog == null) {
                    NamaDialog.fetchCurrentScreenRoot().setEffect(null);
                } else {
                    this.fromDialog.getDialogPane().setEffect(null);
                }
            });
        }
    }

    private static NamaBorderPane fetchCurrentScreenRoot() {
        return POSResourcesUtil.currentScreen.fetchPane();
    }

    public NamaDialog(String title) {
        this(title, e -> {});
    }

    private void createTitlePane(String title) {
        if (ObjectChecker.isEmptyOrNull((Object)title)) {
            return;
        }
        this.titleLabel = new NamaLabel(title);
        this.titlePane = new NamaHBox(new Node[]{this.titleLabel});
        this.titlePane.getStyleClass().add((Object)"dialog-title");
        this.getDialogPane().setHeader((Node)this.titlePane);
    }

    private void createHeaderPane() {
        this.headerLabel = new NamaText("", new Object[0]);
        this.headerLabel.setId("header-label");
        this.headerPane = new NamaHBox(new Node[]{this.headerLabel});
        this.headerPane.getStyleClass().add((Object)"dialog-header");
        this.headerPane.setManaged(false);
    }

    private void createContentPane() {
        this.contentPane = new NamaHBox();
        this.contentPane.getStyleClass().add((Object)"dialog-content");
        NamaVBox.setVgrow((Node)this.contentPane, (Priority)Priority.ALWAYS);
    }

    private void createFooterPane() {
        this.ok = new NamaButton("confirm");
        this.ok.getStyleClass().add((Object)"apply-button");
        Platform.runLater(() -> this.ok.requestFocus());
        ButtonType applyButtonType = new ButtonType(POSResourcesUtil.id("confirm", new Object[0]), ButtonBar.ButtonData.APPLY);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{applyButtonType});
        Button applyBtn = (Button)this.getDialogPane().lookupButton(applyButtonType);
        applyBtn.setManaged(false);
        this.ok.setOnAction(e -> {
            this.okAction.accept((ActionEvent)e);
            if (ObjectChecker.isFalseOrNull((Boolean)this.hasErrors)) {
                applyBtn.fire();
            }
        });
        this.cancel = new NamaButton("cancel");
        ButtonType cancelButtonType = new ButtonType(POSResourcesUtil.id("cancel", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{cancelButtonType});
        Button cancelBtn = (Button)this.getDialogPane().lookupButton(cancelButtonType);
        cancelBtn.setManaged(false);
        this.cancel.setOnAction(e -> cancelBtn.fire());
        this.footerPane = new NamaHBox();
        this.footerPane.getStyleClass().add((Object)"dialog-footer");
        this.footerPane.setManaged(false);
    }

    public void title(String title) {
        this.titleLabel.setText(POSResourcesUtil.id(title, new Object[0]));
    }

    public void headerText(String headerText) {
        if (ObjectChecker.isEmptyOrNull((Object)headerText)) {
            return;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)this.headerPane.isManaged())) {
            this.headerPane.setManaged(true);
        }
        this.headerLabel.setText(POSResourcesUtil.id(headerText, new Object[0]));
        if (this.validFailureFirstTime) {
            if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getFullScreenPaymentDialogs())) {
                this.setHeight(this.getHeight() + 50.0);
            }
            this.validFailureFirstTime = false;
        }
    }

    public void content(Node node) {
        this.contentPane.getChildren().clear();
        this.contentPane.getChildren().add((Object)node);
    }

    public void setOkAction(Consumer<ActionEvent> okAction) {
        this.okAction = okAction;
    }

    public void addTitlePane(String title) {
        this.createTitlePane(title);
    }

    public void addButtonToFooter(Button footerButton) {
        this.footerPane.getChildren().add((Object)footerButton);
    }

    public void addFooterPane() {
        this.footerPane.setManaged(true);
    }

    public void addOkButton(String text) {
        if (this.footerPane.getChildren().contains((Object)this.ok)) {
            return;
        }
        this.addFooterPane();
        if (ObjectChecker.isNotEmptyOrNull((Object)text)) {
            this.ok.setText(POSResourcesUtil.id(text, new Object[0]));
        }
        this.footerPane.getChildren().add((Object)this.ok);
    }

    public Button fetchOkBtn() {
        return this.ok;
    }

    public Button fetchCancelBtn() {
        return this.cancel;
    }

    public void addCancelButton(String text) {
        if (this.footerPane.getChildren().contains((Object)this.cancel)) {
            return;
        }
        this.addFooterPane();
        if (ObjectChecker.isNotEmptyOrNull((Object)text)) {
            this.cancel.setText(POSResourcesUtil.id(text, new Object[0]));
        }
        this.footerPane.getChildren().add((Object)this.cancel);
    }

    public void addESCActionExplicitly() {
        this.addCancelButton("");
        this.cancel.setManaged(false);
    }

    public void requestFocus() {
        this.ok.requestFocus();
    }

    public boolean focused() {
        return this.ok.isFocused();
    }

    public void fromDialog(Dialog dialog) {
        this.fromDialog = dialog;
    }

    public void addScrollPane() {
        ScrollPane scrollPane = new ScrollPane((Node)new NamaVBox(new Node[]{this.headerPane, this.contentPane}));
        scrollPane.setFitToWidth(true);
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        NamaVBox content = new NamaVBox(new Node[]{scrollPane, this.footerPane});
        content.getStyleClass().add((Object)"nama-dialog-scrollable-content");
        this.getDialogPane().setContent((Node)content);
    }

    public void error(String error) {
        this.hasErrors = true;
        this.headerText(error);
    }

    public void removeErrors() {
        this.hasErrors = false;
        this.headerPane.setManaged(false);
    }
}

