/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.util.POSScreenSettings;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;

public class NamaLabel
extends Label
implements IHasFont {
    private String originalText;

    public NamaLabel(String text) {
        this(text, true);
    }

    public NamaLabel(String text, boolean sizing) {
        super(POSResourcesUtil.id(text, new Object[0]));
        this.originalText = text;
        this.setWrapText(true);
        if (ObjectChecker.isTrue((Boolean)sizing)) {
            this.sizing();
        }
        NamaTextField.addEnterAndTabEvents((Control)this);
    }

    private void sizing() {
        this.autosize();
        this.setMinWidth(90.0);
        POSSettingsUtil.setFonts(POSScreenSettings.getTextFieldsFont(), this.getClass().getClassLoader(), new Node[]{this});
    }

    public NamaLabel() {
        this("", false);
    }

    public NamaLabel(String text, String namaStyle) {
        this(text);
        this.setStyle(namaStyle);
        NamaTextField.addEnterAndTabEvents((Control)this);
    }

    @Override
    public void refreshContent() {
        String text = POSResourcesUtil.id(this.originalText, new Object[0]);
        if (ObjectChecker.isNotEmptyOrNull((Object)text)) {
            this.setText(text);
        }
    }
}

