/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.constants.DateWrapper;
import com.namasoft.common.constants.Operator;
import com.namasoft.common.criteria.DTOCriteria;
import com.namasoft.common.criteria.DTOCriteriaBuilder;
import com.namasoft.common.criteria.DTOExperssion;
import com.namasoft.common.criteria.ExpressionRelationship;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.flatobjects.FieldTypesUtils;
import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.layout.Owner;
import com.namasoft.common.layout.metadata.FieldType;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.DTOPageData;
import com.namasoft.contracts.common.dtos.EntityDimensionsDTO;
import com.namasoft.contracts.common.dtos.requests.FindByIDRequest;
import com.namasoft.contracts.common.dtos.requests.ListRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.DTOTabularResult;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListEntityResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.contracts.common.services.BaseEntityServiceProxy;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.basic.enums.ViewModificationType;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTODocsToPayFromPosEntry;
import com.namasoft.modules.commonbasic.enums.SortType;
import com.namasoft.modules.namapos.contracts.common.DTODocToPayReq;
import com.namasoft.modules.namapos.contracts.details.DTOPOSFilterDimensionsLine;
import com.namasoft.modules.namapos.enums.POSSalesHeaderField;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.modules.supplychain.contracts.details.DTOBasicSCDocumentLine;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaCheckBox;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.OperatorForCombo;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosCopyMenu;
import com.namasoft.namacontrols.PosCustomToolTipUtil;
import com.namasoft.namacontrols.tablecells.ItemImageCell;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.AbsPOSPayReceipt;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.AbsPOSUISettingsSearchDialogueLine;
import com.namasoft.pos.domain.details.HasCheckBox;
import com.namasoft.pos.domain.details.POSExtraFilterLine;
import com.namasoft.pos.domain.details.POSScrapDocLine;
import com.namasoft.pos.domain.details.POSShortfallsDocLine;
import com.namasoft.pos.domain.details.PosStockReceiptLine;
import com.namasoft.pos.domain.entities.IPOSDocFromInvoice;
import com.namasoft.pos.domain.entities.POSActionHistory;
import com.namasoft.pos.domain.entities.POSAnalysisset;
import com.namasoft.pos.domain.entities.POSBranch;
import com.namasoft.pos.domain.entities.POSCreditNote;
import com.namasoft.pos.domain.entities.POSDepartment;
import com.namasoft.pos.domain.entities.POSEmployee;
import com.namasoft.pos.domain.entities.POSExtraFilter;
import com.namasoft.pos.domain.entities.POSGenReference;
import com.namasoft.pos.domain.entities.POSInvoiceClassification;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSLegalEntity;
import com.namasoft.pos.domain.entities.POSLocation;
import com.namasoft.pos.domain.entities.POSOrderReservation;
import com.namasoft.pos.domain.entities.POSRegistery;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReplacement;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSScrapDoc;
import com.namasoft.pos.domain.entities.POSSector;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.entities.POSShortfallsDoc;
import com.namasoft.pos.domain.entities.POSStockReceipt;
import com.namasoft.pos.domain.entities.POSStockTransferReq;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.entities.POSUnit;
import com.namasoft.pos.domain.entities.POSVendor;
import com.namasoft.pos.domain.entities.POSWarehouse;
import com.namasoft.pos.domain.entities.PosDocCategory;
import com.namasoft.pos.domain.entities.PosNamaDocToPay;
import com.namasoft.pos.domain.entities.PosNamaObject;
import com.namasoft.pos.domain.valueobjects.POSDimInfo;
import com.namasoft.pos.domain.valueobjects.POSFieldFilterPart;
import com.namasoft.pos.domain.valueobjects.POSGenericDims;
import com.namasoft.pos.domain.valueobjects.POSItemSpecificDimensions;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.util.POSDataWriterUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSScreenSettings;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.POSWSClient;
import com.namasoft.pos.util.TableCellCreatorUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class NamaPOSSearchDialog<T extends Node>
extends NamaDialog<ButtonType> {
    private NamaTableView<POSMasterFile> table;
    private NamaLabel selectedCountLabel;
    private NamaLabel allRecordsCountLabel;
    private NamaLabel pageNoLabel;
    private Class onKlass;
    private POSMasterFile sampleObject;
    private DTOPageData paginationData;
    private CheckBox selectAll;
    private int numberOfRecordsToSelect = 0;
    private NamaTextField recordsCountPerPageField;
    private ComboBox<String> orderByField1 = new ComboBox();
    private ComboBox<String> orderByField2 = new ComboBox();
    private ComboBox<String> orderByField3 = new ComboBox();
    private ComboBox<String> sortTypeComboBox = new ComboBox();
    private String fieldId;
    private IHasToolBar screen;
    private String predefinedCountCondition;
    private String namaTypeToSearchIn;
    private List<POSFieldFilterPart> filterByTextFields = new ArrayList<POSFieldFilterPart>();
    private List columnList;
    private NamaButton searchBtn = new NamaButton();
    private String basicCondition;
    private Map<String, Object> basicConditionParams;
    private String entityType;
    private Node firstFilter = null;
    private NamaCheckBox searchInAllRegisters = new NamaCheckBox("searchInAllRegisters");
    public boolean heldInvoicesScreen;
    private static Map<Class<?>, POSSecurityCapability> capabilities = new HashMap();
    private static HashMap<String, String> entityTypeWithFieldId;
    private static HashMap<String, Function<POSGenericDims, POSDimInfo>> entityTypeWithRegisterDimId;
    private static HashMap<String, UUID> publicDimsIDs;

    public NamaPOSSearchDialog() {
        this("");
    }

    public String getNamaTypeToSearchIn() {
        return this.namaTypeToSearchIn;
    }

    public void setNamaTypeToSearchIn(String namaTypeToSearchIn) {
        this.namaTypeToSearchIn = namaTypeToSearchIn;
    }

    public NamaPOSSearchDialog(String fieldId) {
        super(fieldId);
        this.fieldId = fieldId;
        this.getDialogPane().setCenterShape(true);
        this.getDialogPane().setOnKeyPressed(e -> {
            if (e.getCode().equals((Object)KeyCode.ENTER) && this.focused()) {
                this.fetchOkBtn().fire();
            }
        });
        this.getDialogPane().getStyleClass().add((Object)"search-dialog");
    }

    public void setPredefinedCountCondition(String predefinedCountCondition) {
        this.predefinedCountCondition = predefinedCountCondition;
    }

    public void showDialog(ActionEvent event, NamaSearchBox searchBox) {
        this.updateOnKlass(searchBox.getOnKlass());
        this.screen = searchBox.getScreen();
        HashMap<String, Object> params = new HashMap<String, Object>();
        POSSearchRequest searchRequest = new POSSearchRequest();
        searchRequest.klass = this.onKlass;
        searchRequest.fieldId = this.fieldId;
        searchRequest.screen = searchBox.getScreen();
        searchRequest.customeType = searchBox.getCustomeType();
        searchRequest.parameters = params;
        searchRequest.fromOpenDocAction = ObjectChecker.isTrue((Boolean)searchBox.getFromOpenDocAction());
        searchRequest.searchInAllRegisters = this.searchInAllRegisters.isSelected();
        searchRequest.register = POSResourcesUtil.fetchMainRegister();
        String condition = NamaPOSSearchDialog.calcCondition(searchRequest);
        this.showDialog(event, searchBox, condition, params, 0);
    }

    public void showDialog(ActionEvent event, NamaSearchBox searchBox, String queryCondition, Map<String, Object> params, int numberOfRecords) {
        this.basicCondition = NamaPOSSearchDialog.addExtraCondition(this.screen == null ? searchBox.getScreen() : this.screen, this.fieldId, queryCondition, params);
        this.basicConditionParams = params;
        this.initializeFields(searchBox.getOnKlass());
        this.numberOfRecordsToSelect = numberOfRecords;
        double width = searchBox.getScreen().fetchStage().getWidth();
        double height = searchBox.getScreen().fetchStage().getHeight();
        Rectangle2D primaryScreenBounds = new Rectangle2D(0.0, 0.0, width, height);
        double defaultCellWidth = primaryScreenBounds.getWidth() / (double)this.fetchRecordsCountPerPage();
        if (!this.sampleObject.canSearchOn()) {
            return;
        }
        if (POSResourcesUtil.currentScreen.document() instanceof IPOSDocFromInvoice && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanSearchOnInvoiceInReturnAndReplacement).isFailed().booleanValue()) {
            POSErrorAndInfoMessagesUtil.showError("User can not search on invoice in return and replacement", POSResourcesUtil.fetchCurrentScreenStage());
            return;
        }
        this.setResizable(true);
        if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getFullScreenSearchDialogs()) || ObjectChecker.areAllEmptyOrZero((Long[])new Long[]{(long)POSScreenSettings.getSearchDialogWidth(), (long)POSScreenSettings.getSearchDialogHeight()})) {
            Stage window = (Stage)this.getDialogPane().getScene().getWindow();
            if (!window.isMaximized()) {
                window.setMaximized(true);
            }
            Rectangle2D primaryScreenBounds_ = Screen.getPrimary().getVisualBounds();
            this.getDialogPane().setPrefHeight(primaryScreenBounds_.getHeight() - 25.0);
            this.getDialogPane().setPrefWidth(primaryScreenBounds_.getWidth());
        } else {
            if (POSScreenSettings.getSearchDialogWidth() != 0.0) {
                this.getDialogPane().setPrefWidth(POSScreenSettings.getSearchDialogWidth());
            }
            if (POSScreenSettings.getSearchDialogHeight() != 0.0) {
                this.getDialogPane().setPrefHeight(POSScreenSettings.getSearchDialogHeight());
            }
            this.getDialogPane().widthProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    POSScreenSettings.getProperties().setProperty("searchDialogW", String.valueOf(newValue));
                    POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
                }
            });
            this.getDialogPane().heightProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue != null) {
                    POSScreenSettings.getProperties().setProperty("searchDialogH", String.valueOf(newValue));
                    POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
                }
            });
        }
        this.constructTable(defaultCellWidth, primaryScreenBounds, searchBox, event);
        this.initStyle(StageStyle.DECORATED);
        NamaVBox content = new NamaVBox(new Node[]{this.createFilterFieldsGrid(), this.table, this.createFooter()});
        NamaHBox.setHgrow((Node)content, (Priority)Priority.ALWAYS);
        this.content((Node)content);
        this.addOkButton("ok");
        this.addCancelButton("cancel");
        if (this.heldInvoicesScreen) {
            NamaButton deleteSelectedBtn = this.constructDeleteSelectedBtn(searchBox);
            this.addButtonToFooter(deleteSelectedBtn);
        }
        this.showSearchdialogandWait(event, searchBox);
    }

    private GridPane createFilterFieldsGrid() {
        GridPane filterFieldsGrid = new GridPane();
        filterFieldsGrid.setId("search-dialog-filter-fields-grid");
        NamaHBox.setHgrow((Node)filterFieldsGrid, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        filterFieldsGrid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        int filtersCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        List<Object> filterByFields = POSUISettingsUtil.posUISettings.getSearchDialogueFilters().stream().filter(l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)this.sampleObject.calcNamaEntityType())).map(AbsPOSUISettingsSearchDialogueLine::getFieldId).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(filterByFields)) {
            filterByFields = this.sampleObject.filterByFields();
        }
        for (String fieldId : filterByFields) {
            if (filtersCount != 0 && filtersCount % 2 == 0) {
                ++rowIndex;
                colIndex = 0;
            }
            POSFieldFilterPart fieldFilterPart = new POSFieldFilterPart(fieldId, e -> this.searchBtn.fire(), this.onKlass, this.screen);
            filterFieldsGrid.add(fieldFilterPart, colIndex, rowIndex);
            Object t = fieldFilterPart.getTextField();
            if (t instanceof TextField) {
                TextField textField = (TextField)t;
                textField.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                    if (ObjectChecker.NOTisAnyEqualToFirst((Object)event.getCode(), (Object[])new KeyCode[]{KeyCode.DOWN, KeyCode.UP})) {
                        return;
                    }
                    Platform.runLater(() -> {
                        this.table.requestFocus();
                        this.table.getSelectionModel().selectFirst();
                        event.consume();
                    });
                });
            }
            this.filterByTextFields.add(fieldFilterPart);
            if (this.firstFilter == null) {
                this.firstFilter = fieldFilterPart.getTextField();
            }
            ++filtersCount;
            ++colIndex;
        }
        return filterFieldsGrid;
    }

    private void initializeFields(Class<?> onKlass) {
        this.updateOnKlass(onKlass);
        this.entityType = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{POSResourcesUtil.calcEntityType(this.onKlass), this.namaTypeToSearchIn});
        this.allRecordsCountLabel = new NamaLabel();
        int recordsCount = this.fetchRecordsCount(this.basicCondition, this.basicConditionParams);
        this.selectedCountLabel = new NamaLabel();
        this.paginationData = new DTOPageData();
        int pageSize = this.fetchRecordsCountPerPage();
        this.paginationData.setPageSize(pageSize);
        this.paginationData.setPagesCount(this.calcPagesCount(recordsCount));
        this.recordsCountPerPageField = new NamaTextField(POSFieldType.Integer);
        AbsPosSalesScreen.preventNegativeSignAndChars(this.recordsCountPerPageField);
        this.recordsCountPerPageField.setPromptText(POSResourcesUtil.id("recordsCountPerPage", new Object[0]));
        this.recordsCountPerPageField.setText(ObjectChecker.toStringOrEmpty((Object)pageSize));
        this.recordsCountPerPageField.setOnKeyPressed(event1 -> {
            if (ObjectChecker.areEqual((Object)event1.getCode(), (Object)KeyCode.ENTER)) {
                this.firePagesCountAction((Integer)this.recordsCountPerPageField.fetchValue());
            }
        });
        this.pageNoLabel = new NamaLabel();
        this.updateCountFields(recordsCount);
        ObservableList filterByFields = FXCollections.observableArrayList(this.sampleObject.filterByFields());
        String defaultOrderByField = POSUISettingsUtil.fetchOrderByFieldFor(this.entityType);
        if (ObjectChecker.isNotEmptyOrNull((Object)defaultOrderByField) && ObjectChecker.isFalse((Boolean)filterByFields.contains((Object)defaultOrderByField))) {
            filterByFields.add((Object)defaultOrderByField);
        }
        this.orderByField1.setItems(filterByFields);
        this.orderByField1.getSelectionModel().select((Object)((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{defaultOrderByField, (String)CollectionsUtility.getFirst((List)filterByFields)})));
        this.orderByField2.setItems(filterByFields);
        this.orderByField3.setItems(filterByFields);
        this.orderByField1.setConverter(this.orderByComboBoxConverter());
        this.orderByField2.setConverter(this.orderByComboBoxConverter());
        this.orderByField3.setConverter(this.orderByComboBoxConverter());
        this.sortTypeComboBox.setItems(FXCollections.observableArrayList((Object[])new String[]{"asc", "desc"}));
        this.sortTypeComboBox.setConverter(this.orderByComboBoxConverter());
        this.sortTypeComboBox.getSelectionModel().select((Object)this.fetchSortType());
    }

    private String fetchSortType() {
        String defaultSortType = "ASC";
        if (ObjectChecker.areEqual((Object)POSUISettingsUtil.fetchSortTypeFor(this.entityType), (Object)SortType.Descending)) {
            defaultSortType = "DESC";
        }
        return (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{(String)this.sortTypeComboBox.getValue(), defaultSortType});
    }

    private void constructTable(double defaultCellWidth, Rectangle2D primaryScreenBounds, NamaSearchBox searchBox, ActionEvent event) {
        this.table = new NamaTableView();
        this.fetchOkBtn().setOnKeyPressed(e -> {
            boolean close;
            if (e.getCode().equals((Object)KeyCode.ENTER) && (close = this.fireSelectAction(searchBox, this.table, (Event)event))) {
                this.close();
            }
        });
        new PosCopyMenu((Control)this.table).bind();
        TableCellCreatorUtil creatorUtil = new TableCellCreatorUtil(primaryScreenBounds, defaultCellWidth, ObjectChecker.isEmptyOrNull((Object)this.namaTypeToSearchIn) ? this.onKlass : PosNamaObject.class);
        this.columnList = this.sampleObject.createColumnList(creatorUtil);
        this.table.getColumns().clear();
        this.addSelectionColIfNeeded(defaultCellWidth);
        List<String> fields = POSUISettingsUtil.posUISettings.getSearchDialogueFields().stream().filter(l -> ObjectChecker.areEqual((Object)l.getNamaEntityType(), (Object)this.sampleObject.calcNamaEntityType())).map(AbsPOSUISettingsSearchDialogueLine::getFieldId).collect(Collectors.toList());
        List<Object> columns = new ArrayList();
        List<POSTableColumn> calculatedColumns = this.sampleObject.createCalculatedColumnList(creatorUtil);
        if (ObjectChecker.isEmptyOrNull(fields)) {
            this.columnList = this.sampleObject.createColumnList(creatorUtil);
            columns.addAll(this.columnList);
            columns.addAll(calculatedColumns);
        } else {
            columns = this.sampleObject.createColumnList(creatorUtil);
            String viewModificationMode = POSUISettingsUtil.fetchViewModificationMode(this.entityType);
            if (ObjectChecker.areEqual((Object)viewModificationMode, (Object)ViewModificationType.OverrideExisting.name())) {
                columns = new ArrayList();
            }
            columns.addAll(creatorUtil.createColumns(fields));
            if (ObjectChecker.isEmptyOrNull(columns)) {
                columns = this.sampleObject.createColumnList(creatorUtil);
            }
            this.columnList = columns.stream().filter(l -> !calculatedColumns.contains(l)).collect(Collectors.toList());
        }
        columns.forEach(arg_0 -> this.table.getColumns().add(arg_0));
        if (this.onKlass == POSItem.class) {
            POSTableColumn racksCol = new POSTableColumn("rackCodes");
            racksCol.setPrefWidth(primaryScreenBounds.getWidth() / 14.0);
            racksCol.setCellValueFactory((Callback)new PropertyValueFactory("racksCodes"));
            racksCol.setId("posRacksCodes");
            racksCol.setCellFactory(POSTableCell.defaultCellFactory());
            if (ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getAddRackCodeFields())) {
                this.table.getColumns().add(racksCol);
            }
            if (POSResourcesUtil.getUseItemsImage()) {
                TableColumn imgCol = new TableColumn(POSResourcesUtil.id("image", new Object[0]));
                imgCol.setPrefWidth(primaryScreenBounds.getWidth() / 14.0);
                imgCol.setCellValueFactory((Callback)new PropertyValueFactory("imgDownloadLink"));
                imgCol.setCellFactory(param -> new ItemImageCell());
                imgCol.setId("posItemImage");
                this.table.getColumns().add((Object)imgCol);
            }
        }
        this.table.getColumns().forEach(column -> {
            String propertyId = (ObjectChecker.isEmptyOrNull((Object)this.onKlass) ? this.namaTypeToSearchIn : this.onKlass.getSimpleName()) + "." + column.getId();
            column.widthProperty().addListener((observable, oldValue, newValue) -> {
                if (ObjectChecker.areNotEqual((Object)newValue, (Object)oldValue)) {
                    POSScreenSettings.getProperties().setProperty(propertyId, newValue.toString());
                }
                POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
            });
            String propertyValue = (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{POSScreenSettings.getProperties().getProperty(column.getId()), POSScreenSettings.getProperties().getProperty(propertyId)});
            if (ObjectChecker.isNotEmptyOrNull((Object)propertyValue)) {
                column.setPrefWidth(Double.valueOf(propertyValue).doubleValue());
            } else {
                column.setPrefWidth(this.getDialogPane().getPrefWidth() / (double)this.table.getColumns().size());
            }
        });
        this.table.setPrefHeight(this.getDialogPane().getPrefHeight() / 1.3);
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(t -> {
                if (t.getClickCount() == 2 && !row.isEmpty()) {
                    this.fireSelectAction(searchBox, this.table, t);
                }
            });
            row.setOnKeyPressed(e -> {
                if (e.getCode().equals((Object)KeyCode.ENTER) && this.table.getSelectionModel().getSelectedItem() != null) {
                    this.fireSelectAction(searchBox, this.table, e);
                }
            });
            return row;
        });
        this.table.setOnKeyPressed(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            POSMasterFile selectedItem = (POSMasterFile)this.table.getSelectionModel().getSelectedItem();
            if (selectedItem != null) {
                this.fireSelectAction(searchBox, this.table, e);
            }
        });
        this.updateSearchTableContent(this.fetchRecords(this.basicCondition, this.basicConditionParams, this.paginationData.firstPage()));
    }

    private void addSelectionColIfNeeded(double defaultCellWidth) {
        if (this.onKlass != POSItem.class && !this.heldInvoicesScreen) {
            return;
        }
        POSTableColumn selectCol = new POSTableColumn();
        selectCol.setId("posSelectBox");
        this.selectAll = new CheckBox();
        this.selectAll.setId("check-box-column-header-cell");
        selectCol.setGraphic((Node)this.selectAll);
        POSSettingsUtil.setFonts(20.0, ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this.selectAll});
        this.selectAll.setOnAction(this.selectAllItems());
        selectCol.setEditable(true);
        selectCol.setCellValueFactory(param -> {
            HasCheckBox hasCheckBox = (HasCheckBox)param.getValue();
            CheckBox checkBox = new CheckBox();
            checkBox.selectedProperty().setValue(hasCheckBox.fetchSelectionProperty());
            checkBox.selectedProperty().addListener((ov, old_val, new_val) -> this.selectLine(hasCheckBox, (Boolean)new_val));
            return new SimpleObjectProperty((Object)checkBox);
        });
        selectCol.setPrefWidth(defaultCellWidth);
        this.table.getColumns().addAll((Object[])new TableColumn[]{selectCol});
    }

    private Pane createFooter() {
        GridPane footerPane = new GridPane();
        footerPane.setId("search-dialog-footer-pane");
        NamaHBox sortComboBox = new NamaHBox(new Node[]{new NamaLabel("OrderBy"), new NamaVBox(new Node[]{this.sortTypeComboBox, new NamaHBox(new Node[]{this.orderByField1, this.orderByField2, this.orderByField3})})});
        NamaHBox navigationPane = this.createNavigationPane();
        footerPane.add((Node)this.allRecordsCountLabel, 0, 0);
        footerPane.add((Node)new NamaLabel("recordsCountPerPage"), 1, 0);
        footerPane.add((Node)sortComboBox, 2, 0, 1, 2);
        footerPane.add((Node)this.searchInAllRegisters, 3, 1);
        footerPane.add((Node)navigationPane, 4, 0);
        GridPane.setHgrow((Node)navigationPane, (Priority)Priority.ALWAYS);
        footerPane.add((Node)this.pageNoLabel, 0, 1);
        footerPane.add((Node)this.recordsCountPerPageField, 1, 1);
        return footerPane;
    }

    private NamaHBox createNavigationPane() {
        this.searchBtn.setSVGIcon("searchInT.svg");
        this.searchBtn.setTooltip(new POSTooltip("search"));
        this.searchBtn.setOnAction(e -> this.searchAction());
        NamaButton firstPage = new NamaButton();
        firstPage.setSVGIcon("firstPage.svg");
        firstPage.getGraphic().setNodeOrientation(POSResourcesUtil.getOrientation());
        firstPage.setTooltip(new POSTooltip("firstPage"));
        firstPage.setOnAction(event1 -> this.firstPage());
        NamaButton lastPage = new NamaButton();
        lastPage.setSVGIcon("lastPage.svg");
        lastPage.getGraphic().setNodeOrientation(POSResourcesUtil.getOrientation());
        lastPage.setTooltip(new POSTooltip("lastPage"));
        lastPage.setOnAction(event12 -> this.lastPage());
        NamaButton nextBtn = new NamaButton();
        nextBtn.setSVGIcon("next.svg");
        nextBtn.getGraphic().setNodeOrientation(POSResourcesUtil.getOrientation());
        nextBtn.setTooltip(new POSTooltip("next"));
        nextBtn.setOnAction(e -> this.nextPage());
        NamaButton previousBtn = new NamaButton();
        previousBtn.setSVGIcon("prev.svg");
        previousBtn.getGraphic().setNodeOrientation(POSResourcesUtil.getOrientation());
        previousBtn.setTooltip(new POSTooltip("previous"));
        previousBtn.setOnAction(e -> this.previousPage());
        NamaHBox navigationPane = new NamaHBox(new Node[]{this.searchBtn, firstPage, previousBtn, nextBtn, lastPage});
        navigationPane.setId("navigation-pane");
        return navigationPane;
    }

    private int calcPagesCount(int records) {
        return Double.valueOf(Math.ceil((double)records / (double)this.fetchRecordsCountPerPage())).intValue();
    }

    private void lastPage() {
        this.navigateToPage(this.paginationData.lastPage());
    }

    private void firstPage() {
        this.navigateToPage(this.paginationData.firstPage());
    }

    private void nextPage() {
        this.navigateToPage(this.paginationData.nextPage());
    }

    private void previousPage() {
        this.navigateToPage(this.paginationData.previousPage());
    }

    private void navigateToPage(DTOPageData pageData) {
        String condition = this.addCodePartToCondition(this.basicCondition, this.filterByTextFields);
        HashMap<String, Object> allParams = this.constructSearchParams(this.filterByTextFields);
        allParams.putAll(this.basicConditionParams);
        condition = NamaPOSSearchDialog.addRegisterConditionIfNeeded(POSResourcesUtil.fetchMainRegister(), this.onKlass, this.searchInAllRegisters.isSelected(), allParams, condition);
        List<POSMasterFile> records = this.fetchRecords(condition, allParams, pageData);
        this.updateRecordsCountPerPageFields();
        this.updateSearchTableContent(records);
    }

    private void updateOnKlass(Class<?> onKlass) {
        this.onKlass = onKlass;
        this.sampleObject = onKlass == null ? new PosNamaObject() : (POSMasterFile)ObjectCreatorUtil.creator(onKlass).create();
    }

    private NamaButton constructDeleteSelectedBtn(NamaSearchBox searchBox) {
        NamaButton deleteSelectedBtn = new NamaButton("removeSelectedInvoices");
        deleteSelectedBtn.setTooltip(new POSTooltip("removeSelectedInvoices"));
        deleteSelectedBtn.setId("delete-held-invoices-button");
        deleteSelectedBtn.setDisable(POSSecurityUtil.userCan(POSSecurityCapability.CanDeleteHold).isFailed());
        deleteSelectedBtn.setOnAction(e -> {
            List<POSMasterFile> selectedItems = this.table.getItems().stream().filter(i -> i.getSelected()).collect(Collectors.toList());
            AbsPosSalesScreen absPosScreen = (AbsPosSalesScreen)(this.screen == null ? searchBox.getScreen() : this.screen);
            if (!PosScene.confirmDelete(e, this, this.screen)) {
                return;
            }
            if (ObjectChecker.areEqual((Object)this.onKlass, POSSalesInvoice.class)) {
                ArrayList<POSSalesInvoice> invoices = new ArrayList<POSSalesInvoice>();
                selectedItems.forEach(i -> invoices.add((POSSalesInvoice)i));
                AbsPosSalesScreen.deletePOSHeldSalesInvoices(e, absPosScreen, invoices, this::afterDeleteAction);
                return;
            }
            for (POSMasterFile selectedItem : selectedItems) {
                AbsPosSalesScreen.deleteAction(e, absPosScreen, (AbsPOSSales)selectedItem);
            }
            this.afterDeleteAction();
        });
        return deleteSelectedBtn;
    }

    private void afterDeleteAction() {
        this.searchBtn.fire();
        this.selectedCountLabel.setText(this.calcTableSelectedLines(this.table).toString());
        this.selectAll.setSelected(false);
    }

    private int fetchRecordsCount(String condition, Map<String, Object> params) {
        Number count = 0;
        count = ObjectChecker.isNotEmptyOrNull((Object)this.getNamaTypeToSearchIn()) ? (Number)this.countNamaDocs() : (Number)(ObjectChecker.areEqual((Object)this.onKlass, PosNamaDocToPay.class) ? (Number)this.countDocsToPaySize() : (Number)(ObjectChecker.isNotEmptyOrNull((Object)this.predefinedCountCondition) && !condition.startsWith(this.predefinedCountCondition) ? (Number)POSPersister.count(this.onKlass, this.predefinedCountCondition, params, false) : (Number)POSPersister.count(this.onKlass, condition, params, false)));
        return count;
    }

    private int countNamaDocs() {
        List<POSMasterFile> posMasterFiles = this.fetchListOfNamaDocs("", -1, 0);
        return ObjectChecker.isEmptyOrNull(posMasterFiles) ? 0 : posMasterFiles.size();
    }

    private List<? extends POSMasterFile> fetchListOfNamaDocs(String orderBy) {
        return this.fetchListOfNamaDocs(orderBy, this.paginationData.getPageSize(), this.paginationData.getPageNumber());
    }

    private List<? extends POSMasterFile> fetchListOfNamaDocs(String orderBy, int pageSize, int pageNum) {
        BaseEntityServiceProxy ws = (BaseEntityServiceProxy)ServiceUtility.getServiceClient((String)this.namaTypeToSearchIn);
        ListRequest request = new ListRequest();
        request.setCriteria(this.calcCriteriaByType());
        request.setStartPage(pageNum);
        request.setOrderBy(orderBy);
        request.setAscending(ObjectChecker.isAnyEqualToFirst((Object)((String)this.sortTypeComboBox.getValue()), (Object[])new String[]{"asc", null}));
        request.setPageSize(pageSize);
        request.setOwner(Owner.entity((String)this.namaTypeToSearchIn));
        request.setDisplayedColumns(Arrays.asList("code", "valueDate", "supplier", "purchasesMan"));
        request.setDimensionsIds(this.calcEntityDimensions());
        ListEntityResult list = ws.list(request);
        List pages = list.getPage();
        ArrayList<PosNamaObject> listOfObj = new ArrayList<PosNamaObject>();
        if (ObjectChecker.isNotEmptyOrNull((Object)pages)) {
            for (DTOTabularResult tabularResult : pages) {
                String code = (String)tabularResult.get("code");
                String id = (String)tabularResult.get("id");
                Date valueDate = ((DateWrapper)tabularResult.get("valueDate")).toDate();
                EntityReferenceData supplier = (EntityReferenceData)tabularResult.get("supplier");
                EntityReferenceData purchasesMan = (EntityReferenceData)tabularResult.get("purchasesMan");
                PosNamaObject obj = new PosNamaObject();
                listOfObj.add(obj);
                obj.setCode(code);
                obj.setId(UUID.fromString(id));
                obj.setValueDate(valueDate);
                if (supplier != null) {
                    obj.setSupplier(POSPersister.findByID(POSVendor.class, supplier.getId()));
                }
                if (purchasesMan == null) continue;
                obj.setPurchasesMan(POSPersister.findByID(POSEmployee.class, purchasesMan.getId()));
            }
        }
        return listOfObj;
    }

    private EntityDimensionsDTO calcEntityDimensions() {
        POSGenericDims genericDims = POSResourcesUtil.fetchMainRegister().getGenericDims();
        EntityDimensionsDTO dimensionsIds = new EntityDimensionsDTO();
        dimensionsIds.setLegalEntity(new EntityReferenceData("LegalEntity", ServerStringUtils.toUUIDStr((Object)genericDims.getLegalEntity().getId())));
        dimensionsIds.setBranch(new EntityReferenceData("Branch", ServerStringUtils.toUUIDStr((Object)genericDims.getBranch().getId())));
        dimensionsIds.setSector(new EntityReferenceData("Sector", ServerStringUtils.toUUIDStr((Object)genericDims.getSector().getId())));
        dimensionsIds.setDepartment(new EntityReferenceData("Department", ServerStringUtils.toUUIDStr((Object)genericDims.getDepartment().getId())));
        dimensionsIds.setAnalysisSet(new EntityReferenceData("AnalysisSet", ServerStringUtils.toUUIDStr((Object)genericDims.getAnalysisSet().getId())));
        return dimensionsIds;
    }

    private DTOCriteria calcCriteriaByType() {
        POSWarehouse registerWarehouse = POSResourcesUtil.fetchMainRegister().getWarehouse();
        String warehouseId = ServerStringUtils.toUUIDStr((Object)registerWarehouse.getId());
        DTOCriteriaBuilder.DTOExpressionBuilder expressionBuilder = DTOCriteriaBuilder.create().field("toWarehouse.id").equal(warehouseId);
        if (ObjectChecker.areEqual((Object)this.namaTypeToSearchIn, (Object)"PurchaseInvoice")) {
            expressionBuilder = DTOCriteriaBuilder.create().field("warehouse.id").equal(warehouseId);
        }
        for (POSFieldFilterPart filterPart : this.filterByTextFields) {
            Object textField = filterPart.getTextField();
            if (!ObjectChecker.isNotEmptyOrNull((Object)((POSField)textField).fetchValue())) continue;
            DTOExperssion dtoExperssion = new DTOExperssion();
            dtoExperssion.setField(textField.getId());
            dtoExperssion.setOperator(Operator.valueOf((String)((OperatorForCombo)filterPart.getOperator().getValue()).getOperator().toString()));
            dtoExperssion.setRightHandSide(FieldTypesUtils.toString((FieldType)filterPart.getFieldType(), (Object)((POSField)textField).fetchValue()));
            dtoExperssion.setRelation(ExpressionRelationship.AND);
            expressionBuilder.build().getExpressions().add(dtoExperssion);
        }
        return expressionBuilder.build();
    }

    private Number countDocsToPaySize() {
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        POSGenericDims genericDims = posRegistery.getGenericDims();
        SendRequest request = new SendRequest((Object)((POSPaymentReciptScreen)this.screen).isPayment());
        request.setDoNotRememberLoginDimensions(Boolean.valueOf(true));
        EntityDimensionsDTO dimensionsIds = new EntityDimensionsDTO();
        dimensionsIds.setLegalEntity(new EntityReferenceData("LegalEntity", ServerStringUtils.toUUIDStr((Object)genericDims.getLegalEntity().getId())));
        dimensionsIds.setBranch(new EntityReferenceData("Branch", ServerStringUtils.toUUIDStr((Object)genericDims.getBranch().getId())));
        dimensionsIds.setSector(new EntityReferenceData("Sector", ServerStringUtils.toUUIDStr((Object)genericDims.getSector().getId())));
        dimensionsIds.setDepartment(new EntityReferenceData("Department", ServerStringUtils.toUUIDStr((Object)genericDims.getDepartment().getId())));
        dimensionsIds.setAnalysisSet(new EntityReferenceData("AnalysisSet", ServerStringUtils.toUUIDStr((Object)genericDims.getAnalysisSet().getId())));
        request.setDimensionsIds(dimensionsIds);
        GetResult<Long> result = POSWSClient.instance.countDocsToPay((SendRequest<Boolean>)request);
        return (Number)result.getData();
    }

    private int fetchRecordsCountPerPage() {
        return ObjectChecker.getFirstNotEmptyOrZero((Integer[])new Integer[]{POSUISettingsUtil.fetchRecordsCountPerPageFor(this.entityType), POSScreenSettings.getSearchRecordsCountPerPage(), POSUISettingsUtil.getPosUISettingsOptions().getSearchDialogRecordsCountPerPage(), 25});
    }

    private void firePagesCountAction(int recordsCountPerPage) {
        POSScreenSettings.getProperties().setProperty("searchDialogRecordsCount", String.valueOf(recordsCountPerPage));
        POSScreenSettings.saveSetting(POSScreenSettings.getProperties());
        this.paginationData.setPageSize(recordsCountPerPage);
        this.searchBtn.fire();
    }

    public StringConverter<String> orderByComboBoxConverter() {
        return new StringConverter<String>(this){

            public String toString(String object) {
                return POSResourcesUtil.id(object, new Object[0]);
            }

            public String fromString(String string) {
                return string;
            }
        };
    }

    public void showSearchdialogandWait(ActionEvent event, NamaSearchBox searchBox) {
        Platform.runLater(() -> this.firstFilter.requestFocus());
        Optional result = this.showAndWait();
        if (result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.APPLY) {
            boolean close = this.fireSelectAction(searchBox, this.table, (Event)event);
            if (!close) {
                this.showSearchdialogandWait(event, searchBox);
            }
        } else {
            this.close();
        }
    }

    public void selectLine(HasCheckBox hasCheckBox, Boolean new_val) {
        hasCheckBox.updateSelectionProperty(new_val);
        this.selectedCountLabel.setText(this.calcTableSelectedLines(this.table).toString());
    }

    private EventHandler<ActionEvent> selectAllItems() {
        return event -> {
            for (int i = 0; i < this.table.getItems().size(); ++i) {
                POSMasterFile hasCheckBox = (POSMasterFile)this.table.getItems().get(i);
                this.selectLine(hasCheckBox, this.selectAll.isSelected());
                this.table.getItems().set(i, (Object)hasCheckBox);
            }
        };
    }

    private void updateCountFields(Number recordsCount) {
        this.allRecordsCountLabel.setText(String.valueOf(recordsCount) + " " + POSResourcesUtil.id("records", new Object[0]));
        this.updateRecordsCountPerPageFields();
    }

    private void updateRecordsCountPerPageFields() {
        this.pageNoLabel.setText(this.paginationData.getPageNumber() + 1 + " " + POSResourcesUtil.id("of", new Object[0]) + " " + (int)Math.ceil(this.paginationData.getPagesCount()) + " " + POSResourcesUtil.id("page", new Object[0]));
    }

    public static String calcCondition(POSSearchRequest searchRequest) {
        boolean checkSellable;
        Integer gracePeriod;
        boolean fromInvoiceCode;
        Object condition = " where 1=1  ";
        if (ObjectChecker.areEqual(searchRequest.klass, PosNamaDocToPay.class) || searchRequest.klass == null) {
            return condition;
        }
        if (POSMasterFile.class.isAssignableFrom(searchRequest.klass)) {
            condition = (String)condition + " and (preventUsage is null or preventUsage = false) ";
        }
        boolean bl = fromInvoiceCode = ObjectChecker.areEqual((Object)searchRequest.fieldId, (Object)"fromInvoiceCode") && ObjectChecker.areEqual(searchRequest.klass, POSSalesInvoice.class) && searchRequest.screen instanceof AbsPosSalesScreen;
        if (fromInvoiceCode && ObjectChecker.isNotEmptyOrZero((Integer)(gracePeriod = ((AbsPosSalesScreen)searchRequest.screen).fetchInvoiceGracePeriod()))) {
            Date fromValueDate = LocalDateUtils.localDateToDate((LocalDate)LocalDate.now().minusDays(gracePeriod.intValue()));
            condition = (String)condition + " and valueDate >= :fromValueDate";
            searchRequest.parameters.put("fromValueDate", fromValueDate);
        }
        condition = NamaPOSSearchDialog.addCurrentShiftDataOnlyConditionIfNeeded(searchRequest.fromOpenDocAction, fromInvoiceCode, (String)condition, searchRequest.klass, searchRequest.parameters);
        condition = NamaPOSSearchDialog.addRegisterConditionIfNeeded(searchRequest.register, searchRequest.klass, searchRequest.searchInAllRegisters, searchRequest.parameters, (String)condition);
        if (ObjectChecker.isNotEmptyOrNull((Object)searchRequest.customeType) && ObjectChecker.areEqual(POSGenReference.class, searchRequest.klass)) {
            condition = (String)condition + " and type = '" + searchRequest.customeType + "'";
        }
        if (searchRequest.screen instanceof AbsPosSalesScreen) {
            condition = (String)condition + NamaPOSSearchDialog.calcSalesScreenCondition(searchRequest.klass, searchRequest.fieldId, (AbsPosSalesScreen)searchRequest.screen, searchRequest.parameters);
        }
        if (ObjectChecker.areEqual((Object)POSSalesHeaderField.SendToRegister, (Object)searchRequest.fieldId)) {
            condition = (String)condition + " and inActive = false and readOnlineOrdersFromCallCenter = true ";
        }
        if (ObjectChecker.areEqual(POSCreditNote.class, searchRequest.klass)) {
            condition = (String)condition + " and (deactivated = null or deactivated = false) ";
        }
        if (ObjectChecker.areEqual(POSOrderReservation.class, searchRequest.klass) && ObjectChecker.isFalseOrNull((Boolean)searchRequest.fromOpenDocAction)) {
            condition = (String)condition + " and (delivered = null or delivered = false) ";
        }
        if ((checkSellable = ObjectChecker.NOTisAnyEqualToFirst((Object)((Object)searchRequest.screen.documentType()), (Object[])new POSDocumentType[]{POSDocumentType.StockTransferReq, POSDocumentType.StockTakingDetails, POSDocumentType.ShortfallsDoc, POSDocumentType.ScrapDoc})) && ObjectChecker.areEqual(POSItem.class, searchRequest.klass)) {
            condition = (String)condition + " and (sellable = true or sellable is null) ";
        }
        if (searchRequest.screen instanceof POSPaymentReciptScreen) {
            if (ObjectChecker.areEqual(searchRequest.klass, PosDocCategory.class)) {
                condition = (String)condition + " and forType ='" + ((POSPaymentReciptScreen)searchRequest.screen).getPayReceipt().calcNamaEntityType() + "'";
            }
            if (ObjectChecker.areEqual(searchRequest.klass, POSPaymentMethod.class)) {
                condition = (String)condition + (((POSPaymentReciptScreen)searchRequest.screen).isPayment() ? " and (doNotUseInPosPayments is null or doNotUseInPosPayments = false)" : " and (doNotUseInPosReceipts is null or doNotUseInPosReceipts = false)");
            }
        }
        condition = (String)condition + NamaPOSSearchDialog.filterOnDimensionCriteria(searchRequest.klass, searchRequest.parameters, searchRequest.screen);
        return condition;
    }

    private static String addRegisterConditionIfNeeded(POSRegistery register, Class<?> klass, Boolean searchInAllRegisters, Map<String, Object> parameters, String condition) {
        String registerIdCondition = " and registerId = :registerId ";
        String registeryCondition = " and registery= :register ";
        if (ObjectChecker.isTrue((Boolean)searchInAllRegisters)) {
            if (((String)condition).contains(registerIdCondition)) {
                parameters.remove("registerId");
                return ((String)condition).replace(registerIdCondition, " ");
            }
            if (((String)condition).contains(registeryCondition)) {
                parameters.remove("register");
                return ((String)condition).replace(registeryCondition, " ");
            }
            return condition;
        }
        if (AbsPOSSales.class.isAssignableFrom(klass) || AbsPOSPayReceipt.class.isAssignableFrom(klass)) {
            condition = (String)condition + registerIdCondition;
            parameters.put("registerId", register.getId());
        } else if (AbsPOSShiftInventory.class.isAssignableFrom(klass)) {
            condition = (String)condition + registeryCondition;
            parameters.put("register", register);
        }
        return condition;
    }

    private static String addCurrentShiftDataOnlyConditionIfNeeded(boolean fromOpenDocAction, boolean fromInvoiceCode, String condition, Class<?> klass, Map<String, Object> parameters) {
        POSSecurityCapability capability = capabilities.get(klass);
        if (capability == null) {
            capability = POSSecurityCapability.ShowAllInvoices;
        }
        if (ObjectChecker.isAnyTrue((Boolean[])new Boolean[]{fromOpenDocAction, fromInvoiceCode}) && POSSecurityUtil.userCan(capability).isFailed().booleanValue()) {
            condition = (String)condition + " and shiftCode = :shiftCode ";
            POSShiftOpen lastShift = POSResourcesUtil.fetchLastOpenShift(POSResourcesUtil.fetchMainRegister());
            parameters.put("shiftCode", lastShift == null ? "" : lastShift.getCode());
        }
        return condition;
    }

    private static String addExtraCondition(IHasToolBar screen, String fieldId, String condition, Map<String, Object> params) {
        String documentType = screen.fetchScreenEntityType();
        POSExtraFilter extraFilters = POSResourcesUtil.fetchExtraFilters();
        if (extraFilters == null) {
            return condition;
        }
        StringBuilder conditionBuilder = new StringBuilder(condition);
        for (POSExtraFilterLine filterLine : extraFilters.getExtraFilters()) {
            if (!ObjectChecker.areEqual((Object)filterLine.getDocumentType(), (Object)documentType) || !ObjectChecker.areEqual((Object)filterLine.getFieldId(), (Object)fieldId)) continue;
            conditionBuilder.append(" and (").append(NamaPOSSearchDialog.constructExtraConditionForLine(screen, filterLine, params)).append(")");
        }
        condition = conditionBuilder.toString();
        return condition;
    }

    private static String constructExtraConditionForLine(IHasToolBar screen, POSExtraFilterLine filterLine, Map<String, Object> params) {
        String condition = filterLine.getFilter();
        List dynamic = StringUtils.getAllInnerStrings((String)condition, (String)"{", (String)"}").stream().distinct().toList();
        for (String s : dynamic) {
            Object validParamId;
            if (s.toLowerCase().startsWith("uuid(")) {
                String uuidStr = s.substring("uuid(".length(), s.length() - 1);
                validParamId = "uuid_" + uuidStr.replace("-", "");
                params.put((String)validParamId, UUID.fromString(uuidStr));
                condition = condition.replace("{" + s + "}", ":" + (String)validParamId);
                continue;
            }
            Object paramValue = ReflectionUtils.getFieldValue((String)s, screen.document());
            validParamId = s.replace(".", "_");
            params.put((String)validParamId, paramValue);
            condition = condition.replace("{" + s + "}", ":" + (String)validParamId);
        }
        return condition;
    }

    public static String filterOnDimensionCriteria(Class onKlass, Map<String, Object> parameters) {
        return NamaPOSSearchDialog.filterOnDimensionCriteria(onKlass, parameters, null);
    }

    private static String filterOnDimensionCriteria(Class onKlass, Map<String, Object> parameters, IHasToolBar screen) {
        Object criteria = "";
        List filterDimensionsLines = POSResourcesUtil.fetchPOSConfig().getFilterDimensionsLines();
        if (ObjectChecker.isEmptyOrNull((Object)filterDimensionsLines)) {
            return criteria;
        }
        POSRegistery register = POSResourcesUtil.fetchMainRegister();
        if (ObjectChecker.isEmptyOrNull((Object)register) || ObjectChecker.isEmptyOrNull((Object)register.getGenericDims())) {
            return criteria;
        }
        POSMasterFile object = (POSMasterFile)ObjectCreatorUtil.creator((Class)onKlass).create();
        String namaEntityType = object.calcNamaEntityType();
        if (screen != null) {
            filterDimensionsLines = filterDimensionsLines.stream().filter(l -> ObjectChecker.isEmptyOrNull((Object)l.getFilteredInType()) || ObjectChecker.areEqual((Object)l.getFilteredInType(), (Object)screen.fetchScreenEntityType())).collect(Collectors.toList());
        }
        if (ObjectChecker.isEmptyOrNull((Object)filterDimensionsLines)) {
            return criteria;
        }
        DTOPOSFilterDimensionsLine lineForType = filterDimensionsLines.stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getEntityTypeList()) && ObjectChecker.toStringOrEmpty((Object)l.getEntityTypeList().get("lines.entityType")).contains("," + namaEntityType + ",") || ObjectChecker.areEqual((Object)ObjectChecker.toStringOrEmpty((Object)l.getForType()), (Object)namaEntityType)).findFirst().orElse(null);
        if (lineForType == null) {
            return criteria;
        }
        DTOPOSFilterDimensionsLine dtoposFilterDimensionsLine = lineForType;
        criteria = (String)criteria + NamaPOSSearchDialog.addFilterOnDimPart(dtoposFilterDimensionsLine.getFilterOnLegalEntity(), parameters, "LegalEntity", register);
        criteria = (String)criteria + NamaPOSSearchDialog.addFilterOnDimPart(dtoposFilterDimensionsLine.getFilterOnSector(), parameters, "Sector", register);
        criteria = (String)criteria + NamaPOSSearchDialog.addFilterOnDimPart(dtoposFilterDimensionsLine.getFilterOnBranch(), parameters, "Branch", register);
        criteria = (String)criteria + NamaPOSSearchDialog.addFilterOnDimPart(dtoposFilterDimensionsLine.getFilterOnDepartment(), parameters, "Department", register);
        criteria = (String)criteria + NamaPOSSearchDialog.addFilterOnDimPart(dtoposFilterDimensionsLine.getFilterOnAnalysisSet(), parameters, "AnalysisSet", register);
        return criteria;
    }

    private static String addFilterOnDimPart(Boolean filterOnDim, Map<String, Object> parameters, String entityType, POSRegistery register) {
        if (ObjectChecker.isFalseOrNull((Boolean)filterOnDim)) {
            return "";
        }
        String dimIdField = NamaPOSSearchDialog.fieldIdForEntityType(entityType);
        parameters.put(entityType + "Ids", Arrays.asList(NamaPOSSearchDialog.registerDimIdForEntityType(entityType).apply(register.getGenericDims()).getId(), NamaPOSSearchDialog.publicIdForDim(entityType)));
        return " and " + dimIdField + " in ( :" + entityType + "Ids ) ";
    }

    private static String fieldIdForEntityType(String entityType) {
        if (ObjectChecker.isNotEmptyOrNull(entityTypeWithFieldId)) {
            return entityTypeWithFieldId.get(entityType);
        }
        entityTypeWithFieldId.put("LegalEntity", "genericDims.legalEntity.id");
        entityTypeWithFieldId.put("Sector", "genericDims.sector.id");
        entityTypeWithFieldId.put("Branch", "genericDims.branch.id");
        entityTypeWithFieldId.put("Department", "genericDims.department.id");
        entityTypeWithFieldId.put("AnalysisSet", "genericDims.analysisSet.id");
        return entityTypeWithFieldId.get(entityType);
    }

    private static Function<POSGenericDims, POSDimInfo> registerDimIdForEntityType(String entityType) {
        if (ObjectChecker.isNotEmptyOrNull(entityTypeWithRegisterDimId)) {
            return entityTypeWithRegisterDimId.get(entityType);
        }
        entityTypeWithRegisterDimId.put("LegalEntity", POSGenericDims::getLegalEntity);
        entityTypeWithRegisterDimId.put("Sector", POSGenericDims::getSector);
        entityTypeWithRegisterDimId.put("Branch", POSGenericDims::getBranch);
        entityTypeWithRegisterDimId.put("Department", POSGenericDims::getDepartment);
        entityTypeWithRegisterDimId.put("AnalysisSet", POSGenericDims::getAnalysisSet);
        return entityTypeWithRegisterDimId.get(entityType);
    }

    public static UUID publicIdForDim(String entityType) {
        if (ObjectChecker.isNotEmptyOrNull(publicDimsIDs)) {
            return publicDimsIDs.get(entityType);
        }
        publicDimsIDs.put("LegalEntity", ((POSMasterFile)POSPersister.findByCode(POSLegalEntity.class, "PUBLIC")).getId());
        publicDimsIDs.put("Sector", ((POSMasterFile)POSPersister.findByCode(POSSector.class, "PUBLIC")).getId());
        publicDimsIDs.put("Branch", ((POSMasterFile)POSPersister.findByCode(POSBranch.class, "PUBLIC")).getId());
        publicDimsIDs.put("Department", ((POSMasterFile)POSPersister.findByCode(POSDepartment.class, "PUBLIC")).getId());
        publicDimsIDs.put("AnalysisSet", ((POSMasterFile)POSPersister.findByCode(POSAnalysisset.class, "PUBLIC")).getId());
        return publicDimsIDs.get(entityType);
    }

    private static String calcSalesScreenCondition(Class<?> klass, String fieldId, AbsPosSalesScreen screen, Map<String, Object> parameters) {
        Object salesCond = "";
        if (ObjectChecker.areEqual(POSEmployee.class, klass) && ObjectChecker.areNotEqual((Object)fieldId, (Object)"subsidiary")) {
            salesCond = " and salesMan = true";
        }
        if (ObjectChecker.isAnyEqualToFirst(klass, (Object[])new Class[]{POSSalesInvoice.class, POSSalesReturn.class, POSSalesReplacement.class})) {
            salesCond = POSDataWriterUtil.calcExtraExpression(klass);
        }
        if (ObjectChecker.areEqual(POSSalesInvoice.class, klass) && !screen.isInvoice()) {
            salesCond = (String)salesCond + " and returnBefore = false ";
        }
        if (ObjectChecker.areEqual(klass, PosDocCategory.class)) {
            salesCond = (String)salesCond + " and (forType = '' or forType is null or forType ='" + screen.calcEntityType() + "')";
        }
        if (ObjectChecker.areEqual(klass, POSInvoiceClassification.class)) {
            salesCond = (String)salesCond + " and (classifiedEntity = '' or classifiedEntity is null or classifiedEntity ='" + screen.calcEntityType() + "')";
        }
        salesCond = NamaPOSSearchDialog.addLocatorConditionIfNeeded(klass, fieldId, screen, (String)salesCond, parameters);
        return salesCond;
    }

    private static String addLocatorConditionIfNeeded(Class<?> klass, String fieldId, AbsPosSalesScreen screen, String salesCond, Map<String, Object> parameters) {
        if (ObjectChecker.isEmptyOrNull((Object)fieldId)) {
            return salesCond;
        }
        if (ObjectChecker.areNotEqual(POSLocation.class, klass)) {
            return salesCond;
        }
        POSWarehouse value = NamaPOSSearchDialog.calcWarehouseForLocatorField(fieldId, screen.getSalesDoc());
        if (ObjectChecker.isEmptyOrNull((Object)value)) {
            return salesCond;
        }
        salesCond = (String)salesCond + " and warehouse = :warehouse";
        parameters.put("warehouse", value);
        return salesCond;
    }

    private static POSWarehouse calcWarehouseForLocatorField(String fieldId, AbsPOSSales salesDoc) {
        if (salesDoc == null) {
            return null;
        }
        if (ObjectChecker.areEqual((Object)fieldId, (Object)"locator")) {
            return salesDoc.getWarehouse();
        }
        if (!(salesDoc instanceof POSStockTransferReq)) {
            return salesDoc.getWarehouse();
        }
        return ((POSStockTransferReq)salesDoc).getToWarehouse();
    }

    private void searchAction() {
        String cond = this.addCodePartToCondition(this.basicCondition, this.filterByTextFields);
        HashMap<String, Object> allParams = this.constructSearchParams(this.filterByTextFields);
        allParams.putAll(this.basicConditionParams);
        cond = NamaPOSSearchDialog.addRegisterConditionIfNeeded(POSResourcesUtil.fetchMainRegister(), this.onKlass, this.searchInAllRegisters.isSelected(), allParams, cond);
        int recordsCount = this.fetchRecordsCount(cond, allParams);
        this.paginationData.setPagesCount(this.calcPagesCount(recordsCount));
        this.paginationData.firstPage();
        List<POSMasterFile> list = this.fetchRecords(cond, allParams, this.paginationData);
        this.updateCountFields(recordsCount);
        this.updateSearchTableContent(list);
    }

    private List<POSMasterFile> fetchRecords(String cond, Map<String, Object> params, DTOPageData pageData) {
        String[] orderByArray = this.calcOrderByCols();
        if (ObjectChecker.isNotEmptyOrNull((Object)this.namaTypeToSearchIn)) {
            ArrayList<String> orderBy = new ArrayList<String>(Arrays.asList(orderByArray));
            for (int i = orderBy.size() - 1; i >= 0; --i) {
                if (!ObjectChecker.isEmptyOrNull(orderBy.get(i))) continue;
                orderBy.remove(i);
            }
            return this.fetchListOfNamaDocs(StringUtils.toCSVLineWithSep((String)",", orderBy));
        }
        if (ObjectChecker.areEqual((Object)this.onKlass, PosNamaDocToPay.class)) {
            return this.fetchDocToPay();
        }
        return POSPersister.selectTop(this.onKlass, cond, (int)((Integer)this.recordsCountPerPageField.fetchValue()), (String)this.sortTypeComboBox.getValue(), params, true, pageData, this.columnsToGetFromDB(), orderByArray);
    }

    private String[] calcOrderByCols() {
        String[] orderByCols = ObjectChecker.areAllEmptyOrNull((Object[])new Object[]{this.orderByField1.getValue(), this.orderByField2.getValue(), this.orderByField3.getValue()}) ? new String[]{"code"} : new String[]{(String)this.orderByField1.getValue(), (String)this.orderByField2.getValue(), (String)this.orderByField3.getValue()};
        return orderByCols;
    }

    private List<String> columnsToGetFromDB() {
        if (this.sampleObject.searchOnAllFields()) {
            return null;
        }
        List list = this.columnList;
        List<String> cols = list.stream().map(c -> c.getId()).collect(Collectors.toList());
        if (!cols.contains("id")) {
            cols.add(0, "id");
        }
        if (this.onKlass == POSItem.class && POSResourcesUtil.getUseItemsImage()) {
            cols.add("imgDownloadLink");
        }
        return cols;
    }

    private List<? extends POSMasterFile> fetchDocToPay() {
        List<Object> docToPays = new ArrayList();
        POSRegistery posRegistery = POSResourcesUtil.fetchMainRegister();
        POSGenericDims genericDims = posRegistery.getGenericDims();
        DTODocToPayReq req = new DTODocToPayReq();
        req.setDocCode(null);
        req.setPayment(((POSPaymentReciptScreen)this.screen).isPayment());
        SendRequest request = new SendRequest((Object)req);
        request.setDoNotRememberLoginDimensions(Boolean.valueOf(true));
        EntityDimensionsDTO dimensionsIds = new EntityDimensionsDTO();
        dimensionsIds.setLegalEntity(new EntityReferenceData("LegalEntity", ServerStringUtils.toUUIDStr((Object)genericDims.getLegalEntity().getId())));
        dimensionsIds.setBranch(new EntityReferenceData("Branch", ServerStringUtils.toUUIDStr((Object)genericDims.getBranch().getId())));
        dimensionsIds.setSector(new EntityReferenceData("Sector", ServerStringUtils.toUUIDStr((Object)genericDims.getSector().getId())));
        dimensionsIds.setDepartment(new EntityReferenceData("Department", ServerStringUtils.toUUIDStr((Object)genericDims.getDepartment().getId())));
        dimensionsIds.setAnalysisSet(new EntityReferenceData("AnalysisSet", ServerStringUtils.toUUIDStr((Object)genericDims.getAnalysisSet().getId())));
        request.setDimensionsIds(dimensionsIds);
        req.setCurrentPage(this.paginationData.getPageNumber());
        req.setPageSize(this.paginationData.getPageSize());
        req.setAsc(((String)this.sortTypeComboBox.getValue()).equalsIgnoreCase("ASC"));
        ListResult<DTODocsToPayFromPosEntry> listResult = POSWSClient.instance.fetchListOfDocToPay((SendRequest<DTODocToPayReq>)request);
        List list = listResult.getList();
        if (ObjectChecker.isEmptyOrNull((Object)list)) {
            return docToPays;
        }
        docToPays = list.stream().map(l -> {
            PosNamaDocToPay doc = new PosNamaDocToPay();
            doc.setCode(l.getOriginDocCode());
            doc.setPaymentAmount(l.getPaymentAmount());
            doc.setPaidAmount(l.getPaidAmount());
            doc.setRemainig(ObjectChecker.toZeroIfNull((BigDecimal)l.getPaymentAmount()).subtract(ObjectChecker.toZeroIfNull((BigDecimal)l.getPaidAmount())));
            doc.setDescription(l.getDescription());
            return doc;
        }).collect(Collectors.toList());
        return docToPays;
    }

    private BigDecimal calcTableSelectedLines(TableView<POSMasterFile> table) {
        BigDecimal count = BigDecimal.ZERO;
        for (POSMasterFile entity : table.getItems()) {
            count = count.add(entity.getSelected() != false ? BigDecimal.ONE : BigDecimal.ZERO);
        }
        return count;
    }

    private String addCodePartToCondition(String condition, List<POSFieldFilterPart> filterByTextFields) {
        Object cond = condition;
        for (POSFieldFilterPart filterPart : filterByTextFields) {
            Object textField = filterPart.getTextField();
            if (!ObjectChecker.isNotEmptyOrNull((Object)((POSField)textField).fetchValue())) continue;
            if (ObjectChecker.isEmptyOrNull((Object)cond)) {
                cond = (String)cond + " where " + filterPart.fetchCondition();
                continue;
            }
            cond = (String)cond + " and " + filterPart.fetchCondition();
        }
        return cond;
    }

    private void updateSearchTableContent(List<POSMasterFile> listAll) {
        this.table.getItems().clear();
        if (ObjectChecker.isNotEmptyOrNull(listAll)) {
            this.table.setItems(FXCollections.observableArrayList(listAll));
        }
        this.updateTableRelatedFields();
    }

    private void updateTableRelatedFields() {
        if (this.selectAll != null) {
            this.selectAll.setSelected(false);
        }
        this.selectedCountLabel.setText("");
    }

    private HashMap<String, Object> constructSearchParams(List<POSFieldFilterPart> filterByTextFields) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (POSFieldFilterPart filterPart : filterByTextFields) {
            Object textField = filterPart.getTextField();
            if (!ObjectChecker.isNotEmptyOrNull((Object)((POSField)textField).fetchValue())) continue;
            Object paramVal = null;
            if (ObjectChecker.areEqual((Object)textField.getId(), (Object)"racksCodes")) {
                String rackCodeWithSeps = "_#_" + ObjectChecker.toStringOrEmpty((Object)((POSField)textField).fetchValue()).trim() + "_#_";
                paramVal = rackCodeWithSeps;
            } else {
                paramVal = ((POSField)textField).fetchValue();
            }
            paramVal = this.editParamValueByOperator(paramVal, filterPart.getOperator());
            params.put(textField.getId(), paramVal);
        }
        return params;
    }

    private Object editParamValueByOperator(Object paramVal, ComboBox<OperatorForCombo> operator) {
        Operator operatorVal = ((OperatorForCombo)operator.getValue()).getOperator();
        switch (operatorVal) {
            case Contains: {
                paramVal = "%" + String.valueOf(paramVal) + "%";
                break;
            }
            case StartsWith: {
                paramVal = String.valueOf(paramVal) + "%";
                break;
            }
            case EndsWith: {
                paramVal = "%" + String.valueOf(paramVal);
            }
        }
        return paramVal;
    }

    private boolean fireSelectAction(NamaSearchBox searchBox, TableView<POSMasterFile> table, Event event) {
        if (ObjectChecker.isNotEmptyOrZero((Integer)this.numberOfRecordsToSelect) && this.calcTableSelectedLines(table).intValue() > this.numberOfRecordsToSelect) {
            this.setTitle(POSResourcesUtil.id("Must select {0} records", this.numberOfRecordsToSelect));
            return false;
        }
        POSMasterFile selectedItem = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)this.namaTypeToSearchIn)) {
            FindByIDRequest request;
            selectedItem = (POSMasterFile)table.getSelectionModel().getSelectedItem();
            BaseEntityServiceProxy ws = (BaseEntityServiceProxy)ServiceUtility.getServiceClient((String)this.namaTypeToSearchIn);
            BaseEntityDTO dto = (BaseEntityDTO)ws.findByID(request = new FindByIDRequest(this.namaTypeToSearchIn, ServerStringUtils.toUUIDStr((Object)selectedItem.getId()))).getData();
            if (dto != null && this.screen instanceof AbsPosSalesScreen) {
                boolean confirmed;
                POSResult result = new POSResult();
                AbsPOSSales salesDoc = ((AbsPosSalesScreen)this.screen).getSalesDoc();
                List docLines = (List)ReflectionUtils.callMethod((Object)dto, (String)"getDetails", (Object[])new Object[0]);
                List<AbsPOSSalesLine> lines = this.createLinesFromDoc(docLines, salesDoc, result);
                if (result.isFailed().booleanValue() && !(confirmed = NamaConfirmationDialog.showDialogAndWait(result.getMessageByLanguage(), this, event))) {
                    return false;
                }
                salesDoc.fetchDetails().clear();
                ((AbsPosSalesScreen)this.screen).getSalesTable().getItems().clear();
                salesDoc.fetchDetails().addAll(lines);
                ((AbsPosSalesScreen)this.screen).updateFieldsEvent(Arrays.asList("details"), ((AbsPosSalesScreen)this.screen).getSalesDoc());
                searchBox.getIdBox().setText(ObjectChecker.toStringOrEmpty((Object)dto.getId()));
            }
            this.close();
            return true;
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)table.getSelectionModel().getSelectedItem())) {
            selectedItem = ObjectChecker.areEqual((Object)this.onKlass, PosNamaDocToPay.class) ? (POSMasterFile)table.getSelectionModel().getSelectedItem() : (POSMasterFile)POSPersister.findByID(this.onKlass, ((POSMasterFile)table.getSelectionModel().getSelectedItem()).getId());
        }
        if (ObjectChecker.areEqual((Object)this.onKlass, PosNamaDocToPay.class)) {
            PosNamaDocToPay doc = (PosNamaDocToPay)selectedItem;
            DTODocsToPayFromPosEntry entry = new DTODocsToPayFromPosEntry();
            entry.setPaymentAmount(doc.getPaymentAmount());
            entry.setPaidAmount(doc.getPaidAmount());
            ((POSPaymentReciptScreen)this.screen).selectNamaDoc(doc.getCode(), entry);
            this.close();
            return true;
        }
        if (ObjectChecker.isTrue((Boolean)searchBox.getFromOpenDocAction())) {
            selectedItem.setOldDoc(true);
            searchBox.getScreen().fireOpenOldDocAction(selectedItem, event);
        } else {
            searchBox.getScreen().fireSelectItemAction(this.onKlass, table, selectedItem);
        }
        if (selectedItem != null && !selectedItem.notAllowedToBeSelected(searchBox)) {
            searchBox.updateFromRecord(selectedItem);
        }
        if (this.onKlass != POSActionHistory.class) {
            this.close();
        }
        if (searchBox.getAfterSelectionFunc() != null) {
            searchBox.getAfterSelectionFunc().apply(selectedItem);
        }
        PosCustomToolTipUtil.showCustomTooltipIfNeeded(true, this.screen, searchBox.getOnField());
        return true;
    }

    private List<? extends AbsPOSSalesLine> createLinesFromDoc(List<DTOBasicSCDocumentLine> fromDocLines, AbsPOSSales salesDoc, POSResult result) {
        if (ObjectChecker.areEqual((Object)((Object)this.screen.documentType()), (Object)((Object)POSDocumentType.POSStockReceipt))) {
            return NamaPOSSearchDialog.createStockReceiptLines(fromDocLines, (POSStockReceipt)salesDoc, result);
        }
        if (ObjectChecker.areEqual((Object)((Object)this.screen.documentType()), (Object)((Object)POSDocumentType.ScrapDoc))) {
            return NamaPOSSearchDialog.createScrapDocLines(fromDocLines, (POSScrapDoc)salesDoc, result);
        }
        if (ObjectChecker.areEqual((Object)((Object)this.screen.documentType()), (Object)((Object)POSDocumentType.ShortfallsDoc))) {
            return NamaPOSSearchDialog.createShortfallsDocLines(fromDocLines, (POSShortfallsDoc)salesDoc, result);
        }
        throw new RuntimeException("Unhandled type for fromDoc field " + String.valueOf((Object)this.screen.documentType()));
    }

    private static List<POSShortfallsDocLine> createShortfallsDocLines(List<DTOBasicSCDocumentLine> docLines, POSShortfallsDoc salesDoc, POSResult result) {
        ArrayList<POSShortfallsDocLine> newLines = new ArrayList<POSShortfallsDocLine>();
        for (DTOBasicSCDocumentLine l : docLines) {
            if (ObjectChecker.isEmptyOrZero((BigDecimal)l.getUnsatisfiedQty())) continue;
            POSShortfallsDocLine line = new POSShortfallsDocLine();
            line.setShortfalls(salesDoc);
            line = NamaPOSSearchDialog.copyLine(l, line, result);
            if (line == null) continue;
            newLines.add(line);
        }
        return newLines;
    }

    private static List<POSScrapDocLine> createScrapDocLines(List<DTOBasicSCDocumentLine> docLines, POSScrapDoc salesDoc, POSResult result) {
        ArrayList<POSScrapDocLine> newLines = new ArrayList<POSScrapDocLine>();
        for (DTOBasicSCDocumentLine l : docLines) {
            if (ObjectChecker.isEmptyOrZero((BigDecimal)l.getUnsatisfiedQty())) continue;
            POSScrapDocLine line = new POSScrapDocLine();
            line.setScrap(salesDoc);
            line = NamaPOSSearchDialog.copyLine(l, line, result);
            if (line == null) continue;
            newLines.add(line);
        }
        return newLines;
    }

    private static List<PosStockReceiptLine> createStockReceiptLines(List<DTOBasicSCDocumentLine> docLines, POSStockReceipt salesDoc, POSResult result) {
        ArrayList<PosStockReceiptLine> newLines = new ArrayList<PosStockReceiptLine>();
        for (DTOBasicSCDocumentLine l : docLines) {
            if (ObjectChecker.isEmptyOrZero((BigDecimal)l.getUnsatisfiedQty())) continue;
            PosStockReceiptLine receiptLine = new PosStockReceiptLine();
            receiptLine.setInvoice(salesDoc);
            receiptLine = NamaPOSSearchDialog.copyLine(l, receiptLine, result);
            if (receiptLine == null) continue;
            newLines.add(receiptLine);
        }
        return newLines;
    }

    private static <L extends AbsPOSSalesLine> L copyLine(DTOBasicSCDocumentLine l, L line, POSResult result) {
        line.setItem(POSPersister.findByID(POSItem.class, l.getItem().getItem().getId()));
        if (ObjectChecker.isEmptyOrNull((Object)line.getItem())) {
            result.failure("item: {0} not exist in this register: {1}", l.getItem().getItem(), POSResourcesUtil.fetchMainRegister().nameByLanguage());
            return null;
        }
        line.updateSourceLineId(ServerStringUtils.strToUUID((String)l.getId()));
        line.setItemCode(line.getItem().getCode());
        line.setItemName(line.getItem().nameByLanguage());
        POSQuantity qty = new POSQuantity();
        qty.setUom(POSPersister.findByID(POSUnit.class, l.getQuantity().getQuantity().getPrimeQty().getUom().getId()));
        qty.setValue(l.getUnsatisfiedQty());
        line.setQty(qty);
        line.setUnitPrice(BigDecimal.ZERO);
        line.setItemDimensions(POSItemSpecificDimensions.fromDTOItemSpecificDimensions(l.getSpecificDimensions()));
        return line;
    }

    static {
        capabilities.put(POSPaymentToRegistery.class, POSSecurityCapability.ShowAllPayments);
        capabilities.put(POSReceiptFromRegistery.class, POSSecurityCapability.ShowAllReceipts);
        entityTypeWithFieldId = new HashMap();
        entityTypeWithRegisterDimId = new HashMap();
        publicDimsIDs = new HashMap();
    }

    public static class POSSearchRequest {
        public Class<?> klass;
        public String fieldId;
        public IHasToolBar screen;
        public String customeType;
        public Map<String, Object> parameters;
        public boolean fromOpenDocAction;
        public boolean searchInAllRegisters;
        public POSRegistery register;
    }
}

