/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utils.ServerStringUtils;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaPOSSearchDialog;
import com.namasoft.namacontrols.NamaTextArea;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSHallsTablesViewer;
import com.namasoft.namacontrols.PosCustomToolTipUtil;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.MultiTableDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPaymentReciptScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.details.PosDefaultsTemplateLine;
import com.namasoft.pos.domain.entities.POSAlias;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.PosDefaultsTemplate;
import com.namasoft.pos.domain.entities.PosNamaDocToPay;
import com.namasoft.pos.util.POSDataReaderUtil;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class NamaSearchBox
extends StackPane
implements POSField {
    private String title;
    private boolean usedInReport;
    private Class<?> onKlass;
    private NamaButton searchBtn;
    private NamaTextField codeBox;
    private NamaTextField nameBox;
    private NamaHBox searchBox;
    private String onField;
    private Stage primStage;
    private String customeType;
    private Boolean fromOpenDocAction;
    private IHasToolBar screen;
    private NamaTextField idBox;
    private POSSecurityCapability capability;
    private Function<Object, Void> afterSelectionFunc;
    private MultiTableDialog relatedTableDialog;
    private String namaTypeToSearchIn;
    private Dialog fromDialog = null;

    public MultiTableDialog getRelatedTableDialog() {
        return this.relatedTableDialog;
    }

    public void setNamaTypeToSearchIn(String namaTypeToSearchIn) {
        this.namaTypeToSearchIn = namaTypeToSearchIn;
    }

    public void setRelatedTableDialog(MultiTableDialog relatedTableDialog) {
        this.relatedTableDialog = relatedTableDialog;
    }

    public void setFromDialog(Dialog fromDialog) {
        this.fromDialog = fromDialog;
    }

    public NamaSearchBox(String namaType, IHasToolBar screen) {
        this(null, screen, null, null, screen.fetchStage(), true);
        this.setNamaTypeToSearchIn(namaType);
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, String genRefType, Stage primStage, boolean jumpToNext) {
        this.getStyleClass().add((Object)"nama-search-box");
        this.setCustomeType(genRefType);
        this.setCommonfields(klass, screen, filedId, primStage, jumpToNext);
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, POSSecurityCapability cap) {
        this(klass, screen, filedId, primStage, true);
        this.capability = cap;
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, POSSecurityCapability cap, Function<Object, Void> afterSelectionFunc) {
        this(klass, screen, filedId, primStage, true);
        this.capability = cap;
        this.afterSelectionFunc = afterSelectionFunc;
    }

    private void setCommonfields(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, boolean jumpToNext) {
        NamaHBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.onKlass = klass;
        this.onField = filedId;
        this.primStage = primStage;
        this.searchBtn = new NamaButton();
        this.idBox = new NamaTextField(POSFieldType.ID);
        this.codeBox = new NamaTextField(jumpToNext, POSFieldType.Text, null, null);
        NamaHBox.setHgrow((Node)this.codeBox, (Priority)Priority.ALWAYS);
        this.nameBox = new NamaTextField(POSFieldType.Text);
        NamaHBox.setHgrow((Node)this.nameBox, (Priority)Priority.ALWAYS);
        this.searchBox = new NamaHBox();
        this.nameBox.setEditable(false);
        this.setScreen(screen);
        this.createSearchBox(klass, screen);
        this.codeBox.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.TAB) {
                Platform.runLater(() -> this.searchBtn.requestFocus());
            }
            if (event.getCode() == KeyCode.ENTER) {
                this.nameBox.requestFocus();
            }
        });
        this.codeBox.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.defaultCodeSelection();
            }
        });
        this.searchBox.getChildren().addAll((Object[])new Node[]{this.codeBox, this.nameBox});
        this.searchBox.setFocusTraversable(false);
        this.getChildren().addAll((Object[])new Node[]{this.searchBox, this.searchBtn});
        StackPane.setAlignment((Node)this.searchBtn, (Pos)Pos.CENTER_RIGHT);
        NamaSearchBox.setDefaultValueIfNeeded(screen, this.onField, this);
    }

    public static void setDefaultValueIfNeeded(IHasToolBar screen, String fieldId, Object control) {
        PosDefaultsTemplateLine templateLine;
        if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{screen, fieldId})) {
            return;
        }
        PosDefaultsTemplate defaultsTemplate = POSResourcesUtil.fetchTemplate();
        if (defaultsTemplate == null) {
            return;
        }
        List<PosDefaultsTemplateLine> details = defaultsTemplate.getDetails();
        if (ObjectChecker.isEmptyOrNull(details)) {
            return;
        }
        boolean forEntityType = false;
        String suffix = "";
        if (fieldId.contains(".")) {
            String[] split = fieldId.split("\\.");
            suffix = split[split.length - 1];
            fieldId = split[0];
        }
        String field = fieldId;
        if (ObjectChecker.areEqual((Object)suffix, (Object)"entityType")) {
            forEntityType = true;
        }
        if (ObjectChecker.isEmptyOrNull((Object)(templateLine = (PosDefaultsTemplateLine)details.stream().filter(l -> ObjectChecker.isNotEmptyOrNull((Object)l.getField()) && ObjectChecker.areEqual((Object)l.getForType(), (Object)screen.fetchScreenEntityType()) && ObjectChecker.areEqual((Object)l.getField().toUpperCase(), (Object)field.toUpperCase())).findFirst().orElse(null)))) {
            return;
        }
        Object value = "";
        String textValue = templateLine.getTextValue();
        if (control instanceof NamaSearchBox && ObjectChecker.isNotEmptyOrNull((Object)templateLine.getRefValueId())) {
            Object record = POSPersister.findByID(POSDataReaderUtil.constructNamaWithPOSTypesMap().get(templateLine.getRefValueType()), templateLine.getRefValueId());
            value = record;
            ((NamaSearchBox)control).updateFromRecord((POSMasterFile)record);
            if (((NamaSearchBox)control).getAfterSelectionFunc() != null) {
                ((NamaSearchBox)control).getAfterSelectionFunc().apply(null);
            }
        }
        if (control instanceof NamaTextField && ObjectChecker.isNotEmptyOrNull((Object)templateLine.getTextValue())) {
            ((NamaTextField)control).setText(textValue);
            value = textValue;
        }
        if (control instanceof NamaTextArea && ObjectChecker.isNotEmptyOrNull((Object)templateLine.getTextValue())) {
            ((NamaTextArea)control).setText(textValue);
            value = textValue;
        }
        Date dateValue = templateLine.getDateValue();
        if (control instanceof NamaDatePicker && ObjectChecker.isNotEmptyOrNull((Object)dateValue)) {
            ((NamaDatePicker)control).updateValueFromQuestionField(dateValue);
            value = dateValue;
        }
        if (control instanceof NamaComboBox && ObjectChecker.isNotEmptyOrNull((Object)templateLine.getTextValue())) {
            ((NamaComboBox)control).updateValueFromQuestionField(textValue);
            value = textValue;
        }
        if (control instanceof NamaComboBox && ObjectChecker.isNotEmptyOrNull((Object)templateLine.getRefValueType()) && forEntityType) {
            ((NamaComboBox)control).updateValueFromQuestionField(POSPaymentReciptScreen.namaWithPosSubsidType(templateLine.getRefValueType()));
        }
        if (ObjectChecker.isNotEmptyOrNull((Object)value) && screen instanceof AbsPosSalesScreen) {
            ((AbsPosSalesScreen)screen).updateProperty(fieldId, value, ((AbsPosSalesScreen)screen).getSalesDoc());
            ((AbsPosSalesScreen)screen).updateFieldsEvent(Arrays.asList(fieldId), ((AbsPosSalesScreen)screen).getSalesDoc());
            if (ObjectChecker.isNotEmptyOrNull((Object)templateLine.getRefValueType())) {
                ((AbsPosSalesScreen)screen).updatePropertyType(fieldId, POSPaymentReciptScreen.namaWithPosSubsidType(templateLine.getRefValueType()), ((AbsPosSalesScreen)screen).getSalesDoc());
            }
        }
    }

    public void defaultCodeSelection() {
        String code = this.codeBox.getText();
        if (this.onKlass == null || ObjectChecker.areEqual(this.onKlass, PosNamaDocToPay.class)) {
            return;
        }
        if (ObjectChecker.isEmptyOrNull((Object)code)) {
            if (this.getAfterSelectionFunc() != null) {
                this.getAfterSelectionFunc().apply(null);
            }
            return;
        }
        Object object = POSPersister.findByCode(this.onKlass, code);
        if (ObjectChecker.areEqual(this.onKlass, POSCustomer.class) && object == null) {
            object = (POSMasterFile)CollectionsUtility.getFirst(POSPersister.selectTop(POSCustomer.class, "WHERE " + POSCustomer.filteringCondition("", " = ", "value"), 1, POSPersister.params("value", code)));
        }
        if (object == null) {
            POSMasterFile o = (POSMasterFile)ObjectCreatorUtil.creator(this.onKlass).create();
            POSAlias alias = (POSAlias)CollectionsUtility.getFirst(POSPersister.searchFor("FROM " + POSAlias.class.getSimpleName() + " WHERE entityType = :entityType AND entityCode = :code", POSPersister.params("entityType", o.calcNamaEntityType(), "code", code)));
            if (alias != null) {
                object = (POSMasterFile)POSPersister.findByID(o.getClass(), alias.getEntityId());
            }
        }
        if (ObjectChecker.isNotEmptyOrNull(object)) {
            this.entityCodeSelectionAction((POSMasterFile)object, object instanceof POSCustomer);
        } else {
            this.screen.extraCodeSelectionActions(this);
        }
        if (this.getAfterSelectionFunc() != null) {
            this.getAfterSelectionFunc().apply(object);
        }
    }

    public void entityCodeSelectionAction(POSMasterFile object, boolean updateCodeField) {
        if (this.isOnPaymentMethod() && object != null && ((POSPaymentMethod)object).getCriticalPosPaymentMethod().booleanValue() && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanUseCriticalMethods).isFailed().booleanValue()) {
            return;
        }
        if (ObjectChecker.isFalseOrNull((Boolean)object.getPreventUsage())) {
            this.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)object.getId()));
            this.getNameBox().setText(object.nameByLanguage());
            if (updateCodeField) {
                this.getCodeBox().setText(object.getCode());
            }
        } else {
            this.getCodeBox().clear();
            POSResult result = new POSResult();
            result.failure(POSResourcesUtil.id("usagePrevented", new Object[0]), new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, this.getScreen().fetchStage());
        }
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, Boolean openDoc, boolean jumpToNext) {
        this(klass, screen, filedId, null, primStage, jumpToNext);
        this.setFromOpenDocAction(openDoc);
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage) {
        this(klass, screen, filedId, primStage, true);
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, Function<Object, Void> afterSelectionFunc) {
        this(klass, screen, filedId, primStage, true);
        this.afterSelectionFunc = afterSelectionFunc;
    }

    public void setAfterSelectionFunc(Function<Object, Void> afterSelectionFunc) {
        this.afterSelectionFunc = afterSelectionFunc;
    }

    public Function getAfterSelectionFunc() {
        return this.afterSelectionFunc;
    }

    public NamaSearchBox(Class<?> klass, IHasToolBar screen, String filedId, Stage primStage, boolean jumpToNext) {
        this(klass, screen, filedId, null, primStage, jumpToNext);
    }

    public NamaTextField getNameBox() {
        return this.nameBox;
    }

    public void createSearchBox(Class<?> klass, IHasToolBar screen) {
        this.searchBtn.setSVGIcon("searchInT.svg");
        this.codeBox.textProperty().addListener(l -> {
            if (ObjectChecker.isEmptyOrNull((Object)this.codeBox.textProperty().getValue())) {
                this.nameBox.clear();
                this.idBox.clear();
            }
        });
        this.codeBox.addEventFilter(Event.ANY, e -> {
            if (e instanceof KeyEvent && ObjectChecker.isAnyEqualToFirst((Object)((KeyEvent)e).getCode(), (Object[])new KeyCode[]{KeyCode.F9, KeyCode.ENTER, KeyCode.TAB})) {
                PosCustomToolTipUtil.showCustomTooltipIfNeeded(ObjectChecker.isAnyEqualToFirst((Object)((KeyEvent)e).getCode(), (Object[])new KeyCode[]{KeyCode.ENTER, KeyCode.TAB}), screen, this.onField);
            }
        });
        this.searchBtn.setOnAction(event -> this.searchAction((ActionEvent)event));
    }

    public void searchAction(ActionEvent event) {
        if (!this.isOnPaymentMethod() && this.capability != null && POSSecurityUtil.checkIfHasCapability(this.capability).isFailed().booleanValue()) {
            return;
        }
        if (this.onKlass == null && ObjectChecker.isNotEmptyOrNull((Object)this.namaTypeToSearchIn)) {
            this.searchInNamaForType(this.namaTypeToSearchIn, event);
            return;
        }
        if (ObjectChecker.areEqual(this.onKlass, POSTable.class)) {
            if (ObjectChecker.isNotEmptyOrNull((Object)this.onField) && ObjectChecker.isTrue((Boolean)POSUISettingsUtil.getPosUISettingsOptions().getUseMultiTableAsDefault())) {
                MultiTableDialog multiTableDialog = new MultiTableDialog((AbsPosSalesScreen)this.screen);
                multiTableDialog.setOriginField(this);
                multiTableDialog.fromDialog(this.fromDialog);
                multiTableDialog.showDialog();
            } else {
                POSHallsTablesViewer hallsTablesViewer = new POSHallsTablesViewer(this);
                hallsTablesViewer.fromDialog(this.fromDialog);
                hallsTablesViewer.view();
            }
            return;
        }
        NamaPOSSearchDialog searchDialog = new NamaPOSSearchDialog(this.onField);
        searchDialog.fromDialog(this.fromDialog);
        searchDialog.showDialog(event, this);
    }

    private void searchInNamaForType(String namaTypeToSearchIn, ActionEvent event) {
        POSResult result = new POSResult();
        if (!this.checkIfHasCapability(namaTypeToSearchIn, result)) {
            return;
        }
        if (PosScene.noConnection()) {
            result.failure(POSResourcesUtil.id("Connection Failed", new Object[0]), new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, this.primStage);
            return;
        }
        NamaPOSSearchDialog searchDialog = new NamaPOSSearchDialog();
        searchDialog.setNamaTypeToSearchIn(namaTypeToSearchIn);
        searchDialog.showDialog(event, this);
    }

    private boolean checkIfHasCapability(String namaTypeToSearchIn, POSResult result) {
        if (ObjectChecker.areNotEqual((Object)((Object)this.screen.documentType()), (Object)((Object)POSDocumentType.POSStockReceipt))) {
            return true;
        }
        if (ObjectChecker.areEqual((Object)namaTypeToSearchIn, (Object)"StockTransfer") && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanReceiptFromStockTransfer).isFailed().booleanValue() || ObjectChecker.areEqual((Object)namaTypeToSearchIn, (Object)"PurchaseInvoice") && POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanReceiptFromPurchaseInv).isFailed().booleanValue()) {
            result.failure("You do not have this capability", new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, this.primStage);
            return false;
        }
        return true;
    }

    private boolean isOnPaymentMethod() {
        return ObjectChecker.areEqual(this.onKlass, POSPaymentMethod.class);
    }

    public NamaButton getSearchBtn() {
        return this.searchBtn;
    }

    public Class<?> getOnKlass() {
        return this.onKlass;
    }

    public void setOnKlass(Class<?> onKlass) {
        this.onKlass = onKlass;
    }

    public NamaTextField getCodeBox() {
        return this.codeBox;
    }

    public String fetchCode() {
        return this.codeBox.getText();
    }

    public void hideName() {
        NamaHBox.setHgrow((Node)this.codeBox, (Priority)Priority.ALWAYS);
        this.searchBox.getChildren().removeAll((Object[])new Node[]{this.nameBox});
    }

    public void showName() {
        if (this.searchBox.getChildren().contains((Object)this.nameBox)) {
            return;
        }
        NamaHBox.setHgrow((Node)this.codeBox, (Priority)Priority.SOMETIMES);
        this.searchBox.getChildren().add((Object)this.nameBox);
    }

    public void setCustomeType(String customeType) {
        this.customeType = customeType;
    }

    public String getCustomeType() {
        return this.customeType;
    }

    public void setFromOpenDocAction(Boolean fromOpenDocAction) {
        this.fromOpenDocAction = fromOpenDocAction;
    }

    public Boolean getFromOpenDocAction() {
        return this.fromOpenDocAction;
    }

    public IHasToolBar getScreen() {
        return this.screen;
    }

    public void setScreen(IHasToolBar screen) {
        this.screen = screen;
    }

    public void setEditable(boolean editable) {
        this.getCodeBox().setEditable(editable);
        this.getNameBox().setEditable(editable);
        this.getSearchBtn().setDisable(!editable);
    }

    public void setDisability(boolean disability) {
        this.getCodeBox().setDisable(disability);
        this.getNameBox().setDisable(disability);
        this.getSearchBtn().setDisable(disability);
    }

    public NamaTextField getIdBox() {
        return this.idBox;
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean doNotSetDefault) {
        this.getCodeBox().clear();
        this.getNameBox().clear();
        this.getIdBox().clear();
        if (!doNotSetDefault) {
            NamaSearchBox.setDefaultValueIfNeeded(this.screen, this.onField, this);
        }
    }

    @Override
    public void updateValue(Object value) {
        if (value == null) {
            this.clear();
        } else {
            POSMasterFile masterFile = (POSMasterFile)value;
            this.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)((POSMasterFile)value).getId()));
            this.getCodeBox().setText(masterFile.getCode());
            this.getNameBox().setText(masterFile.nameByLanguage());
        }
    }

    @Override
    public Object fetchValue() {
        if (this.onKlass == null) {
            return this.getIdBox().getText();
        }
        return POSPersister.findByID(this.onKlass, this.getIdBox().getText());
    }

    public boolean isUsedInReport() {
        return this.usedInReport;
    }

    public void setUsedInReport(boolean usedInReport) {
        this.usedInReport = usedInReport;
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        this.getIdBox().setText(ObjectChecker.toStringOrEmpty(value));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    public void updateFromRecord(POSMasterFile record) {
        if (record == null) {
            this.clear(true);
            return;
        }
        this.getIdBox().setText(ServerStringUtils.toUUIDStr((Object)record.getId()));
        this.getCodeBox().setText(record.getCode());
        this.getNameBox().setText(record.nameByLanguage());
    }

    public void requestFocus() {
        this.codeBox.requestFocus();
    }

    public String getOnField() {
        return this.onField;
    }
}

