/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.util.POSScreenSettings;
import javafx.scene.Node;
import javafx.scene.control.TextArea;

public class NamaTextArea
extends TextArea
implements POSField {
    private String title;

    public NamaTextArea(IHasToolBar screen, String fieldId) {
        this("", screen, fieldId);
    }

    public NamaTextArea(String text, IHasToolBar screen, String fieldId) {
        super(text);
        POSSettingsUtil.setFonts(POSScreenSettings.getTextFieldsFont(), this.getClass().getClassLoader(), new Node[]{this});
        NamaSearchBox.setDefaultValueIfNeeded(screen, fieldId, this);
    }

    @Override
    public void updateValue(Object value) {
        this.setText((String)value);
    }

    @Override
    public Object fetchValue() {
        return this.getText();
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        this.setText(ObjectChecker.toStringOrEmpty(value));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public POSFieldType fetchFieldType() {
        return POSFieldType.BigText;
    }
}

