/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.IPosCustomField;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.namacontrols.PosCustomToolTipUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.util.POSImgUtil;
import com.namasoft.pos.util.POSMoneyUtils;
import com.namasoft.pos.util.POSScreenSettings;
import java.math.BigDecimal;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.controlsfx.control.textfield.CustomTextField;

public class NamaTextField
extends CustomTextField
implements POSField,
IHasFont,
IPosCustomField {
    private String title;
    private POSFieldType fieldType;
    private IHasToolBar screen;
    private String fieldId;
    private ImageView errorView = new ImageView();

    public NamaTextField(POSFieldType fieldType) {
        this(fieldType, null, null);
    }

    public NamaTextField(POSFieldType fieldType, IHasToolBar screen, String fieldId) {
        this(true, fieldType, screen, fieldId);
        POSSettingsUtil.setFonts(POSScreenSettings.getTextFieldsFont(), this.getClass().getClassLoader(), new Node[]{this});
        this.applyTextFormatter();
    }

    public NamaTextField() {
        this(null, null);
    }

    public NamaTextField(IHasToolBar screen, String fieldId) {
        this(true, null, screen, fieldId);
    }

    public void disable(boolean value) {
        this.setDisable(value);
    }

    public NamaTextField(boolean jumpToNext, POSFieldType fieldType, IHasToolBar screen, String fieldId) {
        this.fieldType = fieldType;
        this.screen = screen;
        this.fieldId = fieldId;
        if (jumpToNext) {
            NamaTextField.addEnterAndTabEvents((Control)this, screen, fieldId);
        }
        POSSettingsUtil.setFonts(POSScreenSettings.getTextFieldsFont(), this.getClass().getClassLoader(), new Node[]{this});
        this.applyTextFormatter();
        this.errorView.setImage(POSImgUtil.fetchSVGImage("errorsMenuBtn.svg"));
        this.setRight((Node)this.errorView);
        this.setErrorViewVisibility(false);
        this.textProperty().addListener((observable, oldValue, newValue) -> {
            if (ObjectChecker.isNotEmptyOrNull((Object)newValue)) {
                this.setErrorViewVisibility(false);
            }
        });
    }

    @Override
    public void addErrorMarkToField() {
        this.setErrorViewVisibility(true);
    }

    private void setErrorViewVisibility(boolean visible) {
        this.errorView.setVisible(visible);
        this.errorView.setManaged(visible);
    }

    public static void addEnterAndTabEvents(Control control) {
        NamaTextField.addEnterAndTabEvents(control, null, null);
    }

    public static void addEnterAndTabEvents(Control control_, IHasToolBar screen, String fieldId) {
        control_.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            Control control = (Control)event.getTarget();
            if (ObjectChecker.isAnyEqualToFirst((Object)event.getCode(), (Object[])new KeyCode[]{KeyCode.TAB, KeyCode.ENTER})) {
                boolean focusChanged;
                boolean bl = focusChanged = !control.isFocused();
                if (!focusChanged) {
                    for (Node child : control.getParent().getChildrenUnmodifiable()) {
                        if (child.isDisable() || !child.isFocusTraversable()) continue;
                        child.requestFocus();
                        break;
                    }
                }
                if (screen != null) {
                    PosCustomToolTipUtil.showCustomTooltipIfNeeded(true, screen, fieldId);
                }
            }
            if (event.getCode() == KeyCode.ESCAPE && control instanceof NamaTextField) {
                ((NamaTextField)control).clear();
            }
        });
    }

    private void applyTextFormatter() {
        NamaSearchBox.setDefaultValueIfNeeded(this.screen, this.fieldId, this);
        if (ObjectChecker.isNotEmptyOrNull((Object)((Object)this.fieldType)) && ObjectChecker.NOTisAnyEqualToFirst((Object)((Object)this.fieldType), (Object[])new POSFieldType[]{POSFieldType.Decimal, POSFieldType.Percentage})) {
            return;
        }
        StringConverter<BigDecimal> converter = new StringConverter<BigDecimal>(){

            public BigDecimal fromString(String s) {
                if (ObjectChecker.isEmptyOrNull((Object)s)) {
                    return BigDecimal.ZERO;
                }
                try {
                    BigDecimal decimal = new BigDecimal(s);
                    Integer fractionalDecimalPlaces = POSMoneyUtils.fractionalDecimalPlaces;
                    if (ObjectChecker.areEqual((Object)((Object)NamaTextField.this.fieldType), (Object)((Object)POSFieldType.Percentage))) {
                        fractionalDecimalPlaces = POSMoneyUtils.getPercentageScale();
                    }
                    return NaMaMath.round((BigDecimal)decimal, (Integer)fractionalDecimalPlaces);
                }
                catch (Exception e) {
                    return BigDecimal.ZERO;
                }
            }

            public String toString(BigDecimal d) {
                if (ObjectChecker.isEmptyOrZero((BigDecimal)d)) {
                    return "";
                }
                Integer displayDecimalPlaces = POSMoneyUtils.displayDecimalPlaces;
                return NaMaMath.round((BigDecimal)d, (Integer)displayDecimalPlaces).toString();
            }
        };
        TextFormatter textFormatter = new TextFormatter((StringConverter)converter);
        this.setTextFormatter(textFormatter);
    }

    @Override
    public void updateValue(Object value) {
        this.setText((String)value);
    }

    @Override
    public Object fetchValue() {
        if (ObjectChecker.isEmptyOrNull((Object)((Object)this.fieldType))) {
            return this.getText();
        }
        try {
            switch (this.fieldType) {
                case Long: {
                    return ObjectChecker.tryParseLong((String)this.getText());
                }
                case Decimal: {
                    return ObjectChecker.tryParseDecimal((String)this.getText());
                }
                case Integer: {
                    return ObjectChecker.tryParseInt((String)this.getText());
                }
            }
            return this.getText();
        }
        catch (Exception e) {
            return this.getText();
        }
    }

    @Override
    public <T> void updateValueFromQuestionField(T value) {
        this.setText(ObjectChecker.toStringOrEmpty(value));
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void clear() {
        super.clear();
        NamaSearchBox.setDefaultValueIfNeeded(this.screen, this.fieldId, this);
    }
}

