/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.util.POSResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class NamaTimeField
extends NamaTextField {
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm");
    private final List<Character> numbers = Arrays.asList(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'));

    public NamaTimeField() {
        super(POSFieldType.Text);
        AbsPosSalesScreen.preventNegativeSignAndChars(this);
        this.textProperty().addListener(v -> {
            if (this.isCorrectTime()) {
                this.setStyle("-fx-text-fill: black;");
            } else {
                this.setStyle("-fx-text-fill: red;");
            }
        });
    }

    public POSResult isValidTime(POSResult result) {
        this.isCorrectTime(this.getText(), result);
        return result;
    }

    private boolean isCorrectTime() {
        return this.isCorrectTime(this.getText(), null);
    }

    private boolean isCorrectTime(String value, POSResult result) {
        if (ObjectChecker.isEmptyOrNull((Object)(value = value.trim()))) {
            return true;
        }
        String invalidTimeMessage = "You must enter valid time. ex: 2353, 23.53 or 23:53.";
        if (value.length() > 5) {
            if (result != null) {
                result.failure(invalidTimeMessage + " You can enter 5 characters at most.", new Object[0]);
            }
            return false;
        }
        int separatorNo = 0;
        Integer separatorIndex = null;
        for (char c : value.toCharArray()) {
            if (this.isNumericalChar(c)) continue;
            ++separatorNo;
            separatorIndex = value.indexOf(c);
        }
        if (separatorNo > 1) {
            if (result != null) {
                result.failure(invalidTimeMessage + " You can enter 1 separator at most.", new Object[0]);
            }
            return false;
        }
        if (separatorIndex != null && (0 + separatorIndex > 2 || value.length() - 1 - separatorIndex > 2)) {
            if (result != null) {
                result.failure(invalidTimeMessage + " The separator must be after or before 2 characters at most.", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean isNumericalChar(char c) {
        return this.numbers.contains(Character.valueOf(c));
    }

    @Override
    public void updateValue(Object value) {
        String time = "";
        if (value instanceof TemporalAccessor) {
            TemporalAccessor temporalAccessor = (TemporalAccessor)value;
            time = timeFormat.format(temporalAccessor);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            LocalDateTime ldt = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
            time = timeFormat.format(ldt);
        }
        super.updateValue(time);
    }

    @Override
    public Date fetchValue() {
        return this.parseValue(ObjectChecker.toStringOrEmpty((Object)this.getText()));
    }

    public Date parseValue(String value) {
        if (ObjectChecker.isEmptyOrNull((Object)(value = value.trim()))) {
            return null;
        }
        if (!this.isCorrectTime()) {
            return null;
        }
        Integer separatorIndex = null;
        for (int i = 0; i < value.length(); ++i) {
            if (this.isNumericalChar(value.charAt(i))) continue;
            separatorIndex = i;
            break;
        }
        String hours = "00";
        String minutes = "00";
        if (separatorIndex != null) {
            hours = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{value.substring(0, separatorIndex), hours});
            if (value.length() >= separatorIndex + 1) {
                minutes = value.substring(separatorIndex + 1);
            }
        } else if (value.length() > 2) {
            hours = value.substring(0, 2);
            minutes = value.substring(2);
        } else {
            hours = value.substring(0);
        }
        try {
            LocalTime lt = LocalTime.parse(String.format("%02d:%02d", Integer.parseInt(hours), Integer.parseInt(minutes)), timeFormat);
            return Date.from(lt.atDate(LocalDate.now()).atZone(ZoneId.systemDefault()).toInstant());
        }
        catch (DateTimeParseException e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    public LocalTime fetchLocalTime() {
        return LocalDateUtils.dateToLocalTime((Date)this.fetchValue());
    }
}

