/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.flatobjects.LocalDateUtils;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.contracts.common.dtos.requests.FindByBusinessCodeRequest;
import com.namasoft.contracts.common.services.BaseEntityServiceProxy;
import com.namasoft.erp.guiserver.ServiceUtility;
import com.namasoft.modules.commonbasic.contracts.entities.DTOCustomer;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.namacontrols.NamaCheckBox;
import com.namasoft.namacontrols.NamaComboBox;
import com.namasoft.namacontrols.NamaDatePicker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaLabel;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.details.AbsPOSFieldLine;
import com.namasoft.pos.domain.details.POSExtraCodeLine;
import com.namasoft.pos.domain.entities.POSCustomer;
import com.namasoft.pos.domain.entities.POSCustomerCategory;
import com.namasoft.pos.domain.entities.POSCustomerClass;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import com.namasoft.pos.util.PosSalesUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class POSAddCustomerDialog {
    private String header = "";
    private NamaTextField code;
    private NamaTextField name;
    private NamaTextField name2;
    private NamaTextField phoneNum;
    private NamaTextField address;
    private NamaTextField countryCode;
    private NamaTextField city;
    private NamaTextField area;
    private NamaTextField district;
    private NamaTextField street;
    private NamaTextField landPlotNumber;
    private NamaTextField buildingNumber;
    private NamaTextField postalCode;
    private NamaTextField residency;
    private NamaSearchBox customerClass;
    private NamaSearchBox customerCategory;
    private NamaTextField n1;
    private NamaTextField n2;
    private NamaTextField n3;
    private NamaTextField n4;
    private NamaTextField n5;
    private NamaTextField description1;
    private NamaTextField description2;
    private NamaTextField description3;
    private NamaTextField description4;
    private NamaTextField description5;
    private NamaTextField taxRegNo;
    private NamaComboBox<String> companyType;
    private NamaDatePicker date1;
    private NamaDatePicker date2;
    private NamaDatePicker date3;
    private NamaDatePicker date4;
    private NamaDatePicker date5;
    private int colIndex = 0;
    private int rowIndex = 0;
    private POSCustomer currentRecord;
    private NamaCheckBox preventUsage;
    private GridPane grid;
    private NamaDialog<ButtonType> dialog = new NamaDialog("addCustomer");
    private boolean valid = true;
    private static boolean isShown = false;

    public void setCurrentRecord(POSCustomer currentRecord) {
        this.currentRecord = currentRecord;
    }

    public POSAddCustomerDialog() {
        this.dialog.addOkButton("");
        this.dialog.addCancelButton("");
        this.dialog.addScrollPane();
        this.grid = new GridPane();
        this.grid.setId("customer-dialog");
        this.code = new NamaTextField(POSFieldType.Text);
        this.name = new NamaTextField(POSFieldType.Text);
        this.name2 = new NamaTextField(POSFieldType.Text);
        this.phoneNum = new NamaTextField(POSFieldType.Text);
        this.address = new NamaTextField(POSFieldType.Text);
        this.countryCode = new NamaTextField(POSFieldType.Text);
        this.city = new NamaTextField(POSFieldType.Text);
        this.area = new NamaTextField(POSFieldType.Text);
        this.district = new NamaTextField(POSFieldType.Text);
        this.street = new NamaTextField(POSFieldType.Text);
        this.landPlotNumber = new NamaTextField(POSFieldType.Text);
        this.buildingNumber = new NamaTextField(POSFieldType.Text);
        this.postalCode = new NamaTextField(POSFieldType.Text);
        this.residency = new NamaTextField(POSFieldType.Text);
        this.n1 = new NamaTextField(POSFieldType.Decimal);
        this.n2 = new NamaTextField(POSFieldType.Decimal);
        this.n3 = new NamaTextField(POSFieldType.Decimal);
        this.n4 = new NamaTextField(POSFieldType.Decimal);
        this.n5 = new NamaTextField(POSFieldType.Decimal);
        this.description1 = new NamaTextField(POSFieldType.Text);
        this.description2 = new NamaTextField(POSFieldType.Text);
        this.description3 = new NamaTextField(POSFieldType.Text);
        this.description4 = new NamaTextField(POSFieldType.Text);
        this.description5 = new NamaTextField(POSFieldType.Text);
        this.taxRegNo = new NamaTextField(POSFieldType.Text);
        this.companyType = new NamaComboBox<String>(Arrays.asList("Government", "PrivateSector", "Individual", "Foreigner"), POSResourcesUtil.currentScreen, "customer.companyType");
        this.companyType.setConverter((StringConverter)new StringConverter<String>(this){

            public String toString(String object) {
                return POSResourcesUtil.id(object, new Object[0]);
            }

            public String fromString(String string) {
                return string;
            }
        });
        this.date1 = new NamaDatePicker();
        this.date2 = new NamaDatePicker();
        this.date3 = new NamaDatePicker();
        this.date4 = new NamaDatePicker();
        this.date5 = new NamaDatePicker();
        this.customerClass = new NamaSearchBox(POSCustomerClass.class, null, "", null);
        this.customerClass.setFromDialog(this.dialog);
        this.customerCategory = new NamaSearchBox(POSCustomerCategory.class, null, "", null);
        this.customerCategory.setFromDialog(this.dialog);
        this.dialog.getDialogPane().getScene().setNodeOrientation(POSResourcesUtil.getOrientation());
        this.dialog.content((Node)this.grid);
        this.preventUsage = new NamaCheckBox("Customer.preventUsage");
        PosSalesUtil.updateGenericReferenceOverriderData();
        EventHandler parentOnShowing = this.dialog.getOnShowing();
        EventHandler parentOnHidden = this.dialog.getOnHiding();
        this.dialog.setOnShowing(e -> {
            parentOnShowing.handle(e);
            isShown = true;
        });
        this.dialog.setOnHiding(e -> {
            parentOnHidden.handle(e);
            isShown = false;
        });
        POSSettingsUtil.addStyleSheetFor("css/salesscreen.css", (Parent)this.dialog.getDialogPane());
    }

    public void showDialog(IHasToolBar screen, String defaultCode) {
        this.checkIfThereIsCustomerWithTheSameCodeInServer(defaultCode, screen.fetchStage());
        if (isShown || POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanAddCustomer).isFailed().booleanValue()) {
            return;
        }
        this.dialog.title(this.currentRecord == null ? "addCustomer" : "editCustomer");
        this.dialog.setOkAction(e -> this.addCustomerAction(screen));
        this.dialog.initOwner((Window)screen.fetchStage());
        this.customerClass.setScreen(screen);
        this.customerCategory.setScreen(screen);
        if (ObjectChecker.isEmptyOrNull((Object)this.code.getText())) {
            this.code.setText(defaultCode);
        }
        this.updateDataFromRecordIfNeeded(this.currentRecord);
        this.draw(screen, defaultCode);
        this.showAndWait(screen);
    }

    private void checkIfThereIsCustomerWithTheSameCodeInServer(String defaultCode, Stage stage) {
        if (ObjectChecker.isEmptyOrNull((Object)defaultCode)) {
            return;
        }
        Runnable runnable = () -> {
            BaseEntityServiceProxy ws = (BaseEntityServiceProxy)ServiceUtility.getServiceClient((String)"Customer");
            DTOCustomer dtoCustomer = (DTOCustomer)ws.findByBusinessCode(new FindByBusinessCodeRequest("Customer", defaultCode)).getData();
            if (dtoCustomer == null) {
                return;
            }
            POSCustomer customer = new POSCustomer();
            customer.updateData(dtoCustomer);
            POSResult result = POSPersister.saveOrUpdate(customer);
            if (result.isFailed().booleanValue()) {
                return;
            }
            Platform.runLater(() -> {
                POSErrorAndInfoMessagesUtil.showError(POSResourcesUtil.id("There is customer with the same code", new Object[0]) + ": " + defaultCode, stage);
                this.updateDataFromRecordIfNeeded(customer);
            });
        };
        Thread thread = new Thread(runnable);
        thread.setName("searchForCustomerInServerByBusinessCode");
        thread.setDaemon(true);
        thread.start();
    }

    private void draw(IHasToolBar screen, String defaultCode) {
        this.code.setPromptText(POSResourcesUtil.id("Customer.code", new Object[0]));
        this.name.setPromptText(POSResourcesUtil.id("Customer.name1", new Object[0]));
        this.name2.setPromptText(POSResourcesUtil.id("Customer.name2", new Object[0]));
        this.phoneNum.setPromptText(POSResourcesUtil.id("Customer.phoneNum", new Object[0]));
        this.address.setPromptText(POSResourcesUtil.id("Customer.address", new Object[0]));
        this.countryCode.setPromptText(POSResourcesUtil.id("Customer.countryCode", new Object[0]));
        this.city.setPromptText(POSResourcesUtil.id("Customer.city", new Object[0]));
        this.area.setPromptText(POSResourcesUtil.id("Customer.area", new Object[0]));
        this.district.setPromptText(POSResourcesUtil.id("Customer.district", new Object[0]));
        this.street.setPromptText(POSResourcesUtil.id("Customer.street", new Object[0]));
        this.landPlotNumber.setPromptText(POSResourcesUtil.id("Customer.landPlotNumber", new Object[0]));
        this.buildingNumber.setPromptText(POSResourcesUtil.id("Customer.buildingNumber", new Object[0]));
        this.postalCode.setPromptText(POSResourcesUtil.id("Customer.postalCode", new Object[0]));
        this.residency.setPromptText(POSResourcesUtil.id("Customer.residency", new Object[0]));
        this.n1.setPromptText(POSResourcesUtil.id("Customer.n1", new Object[0]));
        this.n2.setPromptText(POSResourcesUtil.id("Customer.n2", new Object[0]));
        this.n3.setPromptText(POSResourcesUtil.id("Customer.n3", new Object[0]));
        this.n4.setPromptText(POSResourcesUtil.id("Customer.n4", new Object[0]));
        this.n5.setPromptText(POSResourcesUtil.id("Customer.n5", new Object[0]));
        this.description1.setPromptText(POSResourcesUtil.id("Customer.description1", new Object[0]));
        this.description2.setPromptText(POSResourcesUtil.id("Customer.description2", new Object[0]));
        this.description3.setPromptText(POSResourcesUtil.id("Customer.description3", new Object[0]));
        this.description4.setPromptText(POSResourcesUtil.id("Customer.description4", new Object[0]));
        this.description5.setPromptText(POSResourcesUtil.id("Customer.description5", new Object[0]));
        this.taxRegNo.setPromptText(POSResourcesUtil.id("Customer.taxRegNo", new Object[0]));
        this.companyType.setPromptText(POSResourcesUtil.id("Customer.companyType", new Object[0]));
        this.date1.setPromptText(POSResourcesUtil.id("Customer.date1", new Object[0]));
        this.date2.setPromptText(POSResourcesUtil.id("Customer.date2", new Object[0]));
        this.date3.setPromptText(POSResourcesUtil.id("Customer.date3", new Object[0]));
        this.date4.setPromptText(POSResourcesUtil.id("Customer.date4", new Object[0]));
        this.date5.setPromptText(POSResourcesUtil.id("Customer.date5", new Object[0]));
        List fields = POSUISettingsUtil.getPosUISettings().getCustomerFields().stream().map(AbsPOSFieldLine::getField).collect(Collectors.toList());
        if (ObjectChecker.isEmptyOrNull(fields)) {
            fields.addAll(Arrays.asList("code", "name1", "name2"));
        }
        for (String field : fields) {
            if (ObjectChecker.areEqual((Object)field, (Object)"code")) {
                this.addField(this.code, "code", "Customer.code", defaultCode);
                this.code.focusTraversableProperty().addListener((observable, oldValue, newValue) -> {
                    if (!this.code.isFocused() && ObjectChecker.isNotEmptyOrNull((Object)this.code)) {
                        this.fireExistingCustomerActionIfCustomerExist(screen);
                    }
                });
                this.code.focusedProperty().addListener((observable, oldValue, newValue) -> {
                    if (!newValue.booleanValue() && ObjectChecker.isNotEmptyOrNull((Object)this.code)) {
                        this.fireExistingCustomerActionIfCustomerExist(screen);
                    }
                });
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"name1")) {
                this.addField(this.name, "name1", "Customer.name1", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"name2")) {
                this.addField(this.name2, "name2", "Customer.name2", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"phoneNumber")) {
                this.addField(this.phoneNum, "contactInfo.mobile", "Customer.phoneNum", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"address")) {
                this.addField(this.address, "contactInfo.address.address1", "Customer.address", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"countryCode")) {
                this.addField(this.countryCode, "contactInfo.address.countryCode", "Customer.countryCode", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"city")) {
                this.addField(this.city, "contactInfo.address.city", "Customer.city", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"area")) {
                this.addField(this.area, "contactInfo.address.area", "Customer.area", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"district")) {
                this.addField(this.district, "contactInfo.address.district", "Customer.district", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"street")) {
                this.addField(this.street, "contactInfo.address.street", "Customer.street", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"landPlotNumber")) {
                this.addField(this.landPlotNumber, "contactInfo.address.landPlotNumber", "Customer.landPlotNumber", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"buildingNumber")) {
                this.addField(this.buildingNumber, "contactInfo.address.buildingNumber", "Customer.buildingNumber", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"postalCode")) {
                this.addField(this.postalCode, "contactInfo.address.postalCode", "Customer.postalCode", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"customerClass")) {
                this.addField(this.customerClass, "customerClass", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"customerCategory")) {
                this.addField(this.customerCategory, "customerCategory", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"preventUsage")) {
                this.addField(this.preventUsage, "preventUsage", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"residency")) {
                this.addField(this.residency, "residency.number", "Customer.residency", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"n1")) {
                this.addField(this.n1, "n1", "Customer.n1", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"n2")) {
                this.addField(this.n2, "n2", "Customer.n2", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"n3")) {
                this.addField(this.n3, "n3", "Customer.n3", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"n4")) {
                this.addField(this.n4, "n4", "Customer.n4", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"n5")) {
                this.addField(this.n5, "n5", "Customer.n5", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"description1")) {
                this.addField(this.description1, "Customer.description1", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"description2")) {
                this.addField(this.description2, "Customer.description2", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"description3")) {
                this.addField(this.description3, "Customer.description3", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"description4")) {
                this.addField(this.description4, "Customer.description4", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"description5")) {
                this.addField(this.description5, "Customer.description5", "", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"taxRegNo")) {
                this.addField(this.taxRegNo, "taxRegNo", "Customer.taxRegNo", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"companyType")) {
                this.addField(this.companyType, "companyType", "Customer.companyType", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"date1")) {
                this.addField(this.date1, "date1", "Customer.date1", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"date2")) {
                this.addField(this.date2, "date2", "Customer.date2", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"date3")) {
                this.addField(this.date3, "date3", "Customer.date3", defaultCode);
                continue;
            }
            if (ObjectChecker.areEqual((Object)field, (Object)"date4")) {
                this.addField(this.date4, "date4", "Customer.date4", defaultCode);
                continue;
            }
            if (!ObjectChecker.areEqual((Object)field, (Object)"date5")) continue;
            this.addField(this.date5, "date5", "Customer.date5", defaultCode);
        }
    }

    private void addCustomerAction(IHasToolBar screen) {
        boolean isCustomerExist = this.fireExistingCustomerActionIfCustomerExist(screen);
        if (isCustomerExist) {
            return;
        }
        this.valid = this.validateInputs(screen);
    }

    private void showAndWait(IHasToolBar screen) {
        Optional result = this.dialog.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.CANCEL_CLOSE)) {
            return;
        }
        if (!this.valid) {
            this.valid = true;
            this.showAndWait(screen);
        }
    }

    private void addField(POSField control, String fieldId, String fieldName, String defaultCode) {
        if (this.isExtraCode(fieldId) && PosSalesUtil.checkCustomerFieldFormats(fieldId, defaultCode, PosSalesUtil.getFormatLines()).isSucceeded().booleanValue() && ObjectChecker.isEmptyOrNull((Object)control.fetchValue())) {
            control.updateValue(defaultCode);
        }
        this.grid.add((Node)new NamaLabel((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{fieldName, fieldId})), this.colIndex, this.rowIndex);
        this.grid.add((Node)control, ++this.colIndex, this.rowIndex);
        this.updateRowAndColIndices();
    }

    private boolean isExtraCode(String fieldId) {
        if (ObjectChecker.areEqual((Object)fieldId, (Object)"contactInfo.mobile")) {
            return true;
        }
        for (POSExtraCodeLine o : PosSalesUtil.getExtraCodes()) {
            if (!ObjectChecker.areEqual((Object)o.getFieldID(), (Object)fieldId)) continue;
            return true;
        }
        return false;
    }

    private void updateDataFromRecordIfNeeded(POSCustomer currentRecord) {
        if (currentRecord == null) {
            return;
        }
        this.code.setText(currentRecord.getCode());
        this.name.setText(currentRecord.getName1());
        this.name2.setText(currentRecord.getName2());
        this.phoneNum.setText(currentRecord.getPhoneNumber());
        this.residency.setText(currentRecord.getResidency());
        this.address.setText(currentRecord.getAddress());
        this.countryCode.setText(currentRecord.getCountryCode());
        this.city.setText(currentRecord.getCity());
        this.area.setText(currentRecord.getArea());
        this.district.setText(currentRecord.getDistrict());
        this.street.setText(currentRecord.getStreet());
        this.landPlotNumber.setText(currentRecord.getLandPlotNumber());
        this.buildingNumber.setText(currentRecord.getBuildingNumber());
        this.postalCode.setText(currentRecord.getPostalCode());
        this.customerCategory.updateFromRecord(currentRecord.getCustomerCategory());
        this.customerClass.updateFromRecord(currentRecord.getCustomerClass());
        this.n1.setText(ObjectChecker.toStringOrEmpty((Object)currentRecord.getN1()));
        this.n2.setText(ObjectChecker.toStringOrEmpty((Object)currentRecord.getN2()));
        this.n3.setText(ObjectChecker.toStringOrEmpty((Object)currentRecord.getN3()));
        this.n4.setText(ObjectChecker.toStringOrEmpty((Object)currentRecord.getN4()));
        this.n5.setText(ObjectChecker.toStringOrEmpty((Object)currentRecord.getN5()));
        this.description1.setText(currentRecord.getDescription1());
        this.description2.setText(currentRecord.getDescription2());
        this.description3.setText(currentRecord.getDescription3());
        this.description4.setText(currentRecord.getDescription4());
        this.description5.setText(currentRecord.getDescription5());
        this.taxRegNo.setText(currentRecord.getTaxRegNo());
        this.companyType.setValue(currentRecord.getCompanyType());
        this.date1.setValue(LocalDateUtils.dateToLocalDate((Date)currentRecord.getDate1()));
        this.date2.setValue(LocalDateUtils.dateToLocalDate((Date)currentRecord.getDate2()));
        this.date3.setValue(LocalDateUtils.dateToLocalDate((Date)currentRecord.getDate3()));
        this.date4.setValue(LocalDateUtils.dateToLocalDate((Date)currentRecord.getDate4()));
        this.date5.setValue(LocalDateUtils.dateToLocalDate((Date)currentRecord.getDate5()));
        this.preventUsage.updateValueFromQuestionField(currentRecord.getPreventUsage());
    }

    private void updateRowAndColIndices() {
        if (this.colIndex >= 3) {
            this.colIndex = 0;
            ++this.rowIndex;
        } else {
            ++this.colIndex;
        }
    }

    private boolean fireExistingCustomerActionIfCustomerExist(IHasToolBar screen) {
        if (this.currentRecord != null) {
            return false;
        }
        POSCustomer customer = (POSCustomer)POSPersister.findByCode(POSCustomer.class, this.code.getText());
        if (ObjectChecker.isNotEmptyOrNull((Object)this.code.getText()) && ObjectChecker.isNotEmptyOrNull((Object)customer)) {
            screen.onCustomerAdded(customer);
            this.dialog.hide();
            return true;
        }
        return false;
    }

    private boolean validateInputs(IHasToolBar screen) {
        POSCustomer posCustomer = this.currentRecord;
        if (posCustomer == null) {
            posCustomer = new POSCustomer(this.code.getText(), this.name.getText(), this.name2.getText(), this.phoneNum.getText(), this.address.getText(), this.residency.getText(), this.area.getText());
        }
        posCustomer.setCode(POSAddCustomerDialog.trim(this.code.getText()));
        posCustomer.setName1(((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.name.getText(), this.code.getText()})).trim());
        posCustomer.setName2(((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{this.name2.getText(), this.code.getText()})).trim());
        posCustomer.setResidency(POSAddCustomerDialog.trim(this.residency.getText()));
        posCustomer.setPhoneNumber(POSAddCustomerDialog.trim(this.phoneNum.getText()));
        posCustomer.setAddress(POSAddCustomerDialog.trim(this.address.getText()));
        posCustomer.setCountryCode(POSAddCustomerDialog.trim(this.countryCode.getText()));
        posCustomer.setCity(POSAddCustomerDialog.trim(this.city.getText()));
        posCustomer.setArea(POSAddCustomerDialog.trim(this.area.getText()));
        posCustomer.setDistrict(POSAddCustomerDialog.trim(this.district.getText()));
        posCustomer.setStreet(POSAddCustomerDialog.trim(this.street.getText()));
        posCustomer.setLandPlotNumber(POSAddCustomerDialog.trim(this.landPlotNumber.getText()));
        posCustomer.setBuildingNumber(POSAddCustomerDialog.trim(this.buildingNumber.getText()));
        posCustomer.setPostalCode(POSAddCustomerDialog.trim(this.postalCode.getText()));
        posCustomer.setCustomerClass((POSCustomerClass)this.customerClass.fetchValue());
        posCustomer.setCustomerCategory((POSCustomerCategory)this.customerCategory.fetchValue());
        posCustomer.setN1(ObjectChecker.tryParseDecimal((String)this.n1.getText()));
        posCustomer.setN2(ObjectChecker.tryParseDecimal((String)this.n2.getText()));
        posCustomer.setN3(ObjectChecker.tryParseDecimal((String)this.n3.getText()));
        posCustomer.setN4(ObjectChecker.tryParseDecimal((String)this.n4.getText()));
        posCustomer.setN5(ObjectChecker.tryParseDecimal((String)this.n5.getText()));
        posCustomer.setDescription1(POSAddCustomerDialog.trim(this.description1.getText()));
        posCustomer.setDescription2(POSAddCustomerDialog.trim(this.description2.getText()));
        posCustomer.setDescription3(POSAddCustomerDialog.trim(this.description3.getText()));
        posCustomer.setDescription4(POSAddCustomerDialog.trim(this.description4.getText()));
        posCustomer.setDescription5(POSAddCustomerDialog.trim(this.description5.getText()));
        posCustomer.setTaxRegNo(POSAddCustomerDialog.trim(this.taxRegNo.getText()));
        posCustomer.setCompanyType((String)this.companyType.getValue());
        posCustomer.setDate1((Date)this.date1.fetchValue());
        posCustomer.setDate2((Date)this.date2.fetchValue());
        posCustomer.setDate3((Date)this.date3.fetchValue());
        posCustomer.setDate4((Date)this.date4.fetchValue());
        posCustomer.setDate5((Date)this.date5.fetchValue());
        posCustomer.setCreationDate(new Date());
        posCustomer.setSent(false);
        posCustomer.setPreventUsage((Boolean)this.preventUsage.fetchValue());
        List<String> errors = PosSalesUtil.validateAndCreateIfNeeded(POSResourcesUtil.fetchMainRegister(), posCustomer);
        if (ObjectChecker.isNotEmptyOrNull(errors)) {
            this.header = StringUtils.toCSVLine((Object[])new Object[]{" - ", errors.stream().map(x$0 -> POSResourcesUtil.id(x$0, new Object[0])).collect(Collectors.toList())});
            this.dialog.error(this.header);
            return false;
        }
        this.code = new NamaTextField(POSFieldType.Text);
        this.name = new NamaTextField(POSFieldType.Text);
        this.name2 = new NamaTextField(POSFieldType.Text);
        this.phoneNum = new NamaTextField(POSFieldType.Text);
        this.address = new NamaTextField(POSFieldType.Text);
        this.countryCode = new NamaTextField(POSFieldType.Text);
        this.city = new NamaTextField(POSFieldType.Text);
        this.area = new NamaTextField(POSFieldType.Text);
        this.district = new NamaTextField(POSFieldType.Text);
        this.street = new NamaTextField(POSFieldType.Text);
        this.landPlotNumber = new NamaTextField(POSFieldType.Text);
        this.buildingNumber = new NamaTextField(POSFieldType.Text);
        this.postalCode = new NamaTextField(POSFieldType.Text);
        this.residency = new NamaTextField(POSFieldType.Text);
        this.n1 = new NamaTextField(POSFieldType.Decimal);
        this.n2 = new NamaTextField(POSFieldType.Decimal);
        this.n3 = new NamaTextField(POSFieldType.Decimal);
        this.n4 = new NamaTextField(POSFieldType.Decimal);
        this.n5 = new NamaTextField(POSFieldType.Decimal);
        this.description1 = new NamaTextField(POSFieldType.Text);
        this.description2 = new NamaTextField(POSFieldType.Text);
        this.description3 = new NamaTextField(POSFieldType.Text);
        this.description4 = new NamaTextField(POSFieldType.Text);
        this.description5 = new NamaTextField(POSFieldType.Text);
        this.taxRegNo = new NamaTextField(POSFieldType.Text);
        this.date1 = new NamaDatePicker();
        this.date2 = new NamaDatePicker();
        this.date3 = new NamaDatePicker();
        this.date4 = new NamaDatePicker();
        this.date5 = new NamaDatePicker();
        this.preventUsage = new NamaCheckBox("Customer.preventUsage");
        this.header = "";
        this.grid.getChildren().clear();
        this.colIndex = 0;
        this.rowIndex = 0;
        if (this.currentRecord == null) {
            screen.onCustomerAdded(posCustomer);
        }
        this.dialog.hide();
        return true;
    }

    private static String trim(String s) {
        return ObjectChecker.toStringOrEmpty((Object)s).trim();
    }
}

