/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.Pair;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.namacontrols.POSFavouriteBtnQueryUtil;
import com.namasoft.namacontrols.POSNormalFavouriteBtn;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.controllers.MobileCompositePOSFavouriteBtn;
import com.namasoft.pos.controllers.MobilePOSLiteMasterFile;
import com.namasoft.pos.domain.POSLiteCompositeFavouriteBtn;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.details.POSFavouriteLine;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.entities.POSItemBrand;
import com.namasoft.pos.domain.entities.POSItemCategory;
import com.namasoft.pos.domain.entities.POSItemClass1;
import com.namasoft.pos.domain.entities.POSItemClass10;
import com.namasoft.pos.domain.entities.POSItemClass2;
import com.namasoft.pos.domain.entities.POSItemClass3;
import com.namasoft.pos.domain.entities.POSItemClass4;
import com.namasoft.pos.domain.entities.POSItemClass5;
import com.namasoft.pos.domain.entities.POSItemClass6;
import com.namasoft.pos.domain.entities.POSItemClass7;
import com.namasoft.pos.domain.entities.POSItemClass8;
import com.namasoft.pos.domain.entities.POSItemClass9;
import com.namasoft.pos.domain.valueobjects.FavouriteItemLevel;
import com.namasoft.pos.domain.valueobjects.POSFavouriteBtnLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;

public class POSCompositeFavouriteBtn
extends POSFavouriteBtn {
    private POSFavouriteBtnLevel level;
    private String btnQuery;
    private String btnItemsQuery;
    private String btnItemsQueryForCount;
    private POSCompositeFavouriteBtn parentBtn;
    private String foreignKeyFieldId;
    private Class searchInKlass;
    private POSFavouriteLine favouriteItem;
    private HashMap<String, Object> params = new HashMap();
    private HashMap<String, Object> allParams;
    private boolean shouldFilterSellable = true;
    private static Map<String, POSSavable> cache = new HashMap<String, POSSavable>();
    private static HashMap<String, String> foreignKeyFieldIds = new HashMap();

    public POSFavouriteBtnLevel getLevel() {
        return this.level;
    }

    public POSCompositeFavouriteBtn(MobilePOSLiteMasterFile liteMasterFile) {
        super(new POSLiteMasterFile(liteMasterFile.getId(), liteMasterFile.getName1(), liteMasterFile.getName2()));
        MobileCompositePOSFavouriteBtn favouriteBtn = liteMasterFile.getBtn();
        this.level = favouriteBtn.getLevel();
        this.btnQuery = favouriteBtn.getBtnQuery();
        this.btnItemsQuery = favouriteBtn.getBtnItemsQuery();
        this.btnItemsQueryForCount = favouriteBtn.getBtnItemsQueryForCount();
        this.foreignKeyFieldId = favouriteBtn.getForeignKeyFieldId();
        this.searchInKlass = favouriteBtn.getSearchInKlass();
        this.favouriteItem = favouriteBtn.getFavouriteItem();
        this.params = favouriteBtn.getParams();
        this.allParams = favouriteBtn.getAllParams();
    }

    public POSCompositeFavouriteBtn(POSFavouriteLine favouriteItem, AbsPosSalesScreen screen, POSFavouriteBtnLevel level, POSLiteMasterFile currentRecord, POSCompositeFavouriteBtn parentBtn) {
        super(currentRecord);
        this.level = level;
        this.parentBtn = parentBtn;
        if (ObjectChecker.isNotEmptyOrNull((Object)currentRecord)) {
            this.currentRecord = currentRecord;
        }
        this.favouriteItem = favouriteItem;
        boolean bl = this.shouldFilterSellable = screen == null || !screen.stockTransferOrTaking();
        if (ObjectChecker.areEqual((Object)((Object)level), (Object)((Object)POSFavouriteBtnLevel.Level1))) {
            Object categoryOrClass = POSSavable.staticFromReference(new EntityReferenceData(favouriteItem.getFavouritesLevel1EntityType(), ObjectChecker.toStringOrEmpty((Object)favouriteItem.getFavouritesLevel1Id())));
            this.currentRecord = new POSLiteMasterFile(categoryOrClass);
        }
        this.currentRecord.setBtn(new POSLiteCompositeFavouriteBtn(this));
        Pair<Class, String> classForeignKeyPair = this.nextLevelKlassAndForeignKey();
        this.searchInKlass = (Class)classForeignKeyPair.getX();
        this.foreignKeyFieldId = (String)classForeignKeyPair.getY();
        this.params.putAll(POSPersister.params(level.toString(), this.fetchLevel()));
        this.allParams = POSFavouriteBtnQueryUtil.calcBtnParams(this);
        this.btnQuery = POSFavouriteBtnQueryUtil.calcBtnQuery(this);
        this.btnItemsQueryForCount = POSFavouriteBtnQueryUtil.calcBtnQuery(this, POSItem.class);
        this.btnItemsQuery = POSFavouriteBtnQueryUtil.calcBtnItemsQuery(this, false);
        this.setHasNoChildren(this.hasNoChildren());
        if (screen != null) {
            this.setId("composite-favourite");
            this.setTooltip(new POSTooltip(this.currentRecord.nameByLanguage()));
            this.btnByImg(this.currentRecord);
            this.setBGColor();
            this.setOnAction(e -> Platform.runLater(() -> this.addItems(true, screen)));
        }
    }

    private POSSavable fetchLevel() {
        try {
            if (ObjectChecker.isAnyEmptyOrNull((Object[])new Object[]{this.currentRecord.getKlass(), this.currentRecord.getId()})) {
                return null;
            }
            String key = String.valueOf(this.currentRecord.getKlass()) + "&" + String.valueOf(this.currentRecord.getId());
            if (!cache.containsKey(key)) {
                cache.put(key, (POSSavable)this.currentRecord.getKlass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            POSSavable savable = cache.get(key);
            savable.setId(this.currentRecord.getId());
            return savable;
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return null;
        }
    }

    public List<POSFavouriteBtn> addItems(boolean addToBreadCrumb, AbsPosSalesScreen view) {
        List<POSFavouriteBtn> favouriteBtns = this.btnNextLevelAction(view);
        if (view != null) {
            if (this.isResetBreadCrumbWithAction()) {
                view.getFavouritesContainerBuilder().resetBreadCrumbsBar();
            }
            view.getFavouritesContainerBuilder().addFavouritesPane(favouriteBtns, this.currentRecord, true, addToBreadCrumb);
        }
        return favouriteBtns;
    }

    public List<POSFavouriteBtn> btnNextLevelAction(AbsPosSalesScreen view) {
        POSFavouriteBtnLevel nextLevel = this.nextNotEmptyLevel();
        List posMasterFiles = POSResourcesUtil.getCachedFavourites(this.calcCurrentRecordIds());
        if (ObjectChecker.isEmptyOrNull(posMasterFiles)) {
            posMasterFiles = this.nextLevelsFavouriteRecords().stream().map(m -> new POSLiteMasterFile<POSMasterFile>((POSMasterFile)m)).collect(Collectors.toList());
            POSResourcesUtil.addCachedFavourites(this.calcCurrentRecordIds(), posMasterFiles, null);
        }
        List favouriteBtns = CollectionsUtility.convert(posMasterFiles, f -> {
            if (ObjectChecker.areEqual((Object)f.getNamaEntityType(), (Object)"InvItem")) {
                return new POSNormalFavouriteBtn((POSLiteMasterFile)f, view);
            }
            return new POSCompositeFavouriteBtn(this.favouriteItem, view, nextLevel, (POSLiteMasterFile)f, this);
        });
        return favouriteBtns.stream().filter(b -> ObjectChecker.isFalseOrNull((Boolean)b.hasNoChildren())).collect(Collectors.toList());
    }

    private Pair<List<UUID>, Boolean> calcCurrentRecordIds() {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        POSCompositeFavouriteBtn current = this;
        boolean filterSellable = current.shouldFilterSellable();
        do {
            ids.add(current.currentRecord.getId());
        } while ((current = current.getParentBtn()) != null);
        return new Pair(ids, (Object)filterSellable);
    }

    @Override
    public boolean hasNoChildren() {
        Boolean cachedHasChildren = POSResourcesUtil.getCachedFavouritesWithChildren(this.calcCurrentRecordIds());
        if (cachedHasChildren != null) {
            return cachedHasChildren;
        }
        if (ObjectChecker.isTrue((Boolean)POSResourcesUtil.fetchMainRegister().getShowFavoritesWithNoNextLevels())) {
            return false;
        }
        int childrenCount = 0;
        childrenCount = this.searchInKlass != POSItem.class ? POSPersister.count(POSItem.class, this.btnItemsQueryForCount, this.allParams).intValue() : POSPersister.count(this.searchInKlass, this.btnQuery, this.allParams).intValue();
        boolean hasNoChildren = childrenCount <= 0;
        POSResourcesUtil.addCachedFavourites(this.calcCurrentRecordIds(), null, hasNoChildren);
        return hasNoChildren;
    }

    private boolean isNotLastLevel() {
        return ObjectChecker.areNotEqual((Object)((Object)this.getLevel()), (Object)((Object)POSFavouriteBtnLevel.Level5));
    }

    private POSFavouriteBtnLevel nextNotEmptyLevel() {
        return (POSFavouriteBtnLevel)((Object)CollectionsUtility.getFirst(this.allNextNotEmptyLevels()));
    }

    public List<POSFavouriteBtnLevel> allNextNotEmptyLevels() {
        List<Function> levelsFetchers = Arrays.asList(POSFavouriteLine::getFavouritesLevel2, POSFavouriteLine::getFavouritesLevel3, POSFavouriteLine::getFavouritesLevel4, POSFavouriteLine::getFavouritesLevel5);
        int iLevel = Integer.valueOf(this.level.name().substring("level".length()));
        ArrayList<POSFavouriteBtnLevel> levels = new ArrayList<POSFavouriteBtnLevel>();
        for (int cLevel = iLevel; cLevel < 5; ++cLevel) {
            String nextLevel = (String)levelsFetchers.get(cLevel - 1).apply(this.favouriteItem);
            if (!ObjectChecker.isNotEmptyOrNull((Object)nextLevel)) continue;
            levels.add(POSFavouriteBtnLevel.valueOf("Level" + (cLevel + 1)));
        }
        if (ObjectChecker.isEmptyOrNull(levels)) {
            return Arrays.asList(POSFavouriteBtnLevel.Level5);
        }
        return levels;
    }

    public Pair<Class, String> nextLevelKlassAndForeignKey() {
        POSFavouriteBtnLevel nextLevel = this.nextNotEmptyLevel();
        String levelClassType = this.findFavouriteBtnLevel(nextLevel);
        Class searchInKlass = POSItem.class;
        if (ObjectChecker.isNotEmptyOrNull((Object)levelClassType)) {
            searchInKlass = this.findFavouriteBtnSearchKlass(FavouriteItemLevel.valueOf(levelClassType));
        }
        String foreignKeyFieldId = this.findForeignKeyFieldId(searchInKlass, this.currentRecord.getNamaEntityType());
        return new Pair((Object)searchInKlass, (Object)foreignKeyFieldId);
    }

    public List<POSMasterFile> nextLevelsFavouriteRecords() {
        String orderByCol = POSResourcesUtil.isArabic() ? "name1" : "name2";
        ArrayList<POSMasterFile> directFiles = new ArrayList<POSMasterFile>();
        if (this.isNotLastLevel()) {
            directFiles.addAll(POSPersister.searchFor("from " + this.searchInKlass.getSimpleName() + this.btnQuery + " order by " + orderByCol, this.allParams));
        }
        if (this.searchInKlass != POSItem.class) {
            List<?> items = POSPersister.searchFor("from " + POSItem.class.getSimpleName() + this.btnItemsQuery + " order by " + orderByCol, this.allParams);
            directFiles.addAll(items);
        }
        return directFiles;
    }

    public String btnCriteria(Class searchInKlass) {
        String queryForeignKey = this.findForeignKeyFieldId(searchInKlass, this.currentRecord.getNamaEntityType());
        if (searchInKlass == null) {
            return queryForeignKey + " =:" + String.valueOf((Object)this.level);
        }
        if (searchInKlass == POSItem.class) {
            return queryForeignKey + " =:" + String.valueOf((Object)this.level);
        }
        return " (" + queryForeignKey + " is null or " + queryForeignKey + " =:" + String.valueOf((Object)this.level) + ")";
    }

    public String getForeignKeyFieldId() {
        return this.foreignKeyFieldId;
    }

    public Class getSearchInKlass() {
        return this.searchInKlass;
    }

    public POSCompositeFavouriteBtn getParentBtn() {
        return this.parentBtn;
    }

    public HashMap<String, Object> getParams() {
        return this.params;
    }

    public String findForeignKeyFieldId(Class searchingKlassName, String entityType) {
        if (ObjectChecker.isNotEmptyOrNull(foreignKeyFieldIds)) {
            return foreignKeyFieldIds.get(this.generateKey(searchingKlassName, entityType, this.favouriteItem, null));
        }
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemBrand", this.favouriteItem, null), "brand");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass5", this.favouriteItem, null), "itemClass5");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass6", this.favouriteItem, null), "itemClass6");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass7", this.favouriteItem, null), "itemClass7");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass8", this.favouriteItem, null), "itemClass8");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass9", this.favouriteItem, null), "itemClass9");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemClass10", this.favouriteItem, null), "itemClass10");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemCategory", this.favouriteItem, FavouriteItemLevel.category1.name()), "category1");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemCategory", this.favouriteItem, FavouriteItemLevel.category2.name()), "category2");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemCategory", this.favouriteItem, FavouriteItemLevel.category3.name()), "category3");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemCategory", this.favouriteItem, FavouriteItemLevel.category4.name()), "category4");
        foreignKeyFieldIds.put(this.generateKey(POSItem.class, "ItemCategory", this.favouriteItem, FavouriteItemLevel.category5.name()), "category5");
        foreignKeyFieldIds.put(this.generateKey(POSItemBrand.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemCategory.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass1.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass2.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass2.class, "ItemClass1", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass3.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass3.class, "ItemClass2", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass3.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass4.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass4.class, "ItemClass3", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass4.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass4.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass5.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass5.class, "ItemClass4", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass5.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass5.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass5.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemClass5", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass6.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass6", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass5", this.favouriteItem, null), "itemClass5");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass7.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass7", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass6", this.favouriteItem, null), "itemClass6");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass5", this.favouriteItem, null), "itemClass5");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass8.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass8", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass7", this.favouriteItem, null), "itemClass7");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass6", this.favouriteItem, null), "itemClass6");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass5", this.favouriteItem, null), "itemClass5");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass9.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemSection", this.favouriteItem, null), "section");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass9", this.favouriteItem, null), "parent");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass8", this.favouriteItem, null), "itemClass8");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass7", this.favouriteItem, null), "itemClass7");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass6", this.favouriteItem, null), "itemClass6");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass5", this.favouriteItem, null), "itemClass5");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass4", this.favouriteItem, null), "itemClass4");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass3", this.favouriteItem, null), "itemClass3");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass2", this.favouriteItem, null), "itemClass2");
        foreignKeyFieldIds.put(this.generateKey(POSItemClass10.class, "ItemClass1", this.favouriteItem, null), "itemClass1");
        return foreignKeyFieldIds.get(this.generateKey(searchingKlassName, entityType, this.favouriteItem, null));
    }

    private String keyLevelPartIfCategory(String relatedEntityType, String currentLevel) {
        if (ObjectChecker.areNotEqual((Object)relatedEntityType, (Object)"ItemCategory")) {
            return "";
        }
        return (String)ObjectChecker.getFirstNotNullObj((Object[])new String[]{currentLevel, this.findFavouriteBtnLevel(this.level)});
    }

    private String generateKey(Class searchInKlass, String relatedEntityType, POSFavouriteLine favouriteItem, String levelPartToAdd) {
        return searchInKlass.getSimpleName() + "_#_" + relatedEntityType + "_#_" + this.keyLevelPartIfCategory(relatedEntityType, levelPartToAdd);
    }

    public String findFavouriteBtnLevel(POSFavouriteBtnLevel level) {
        switch (level) {
            case Level2: {
                return this.favouriteItem.getFavouritesLevel2();
            }
            case Level3: {
                return this.favouriteItem.getFavouritesLevel3();
            }
            case Level4: {
                return this.favouriteItem.getFavouritesLevel4();
            }
            case Level5: {
                return this.favouriteItem.getFavouritesLevel5();
            }
        }
        return null;
    }

    public Class findFavouriteBtnSearchKlass(FavouriteItemLevel levelClassType) {
        switch (levelClassType) {
            case category1: 
            case category2: 
            case category3: 
            case category4: 
            case category5: {
                return POSItemCategory.class;
            }
            case ItemBrand: {
                return POSItemBrand.class;
            }
            case ItemClass1: {
                return POSItemClass1.class;
            }
            case ItemClass2: {
                return POSItemClass2.class;
            }
            case ItemClass3: {
                return POSItemClass3.class;
            }
            case ItemClass4: {
                return POSItemClass4.class;
            }
            case ItemClass5: {
                return POSItemClass5.class;
            }
            case ItemClass6: {
                return POSItemClass6.class;
            }
            case ItemClass7: {
                return POSItemClass7.class;
            }
            case ItemClass8: {
                return POSItemClass8.class;
            }
            case ItemClass9: {
                return POSItemClass9.class;
            }
            case ItemClass10: {
                return POSItemClass10.class;
            }
        }
        return POSItem.class;
    }

    public boolean shouldFilterSellable() {
        return this.shouldFilterSellable;
    }

    public String getBtnQuery() {
        return this.btnQuery;
    }

    public String getBtnItemsQuery() {
        return this.btnItemsQuery;
    }

    public String getBtnItemsQueryForCount() {
        return this.btnItemsQueryForCount;
    }

    public POSFavouriteLine getFavouriteItem() {
        return this.favouriteItem;
    }

    public HashMap<String, Object> getAllParams() {
        return this.allParams;
    }

    public static HashMap<String, String> getForeignKeyFieldIds() {
        return foreignKeyFieldIds;
    }
}

