/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.ObjectCreator;
import com.namasoft.namacontrols.POSCompositeFavouriteBtn;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.POSItem;
import com.namasoft.pos.domain.valueobjects.FavouriteItemLevel;
import com.namasoft.pos.domain.valueobjects.POSFavouriteBtnLevel;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import java.util.HashMap;
import java.util.List;

public class POSFavouriteBtnQueryUtil {
    public static HashMap<String, Object> calcBtnParams(POSCompositeFavouriteBtn btn) {
        HashMap<String, Object> params = btn.getParams();
        POSCompositeFavouriteBtn parentBtn = btn.getParentBtn();
        if (ObjectChecker.isEmptyOrNull((Object)parentBtn)) {
            return params;
        }
        params.putAll(POSFavouriteBtnQueryUtil.calcBtnParams(parentBtn));
        return params;
    }

    public static String calcBtnQuery(POSCompositeFavouriteBtn btn) {
        return POSFavouriteBtnQueryUtil.calcBtnQuery(btn, btn.getSearchInKlass());
    }

    public static String calcBtnQuery(POSCompositeFavouriteBtn btn, Class searchInKlass) {
        Object btnQuery = " where 1=1 and ";
        btnQuery = (String)btnQuery + POSFavouriteBtnQueryUtil.btnFullPathQuery(btn, searchInKlass);
        if (ObjectChecker.areEqual((Object)searchInKlass, POSItem.class) && btn.shouldFilterSellable()) {
            btnQuery = (String)btnQuery + " and (sellable = true or sellable is null) ";
        }
        return btnQuery;
    }

    public static String calcBtnItemsQuery(POSCompositeFavouriteBtn btn, boolean forCountOfItems) {
        Object btnQuery = " where 1=1 and ";
        btnQuery = (String)btnQuery + POSFavouriteBtnQueryUtil.btnFullPathQuery(btn, POSItem.class);
        if (btn.shouldFilterSellable()) {
            btnQuery = (String)btnQuery + " and (sellable = true or sellable is null) ";
        }
        if (!forCountOfItems) {
            List<POSFavouriteBtnLevel> levels = btn.allNextNotEmptyLevels();
            for (int i = 0; i < levels.size(); ++i) {
                String levelClassType = btn.findFavouriteBtnLevel(levels.get(i));
                if (ObjectChecker.isEmptyOrNull((Object)levelClassType)) continue;
                Class searchInKlass = btn.findFavouriteBtnSearchKlass(FavouriteItemLevel.valueOf(levelClassType));
                ObjectCreator creator = ObjectCreatorUtil.creator((Class)searchInKlass);
                String foreignKeyFieldId = btn.findForeignKeyFieldId(POSItem.class, ((POSMasterFile)creator.create()).calcNamaEntityType());
                btnQuery = (String)btnQuery + " and " + foreignKeyFieldId + " is null ";
            }
        }
        return btnQuery;
    }

    private static String btnFullPathQuery(POSCompositeFavouriteBtn btn, Class searchInKlass) {
        POSCompositeFavouriteBtn parentBtn = btn.getParentBtn();
        if (ObjectChecker.isEmptyOrNull((Object)parentBtn)) {
            return btn.btnCriteria(searchInKlass);
        }
        return btn.btnCriteria(searchInKlass) + " and " + POSFavouriteBtnQueryUtil.btnFullPathQuery(parentBtn, searchInKlass);
    }
}

