/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.namacontrols.POSHallsTablesButton;
import com.namasoft.namacontrols.POSHallsTablesViewer;
import com.namasoft.namacontrols.POSTableButton;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.util.POSImgUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TreeItem;
import javafx.scene.image.ImageView;

public class POSHallButton
extends POSHallsTablesButton {
    private POSHall hall;

    public POSHallButton(String text) {
        super(text);
    }

    public POSHallButton(POSHall hall, POSHallsTablesViewer viewer) {
        super(hall);
        this.hall = hall;
        this.setOnAction(event -> {
            if (viewer == null) {
                return;
            }
            TreeItem newItem = new TreeItem((Object)this);
            viewer.getBreadCrumbRootItem().getChildren().add((Object)newItem);
            viewer.getBreadCrumbBar().setSelectedCrumb(newItem);
            List<POSHallsTablesButton> nextButtons = POSHallButton.fetchHallTables(hall, viewer);
            viewer.addButtonsToGrid(nextButtons);
        });
    }

    @Override
    protected ImageView fetchButtonImage() {
        return POSImgUtil.createSVGImageView("hall-image.svg");
    }

    public static List<POSTableButton> fetchHallTables(POSHall hall, POSHallsTablesViewer viewer) {
        ArrayList<POSTableButton> nextButtons = new ArrayList<POSTableButton>();
        List<?> list = POSPersister.listAll(POSTable.class, " where posHall = :hall", POSPersister.params("hall", hall), "code");
        list.stream().forEach(l -> nextButtons.add(new POSTableButton((POSTable)l, viewer)));
        return nextButtons;
    }

    public POSHall getHall() {
        return this.hall;
    }
}

