/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.POSHallButton;
import com.namasoft.namacontrols.POSHallsTablesButton;
import com.namasoft.namacontrols.POSTableButton;
import com.namasoft.pos.application.MultiTableDialog;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.details.PosTableLine;
import com.namasoft.pos.domain.entities.POSHall;
import com.namasoft.pos.domain.entities.POSTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TreeItem;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import org.controlsfx.control.BreadCrumbBar;

public class POSHallsTablesViewer<T extends POSHallsTablesButton>
extends NamaDialog<ButtonType> {
    private GridPane root;
    private GridPane container;
    private BreadCrumbBar<T> breadCrumbBar;
    private TreeItem<T> breadCrumbRootItem;
    private NamaSearchBox searchBox;
    private int btnsCountInRow = 5;
    private List<PosTableLine> tableLines = new ArrayList<PosTableLine>();

    public POSHallsTablesViewer(NamaSearchBox box) {
        super("tables");
        if (box.getRelatedTableDialog() != null) {
            this.tableLines = new ArrayList<PosTableLine>((Collection<PosTableLine>)box.getRelatedTableDialog().getTable().getItems());
        }
        this.searchBox = box;
        this.root = new GridPane();
        this.root.setId("halls-tables-viewer-root");
        this.container = new GridPane();
        this.container.setId("halls-tables-viewer-container");
        GridPane.setHgrow((Node)this.container, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.container, (Priority)Priority.ALWAYS);
        this.breadCrumbBar = new BreadCrumbBar();
        this.breadCrumbBar.setId("menu-breadCrumb-bar");
        POSHallButton mainBtn = new POSHallButton("main");
        this.breadCrumbRootItem = new TreeItem((Object)mainBtn);
        this.breadCrumbBar.setSelectedCrumb(this.breadCrumbRootItem);
        this.breadCrumbBar.setCrumbFactory(param -> new BreadCrumbBar.BreadCrumbButton(POSResourcesUtil.id(((POSHallsTablesButton)param.getValue()).getTextId(), new Object[0])));
        this.breadCrumbBar.setOnCrumbAction(bae -> {
            POSHallsTablesButton value = (POSHallsTablesButton)bae.getSelectedCrumb().getValue();
            if (value.getTextId().equalsIgnoreCase("main")) {
                this.setMainView();
            }
        });
    }

    public NamaSearchBox getSearchBox() {
        return this.searchBox;
    }

    public BreadCrumbBar<T> getBreadCrumbBar() {
        return this.breadCrumbBar;
    }

    public TreeItem<T> getBreadCrumbRootItem() {
        return this.breadCrumbRootItem;
    }

    private void setMainView() {
        List<POSHall> halls = POSResourcesUtil.halls;
        List<POSTable> tables = POSResourcesUtil.tables;
        ArrayList<POSHallsTablesButton> buttons = new ArrayList<POSHallsTablesButton>();
        halls.stream().forEach(h -> buttons.add(new POSHallButton((POSHall)h, this)));
        tables.stream().forEach(t -> buttons.add(new POSTableButton((POSTable)t, this)));
        this.addButtonsToGrid(buttons);
    }

    public void addButtonsToGrid(List<POSHallsTablesButton> buttons) {
        this.container.getChildren().clear();
        int row = 0;
        int col = 0;
        for (int i = 0; i < buttons.size(); ++i) {
            this.container.add((Node)buttons.get(i), col, row);
            if (++col != this.btnsCountInRow) continue;
            ++row;
            col = 0;
        }
    }

    public void view() {
        this.setMainView();
        this.root.add(this.breadCrumbBar, 0, 0);
        this.root.add((Node)this.container, 0, 1);
        NamaHBox.setHgrow((Node)this.root, (Priority)Priority.ALWAYS);
        NamaVBox.setVgrow((Node)this.root, (Priority)Priority.ALWAYS);
        this.root.setPrefWidth(this.searchBox.getScreen().fetchStage().getWidth() / 1.8);
        this.root.setPrefHeight(this.searchBox.getScreen().fetchStage().getHeight() / 3.0);
        this.setResizable(true);
        this.content((Node)new NamaHBox(new Node[]{this.root}));
        this.addOkButton("");
        this.addCancelButton("");
        this.addScrollPane();
        this.getDialogPane().setOnKeyPressed(l -> {
            if (ObjectChecker.areEqual((Object)l.getCode(), (Object)KeyCode.ENTER)) {
                this.handleApply();
                this.close();
            }
        });
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.handleApply();
        }
    }

    private void handleApply() {
        this.searchBox.getRelatedTableDialog().getTable().getItems().clear();
        this.searchBox.getRelatedTableDialog().getTable().getItems().addAll(this.tableLines);
    }

    public List<PosTableLine> getTableLines() {
        return this.tableLines;
    }

    public void addOrRemoveTable(POSTable table, boolean selected) {
        if (selected) {
            if (this.getTableLines().stream().noneMatch(l -> ObjectChecker.areEqual((Object)table.getId(), (Object)l.getTableID()))) {
                this.getTableLines().add(MultiTableDialog.createPosTableLine(table));
            }
        } else {
            this.getTableLines().removeIf(l -> ObjectChecker.areEqual((Object)table.getId(), (Object)l.getTableID()));
        }
    }
}

