/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.POSFavouriteBtn;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.POSUISettingsUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSLiteMasterFile;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;

public class POSNormalFavouriteBtn
extends POSFavouriteBtn {
    public POSNormalFavouriteBtn(POSLiteMasterFile item, AbsPosSalesScreen screen) {
        super(item);
        this.setPrefHeight(POSUISettingsUtil.getPosUISettingsOptions().fetchFavouriteItemBtnHeight());
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        if (screen == null) {
            return;
        }
        this.widthProperty().addListener((obs, oldVal, newVal) -> {
            double fontSize = newVal.doubleValue() / (double)this.getText().length();
            if (fontSize > 20.0) {
                fontSize = 20.0;
            }
            if (fontSize < 14.0) {
                fontSize = 14.0;
            }
            this.setStyle("-fx-font-size: " + fontSize + "px;");
        });
        this.btnByImg(item);
        this.setTooltip(new POSTooltip(item.nameByLanguage()));
        this.setBGColor();
        this.setOnAction(e -> {
            AbsPOSSales salesDoc = screen.getSalesDoc();
            BigDecimal qty = new BigDecimal((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{screen.getFavouritesContainerBuilder().getQty().getText(), "1"}));
            POSResult result = new POSResult();
            salesDoc.addSalesLine(POSResourcesUtil.fetchMainRegister(), item.getCode(), salesDoc.fetchDetails().size(), qty, true, screen, result);
            if (result.isFailed().booleanValue()) {
                POSErrorAndInfoMessagesUtil.showError(result, screen.fetchStage());
            }
            screen.getFavouritesContainerBuilder().getQty().clear();
        });
    }
}

