/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.common.DTOPOSConfiguration;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaVBox;
import com.namasoft.namacontrols.PosAppFilesInfoDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.entities.POSSettingsInfo;
import com.namasoft.pos.util.POSScreenSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.apache.commons.io.IOUtils;

public class POSSettingsUtil {
    public static void updateScreenColor(Parent parent, POSDocumentType type) {
        DTOPOSConfiguration posConfig = POSResourcesUtil.fetchPOSConfig();
        if (ObjectChecker.areEqual((Object)((Object)type), (Object)((Object)POSDocumentType.Invoice))) {
            parent.setStyle("-fx-screen-color: " + (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posConfig.getMainColor(), "#05A7BE"}));
        } else if (ObjectChecker.areEqual((Object)((Object)type), (Object)((Object)POSDocumentType.Return))) {
            parent.setStyle("-fx-screen-color: " + (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posConfig.getSalesReturnColor(), "#B31312"}));
        } else if (ObjectChecker.areEqual((Object)((Object)type), (Object)((Object)POSDocumentType.Replacement))) {
            parent.setStyle("-fx-screen-color: " + (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posConfig.getSalesReplacementColor(), "#FF9500"}));
        }
        parent.setStyle(parent.getStyle() + "; -fx-main-color: " + (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{posConfig.getMainColor(), "#05A7BE"}));
    }

    public static void setFonts(Font newfont, Node ... fields) {
        POSSettingsUtil.updateFonts(newfont, fields);
    }

    private static void updateFonts(Font newfont, Node ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] instanceof Labeled) {
                ((Labeled)fields[i]).setFont(newfont);
            }
            if (fields[i] instanceof TextField) {
                ((TextField)fields[i]).setFont(newfont);
            }
            if (fields[i] instanceof TextArea) {
                ((TextArea)fields[i]).setFont(newfont);
                continue;
            }
            if (!(fields[i] instanceof Text)) continue;
            ((Text)fields[i]).setFont(newfont);
        }
    }

    public static void setFonts(double size, Node ... fields) {
        POSSettingsUtil.setFonts(size, fields[0].getClass().getClassLoader(), fields);
    }

    public static void setFonts(double size, ClassLoader loader, Node ... fields) {
        String font = "";
        if (ObjectChecker.isNotEmptyOrNull((Object)POSPersister.getFactory())) {
            font = POSSettingsInfo.fetchConfiguration().getFontName();
        }
        Font newfont = null;
        FileInputStream fontAsStream = null;
        if (ObjectChecker.isNotEmptyOrNull((Object)font) && ObjectChecker.areNotEqual((Object)font, (Object)"default")) {
            try {
                File fontFile = new File("Fonts/" + font);
                fontAsStream = new FileInputStream(fontFile);
                if (fontAsStream != null) {
                    newfont = Font.loadFont((InputStream)fontAsStream, (double)size);
                }
                if (ObjectChecker.isEmptyOrNull((Object)newfont) && ObjectChecker.isNotEmptyOrNull((Object)loader.getResource(font))) {
                    newfont = Font.loadFont((String)loader.getResource(font).toExternalForm(), (double)size);
                }
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        }
        if (ObjectChecker.isEmptyOrNull(newfont)) {
            newfont = new Font("ReadexPro", size);
        }
        POSSettingsUtil.updateFonts(newfont, fields);
    }

    public static void downloadAppLogs() {
        try {
            boolean downloadLogFiles = NamaConfirmationDialog.showDialogAndWait("Do you want to download and zip all pos log files?", null, (Event)new ActionEvent());
            if (!downloadLogFiles) {
                return;
            }
            ProgressBar progressBar = new ProgressBar();
            progressBar.setProgress(0.0);
            StackPane progressOverlay = new StackPane();
            progressOverlay.getChildren().add((Object)progressBar);
            progressOverlay.setStyle("-fx-background-color: rgba(0, 0, 0, 0.5);");
            progressOverlay.setPrefSize(-1.0, -1.0);
            Path appFolder = Paths.get("", new String[0]).toAbsolutePath();
            Path zipFilePath = appFolder.resolve("POS.Logs" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".zip");
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFilePath.toFile()));){
                ArrayList<String> logFilesNames = new ArrayList<String>(Arrays.asList("gui", "hibernate", "nama-services", "namapos", "other", "performance", "reportPerformance", "replication", "root", "service", "spy", "mail"));
                for (int i = 0; i < logFilesNames.size(); ++i) {
                    String fileName = (String)logFilesNames.get(i);
                    File logFile = new File(fileName + ".log");
                    if (!logFile.exists()) continue;
                    zos.putNextEntry(new ZipEntry(fileName + ".log"));
                    try (FileInputStream inputStream = new FileInputStream(fileName + ".log");){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)zos);
                    }
                    progressBar.setProgress((double)(i + 1) * 100.0 / (double)logFilesNames.size());
                }
                zos.flush();
                zos.close();
                progressBar.setProgress(100.0);
                new PosAppFilesInfoDialog().showDialogAndWait("Application logs zip file created at: ", zipFilePath.toAbsolutePath().toString());
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    public static void addStyleSheetFor(String styleSheetName, Parent parent) {
        if (parent == null) {
            return;
        }
        URL resource = parent.getClass().getClassLoader().getResource(styleSheetName);
        if (resource == null) {
            return;
        }
        parent.getStylesheets().add((Object)resource.toExternalForm());
        if (ObjectChecker.isTrue((String)POSScreenSettings.getProperty("compactMode"))) {
            POSSettingsUtil.applyCompactMode(styleSheetName, parent);
        }
        if (ObjectChecker.isTrue((String)POSScreenSettings.getProperty("colorfulMode"))) {
            POSSettingsUtil.applyColorFulMode(styleSheetName, parent);
        }
        if (ObjectChecker.isTrue((String)POSScreenSettings.getProperty("darkMode"))) {
            POSSettingsUtil.applyDarkMode();
        }
    }

    private static void applyCompactMode(String styleSheetName, Parent parent) {
        String compactName = styleSheetName.split("/")[1];
        URL compactResource = parent.getClass().getClassLoader().getResource("css/compact/" + compactName);
        if (compactResource == null) {
            return;
        }
        parent.getStylesheets().add((Object)compactResource.toExternalForm());
    }

    private static void applyColorFulMode(String styleSheetName, Parent parent) {
        String compactName = styleSheetName.split("/")[1];
        URL compactResource = parent.getClass().getClassLoader().getResource("css/colorful/" + compactName);
        if (compactResource == null) {
            return;
        }
        parent.getStylesheets().add((Object)compactResource.toExternalForm());
    }

    private static void applyDarkMode() {
    }

    public static void setHGrowAlways(List<Node> nodes) {
        for (Node node : nodes) {
            if (node instanceof Pane) {
                Pane pane = (Pane)node;
                POSSettingsUtil.setHGrowAlways((List<Node>)pane.getChildren());
            }
            node.maxWidth(Double.MAX_VALUE);
            GridPane.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            NamaHBox.setHgrow((Node)node, (Priority)Priority.ALWAYS);
            if (!(node instanceof NamaSearchBox)) continue;
            node.setStyle("-fx-max-width: infinity");
        }
    }

    public static void setVGrowAlways(List<Node> nodes) {
        for (Node node : nodes) {
            if (node instanceof Pane) {
                Pane pane = (Pane)node;
                POSSettingsUtil.setVGrowAlways((List<Node>)pane.getChildren());
            }
            if (!(node instanceof Region)) continue;
            node.maxHeight(Double.MAX_VALUE);
            GridPane.setVgrow((Node)node, (Priority)Priority.ALWAYS);
            NamaVBox.setVgrow((Node)node, (Priority)Priority.ALWAYS);
        }
    }
}

