/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.TableUtils;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class PosCopyMenu
extends ContextMenu {
    private Control control;

    public PosCopyMenu(Control control) {
        this.control = control;
    }

    public void bind() {
        MenuItem menuItem = new MenuItem(POSResourcesUtil.id("copy", new Object[0]));
        this.getItems().add((Object)menuItem);
        this.control.addEventHandler(MouseEvent.MOUSE_CLICKED, t -> {
            if (t.getButton() == MouseButton.SECONDARY) {
                boolean showCopy = true;
                if (this.control instanceof Labeled) {
                    showCopy = ObjectChecker.isNotEmptyOrNull((Object)((Labeled)this.control).getText());
                } else if (this.control instanceof TableView) {
                    TablePosition editingCell = ((TableView)this.control).getFocusModel().getFocusedCell();
                    ObservableValue cellObservableValue = ((TableColumn)((TableView)this.control).getVisibleLeafColumns().get(editingCell.getColumn())).getCellObservableValue(editingCell.getRow());
                    boolean bl = showCopy = ObjectChecker.isNotEmptyOrNull((Object)cellObservableValue) && ObjectChecker.isNotEmptyOrNull((Object)ObjectChecker.toStringOrEmpty((Object)cellObservableValue.getValue()));
                }
                if (showCopy) {
                    this.show((Node)this.control, t.getScreenX(), t.getScreenY());
                }
            }
        });
        menuItem.setOnAction(action -> {
            if (this.control instanceof TableView) {
                TableUtils.copyTableSelectionToClipboard((TableView)this.control);
            } else {
                TableUtils.copyTextSelectionToClipboard((TextInputControl)this.control);
            }
        });
    }
}

