/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaTextField;
import com.namasoft.pos.application.POSFieldType;
import com.namasoft.pos.application.POSSavable;
import java.util.Collection;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;

public class PosTableFilterField<T extends POSSavable>
extends NamaTextField {
    private TableView relatedTable;
    private boolean matched = false;
    private ObservableList originTableItems;
    private boolean firstFilter = true;

    public PosTableFilterField(TableView table) {
        super(POSFieldType.Text);
        this.setRelatedTable(table);
        this.textProperty().addListener((observable, oldValue, newValue) -> this.filtering(table));
        this.setOnKeyPressed(e -> {
            if (ObjectChecker.areNotEqual((Object)e.getCode(), (Object)KeyCode.ENTER)) {
                return;
            }
            this.filtering(table);
        });
    }

    private void filtering(TableView table) {
        String newValue = this.getText();
        if (this.firstFilter) {
            this.originTableItems = table.getItems();
        }
        FilteredList filteredData = new FilteredList(this.originTableItems, b -> true);
        this.firstFilter = newValue == null || newValue.isEmpty();
        filteredData.setPredicate(obj -> {
            this.matched = false;
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            List<Object> valuesToFilterIn = obj.filterFieldsInTableView();
            valuesToFilterIn.stream().forEach(val -> {
                if (val.toString().toLowerCase().indexOf(lowerCaseFilter) != -1) {
                    this.matched = true;
                }
            });
            return this.matched;
        });
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)table.comparatorProperty());
        table.setItems(FXCollections.observableArrayList((Collection)sortedData));
    }

    public TableView getRelatedTable() {
        return this.relatedTable;
    }

    public void setRelatedTable(TableView relatedTable) {
        this.relatedTable = relatedTable;
    }

    public void updateOriginalTableItems() {
        this.originTableItems = this.relatedTable.getItems();
    }

    public List getOriginTableItems() {
        return this.originTableItems;
    }
}

