/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaConfirmationDialog;
import com.namasoft.namacontrols.NamaPOSSearchDialog;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.controllers.NamaJSON;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.entities.PosTempDocument;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.event.ActionEvent;
import javafx.event.Event;

public class PosTempDocumentUtil {
    private static ExecutorService TempDoc_Executor = Executors.newSingleThreadExecutor();
    private static HashMap<String, POSDocumentType> typeFromNaMaType = new HashMap();

    public static void saveOrUpdateTempDocIfNeeded(AbsPOSSales salesDoc) {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getTempAutoSaveCurrentDoc())) {
            return;
        }
        TempDoc_Executor.submit(() -> {
            try {
                PosTempDocument tempDocument = PosTempDocumentUtil.fetchTempDoc(salesDoc);
                if (tempDocument == null) {
                    tempDocument = new PosTempDocument();
                }
                tempDocument.setDocKlass(salesDoc.getClass());
                tempDocument.setId(salesDoc.getId());
                tempDocument.setEntityType(salesDoc.calcNamaEntityType());
                tempDocument.setDocDate(salesDoc.fetchDate());
                tempDocument.setNetValue(salesDoc.getNetPrice());
                tempDocument.setDocJson(NamaJSON.toString(salesDoc));
                POSPersister.saveOrUpdate(tempDocument);
            }
            catch (Exception e) {
                NaMaLogger.error((Throwable)e);
            }
        });
    }

    public static void deleteAllTempDocs() {
        boolean deleteAllDocs = NamaConfirmationDialog.showDialogAndWait("Do you want to delete all temp docs?", null, (Event)new ActionEvent());
        if (!deleteAllDocs) {
            return;
        }
        TempDoc_Executor.submit(() -> POSPersister.deleteAll(POSPersister.listAll(PosTempDocument.class)));
    }

    public static void deleteTempDocIfNeeded(AbsPOSSales salesDoc) {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getTempAutoSaveCurrentDoc())) {
            return;
        }
        TempDoc_Executor.submit(() -> {
            PosTempDocument doc = PosTempDocumentUtil.fetchTempDoc(salesDoc);
            if (ObjectChecker.isEmptyOrNull((Object)doc)) {
                return;
            }
            POSPersister.delete(doc);
        });
    }

    private static PosTempDocument fetchTempDoc(AbsPOSSales salesDoc) {
        return POSPersister.findByID(PosTempDocument.class, salesDoc.getId());
    }

    public static Number countCurrentTempDocs() {
        if (ObjectChecker.isFalseOrNull((Boolean)POSResourcesUtil.fetchPOSConfig().getTempAutoSaveCurrentDoc())) {
            return 0;
        }
        return POSPersister.count(PosTempDocument.class, "", POSPersister.params(new Object[0]));
    }

    public static <T extends AbsPOSSales> void showTempDocsSelectDialogIfNeeded(boolean showConfirmDialog, IHasToolBar screen) {
        boolean selectUnCompletedDoc = true;
        if (showConfirmDialog) {
            selectUnCompletedDoc = NamaConfirmationDialog.showDialogAndWait("There are uncompleted docs, do you want to select one?", null, (Event)new ActionEvent());
        }
        if (!selectUnCompletedDoc) {
            return;
        }
        NamaSearchBox searchBox = new NamaSearchBox(PosTempDocument.class, screen, "", screen.fetchStage());
        searchBox.setAfterSelectionFunc(o -> {
            try {
                PosTempDocument doc = (PosTempDocument)o;
                String naMaEntityType = doc.getEntityType();
                AbsPOSSales salesDoc = (AbsPOSSales)NamaJSON.read(doc.getDocJson(), doc.getDocKlass());
                salesDoc.fetchDetails().forEach(l -> l.updateInvoice(salesDoc));
                salesDoc.fetchRemovedLines().forEach(l -> l.updateInvoice(salesDoc));
                POSDocumentType docType = PosTempDocumentUtil.typeFromNaMaType(naMaEntityType);
                AbsPosSalesScreen salesScreen = (AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(docType);
                salesScreen.draw(screen.fetchStage(), docType);
                salesScreen.openInvoice(salesDoc, false, true, (Event)new ActionEvent());
            }
            catch (Exception ex) {
                NaMaLogger.error((Throwable)ex);
            }
            return null;
        });
        NamaPOSSearchDialog searchDialog = new NamaPOSSearchDialog();
        searchDialog.showDialog(new ActionEvent(), searchBox);
    }

    private static POSDocumentType typeFromNaMaType(String naMaType) {
        if (ObjectChecker.isNotEmptyOrNull(typeFromNaMaType)) {
            return typeFromNaMaType.get(naMaType);
        }
        typeFromNaMaType.put("NamaPOSSalesInvoice", POSDocumentType.Invoice);
        typeFromNaMaType.put("NamaPOSSalesReturn", POSDocumentType.Return);
        typeFromNaMaType.put("NamaPOSSalesReplacement", POSDocumentType.Replacement);
        typeFromNaMaType.put("NamaPOSStockReceipt", POSDocumentType.Receipt);
        typeFromNaMaType.put("NamaPOSStockTakingDetails", POSDocumentType.StockTakingDetails);
        typeFromNaMaType.put("NamaPOSCancelReservation", POSDocumentType.POSCancelReservation);
        typeFromNaMaType.put("NamaPOSOrderReservation", POSDocumentType.POSOrderReservation);
        typeFromNaMaType.put("NamaPOSScrapDoc", POSDocumentType.ScrapDoc);
        typeFromNaMaType.put("NamaPOSStockTransferReq", POSDocumentType.StockTransferReq);
        return typeFromNaMaType.get(naMaType);
    }
}

