/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols.tablecells;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSSavable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;

public class NamaPOSDatePickerCell<S, T>
extends TableCell<S, Date> {
    private DatePicker datePicker;
    private String fieldId;
    private String colId;

    public NamaPOSDatePickerCell(String fieldId, String colId) {
        this.fieldId = fieldId;
        this.colId = colId;
        if (this.datePicker == null) {
            this.createDatePicker();
        }
        this.setGraphic((Node)this.datePicker);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    public void updateItem(Date item, boolean empty) {
        boolean invalidIndex;
        if (null == this.datePicker) {
            NaMaLogger.error((Object)"Date picker is null for pos stock taking table view");
        }
        super.updateItem((Object)item, empty);
        boolean bl = invalidIndex = this.getIndex() >= this.getTableView().getItems().size() || this.getIndex() < 0;
        if (invalidIndex || ObjectChecker.isEmptyOrNull((Object)this.getTableView().getItems().get(this.getIndex()))) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            SimpleDateFormat smp = new SimpleDateFormat("dd/MM/yyyy");
            if (this.isEditing()) {
                this.setContentDisplay(ContentDisplay.TEXT_ONLY);
            } else {
                if (item != null) {
                    this.setDatePikerDate(smp.format(item));
                    this.setText(smp.format(item));
                    POSSavable tableLine = (POSSavable)this.getTableRow().getItem();
                    if (tableLine != null && tableLine.mustBeDisable(this.colId).booleanValue()) {
                        this.datePicker.setDisable(true);
                    }
                }
                this.setGraphic((Node)this.datePicker);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }
        }
    }

    private void setDatePikerDate(String dateAsStr) {
        int dayOfMonth = 0;
        int month = 0;
        int year = 0;
        try {
            dayOfMonth = Integer.parseInt(dateAsStr.substring(0, 2));
            month = Integer.parseInt(dateAsStr.substring(3, 5));
            year = Integer.parseInt(dateAsStr.substring(6, dateAsStr.length()));
        }
        catch (NumberFormatException e) {
            NaMaLogger.error((Throwable)e);
        }
        this.datePicker.setValue((Object)LocalDate.of(year, month, dayOfMonth));
    }

    private void createDatePicker() {
        this.datePicker = new DatePicker();
        this.datePicker.setPromptText("dd/mm/yyyy");
        this.datePicker.setEditable(true);
        this.datePicker.setOnAction(t -> {
            LocalDate date = (LocalDate)this.datePicker.getValue();
            SimpleDateFormat smp = new SimpleDateFormat("dd/MM/yyyy");
            Calendar cal = Calendar.getInstance();
            cal.set(5, date.getDayOfMonth());
            cal.set(2, date.getMonthValue() - 1);
            cal.set(1, date.getYear());
            this.setText(smp.format(cal.getTime()));
            this.commitEdit(cal.getTime());
        });
        this.setAlignment(Pos.CENTER);
    }

    public void commitEdit(Date newValue) {
        TableView table = this.getTableView();
        int index = this.getIndex();
        Object line = table.getItems().get(index);
        String capitalizedFieldId = this.fieldId.substring(0, 1).toUpperCase() + this.fieldId.substring(1);
        String methodName = "set" + capitalizedFieldId;
        try {
            Method method = line.getClass().getMethod(methodName, Date.class);
            method.invoke(line, newValue);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        this.updateItem(newValue, false);
        if (table != null) {
            table.edit(-1, null);
        }
    }

    public void startEdit() {
        super.startEdit();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void clearCalender() {
        this.datePicker.getEditor().clear();
    }
}

