/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.namacontrols.tablecells;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.POSSettingsUtil;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.util.POSScreenSettings;
import java.lang.reflect.Field;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class NamaTextFieldTableCell<S, T>
extends TextFieldTableCell<S, T> {
    private static final Field textFieldField;

    public NamaTextFieldTableCell(StringConverter<T> converter) {
        super(converter);
        POSSettingsUtil.setFonts(POSScreenSettings.getTableCellsFont(), ((Object)((Object)this)).getClass().getClassLoader(), new Node[]{this});
        this.setOnMousePressed(event -> {
            TablePosition focusedCell = this.getTableView().getFocusModel().getFocusedCell();
            this.getTableView().edit(focusedCell.getRow(), focusedCell.getTableColumn());
        });
    }

    public void startEdit() {
        super.startEdit();
        if (ObjectChecker.isEmptyOrNull((Object)this.getTextField())) {
            return;
        }
        Platform.runLater(() -> {
            this.getTextField().requestFocus();
            this.getTextField().selectAll();
        });
    }

    public void commitEdit(T newValue) {
        super.commitEdit(newValue);
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (!(this.getTableRow().getItem() instanceof POSSavable)) {
            return;
        }
        POSSavable tableLine = (POSSavable)this.getTableRow().getItem();
        if (tableLine != null) {
            this.setDisable(tableLine.mustBeDisable(this.getTableColumn().getId()));
        }
    }

    public void cancelEdit() {
        TextField textField = this.getTextField();
        if (textField != null) {
            this.commitEdit(this.getConverter().fromString(textField.getText()));
        } else {
            super.cancelEdit();
        }
    }

    private TextField getTextField() {
        TextField textField = null;
        try {
            textField = (TextField)textFieldField.get((Object)this);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return textField;
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new NamaTextFieldTableCell(converter);
    }

    static {
        try {
            textFieldField = TextFieldTableCell.class.getDeclaredField("textField");
            textFieldField.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

