/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.Migrator.POSMigrator;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSPaymentLine;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.POSPaymentMethod;
import com.namasoft.pos.domain.POSPaymentToRegistery;
import com.namasoft.pos.domain.POSReceiptFromRegistery;
import com.namasoft.pos.domain.details.POSShiftOpenLine;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import com.namasoft.pos.domain.valueobjects.POSFinancialSysLine;
import com.namasoft.pos.util.POSFinancialUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

public class POSFinancialSysLinesMigrator
extends POSMigrator {
    @Override
    protected void doMigrate() {
        POSPersister.execute("delete from POSFinancialSysLine");
        POSResourcesUtil.fetchMainRegister().cacheRegisteryFields();
        UUID cashMethodId = MultiplePaymentDialog.cashMethodID();
        for (POSCurrency currency : POSResourcesUtil.currencies) {
            for (POSPaymentMethod pOSPaymentMethod : POSResourcesUtil.methods) {
                POSFinancialSysLine pOSFinancialSysLine = new POSFinancialSysLine();
                pOSFinancialSysLine.setPaymentMethodId(pOSPaymentMethod.getId());
                pOSFinancialSysLine.setCurrency(currency);
                pOSFinancialSysLine.setCash(ObjectChecker.areEqual((Object)pOSPaymentMethod.getId(), (Object)cashMethodId));
                pOSFinancialSysLine.setDebit(false);
                pOSFinancialSysLine.setValue(BigDecimal.ZERO);
                pOSFinancialSysLine.assignIds();
                POSPersister.saveOrUpdate(pOSFinancialSysLine);
            }
        }
        POSShiftClose lastShiftClose = POSResourcesUtil.fetchLastCloseShift();
        if (lastShiftClose != null) {
            List<? extends AbsPOSInventoryLine> lines = lastShiftClose.fetchDetails();
            for (AbsPOSInventoryLine absPOSInventoryLine : lines) {
                if (absPOSInventoryLine.isCash().booleanValue() || absPOSInventoryLine.isDebit().booleanValue() || !ObjectChecker.isNotEmptyOrNull((Object)absPOSInventoryLine.getPaymentMethodId())) continue;
                if (ObjectChecker.isEmptyOrZero((BigDecimal)absPOSInventoryLine.getActualRemaining())) {
                    absPOSInventoryLine.setActualRemaining(absPOSInventoryLine.getAccountantRemaining());
                }
                POSFinancialUtil.addFinancialSysLine(absPOSInventoryLine);
            }
        }
        List<POSSalesInvoice> salesInvoices = POSPersister.listAll(POSSalesInvoice.class);
        for (POSSalesInvoice pOSSalesInvoice : salesInvoices) {
            this.removeIncorrectMehodIds(pOSSalesInvoice);
            this.removeDebitLineFromPayments(pOSSalesInvoice);
            this.updateCashFieldInPaymentLines(pOSSalesInvoice);
            POSPersister.saveOrUpdate(pOSSalesInvoice);
        }
        List<POSSalesReturn> returns = POSPersister.listAll(POSSalesReturn.class);
        for (POSSalesReturn pOSSalesReturn : returns) {
            this.removeIncorrectMehodIds(pOSSalesReturn);
            this.removeDebitLineFromPayments(pOSSalesReturn);
            this.updateCashFieldInPaymentLines(pOSSalesReturn);
            POSPersister.saveOrUpdate(pOSSalesReturn);
        }
        List<POSPaymentToRegistery> list = POSPersister.listAll(POSPaymentToRegistery.class);
        for (POSPaymentToRegistery pOSPaymentToRegistery : list) {
            POSFinancialUtil.addFinancialSysLine(pOSPaymentToRegistery);
        }
        List<POSReceiptFromRegistery> list2 = POSPersister.listAll(POSReceiptFromRegistery.class);
        for (POSReceiptFromRegistery pOSReceiptFromRegistery : list2) {
            POSFinancialUtil.addFinancialSysLine(pOSReceiptFromRegistery);
        }
        List<POSShiftOpen> list3 = POSPersister.listAll(POSShiftOpen.class);
        for (POSShiftOpen open : list3) {
            for (POSShiftOpenLine line : open.getDetails()) {
                if (!line.isCash().booleanValue() && !line.isDebit().booleanValue() && ObjectChecker.isNotEmptyOrNull((Object)line.getPaymentMethodId())) {
                    line.setAccountantRemaining(BigDecimal.ZERO);
                    line.setDifference(line.getActualRemaining().subtract(line.getAccountantRemaining()));
                }
                POSFinancialUtil.addFinancialSysLine(line);
            }
        }
        List<POSShiftClose> list4 = POSPersister.listAll(POSShiftClose.class);
        for (POSShiftClose close : list4) {
            close.postCommitAction(null);
        }
    }

    private void updateCashFieldInPaymentLines(AbsPOSSales sales) {
        for (AbsPOSPaymentLine absPOSPaymentLine : sales.fetchPayments()) {
            if (ObjectChecker.isNotEmptyOrNull((Object)absPOSPaymentLine.getMethod_id()) && ObjectChecker.areEqual((Object)absPOSPaymentLine.getPaymentMethodId(), (Object)MultiplePaymentDialog.cashMethodID()) || ObjectChecker.isAnyEqualToFirst((Object)absPOSPaymentLine.getMethodName(), (Object[])new String[]{"cash", "\u062f\u0641\u0639 \u0646\u0642\u062f\u064a", POSResourcesUtil.id("cash", new Object[0])})) {
                absPOSPaymentLine.setCash(true);
                continue;
            }
            absPOSPaymentLine.setCash(false);
        }
    }

    private void removeIncorrectMehodIds(AbsPOSSales invoice) {
        for (AbsPOSPaymentLine absPOSPaymentLine : invoice.fetchPayments()) {
            if (POSPersister.findByID(POSPaymentMethod.class, absPOSPaymentLine.getMethod_id()) != null) continue;
            absPOSPaymentLine.setMethod_id(null);
        }
    }

    public void removeDebitLineFromPayments(AbsPOSSales invoice) {
        for (int i = invoice.fetchPayments().size() - 1; i >= 0; --i) {
            if (!ObjectChecker.isEmptyOrNull((Object)invoice.fetchPayments().get(i).getMethod_id())) continue;
            invoice.fetchPayments().remove(i);
        }
    }

    @Override
    public Integer getFromVersion() {
        return 10;
    }
}

