/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.NaMaLogger;
import java.text.MessageFormat;

public abstract class POSMigrator {
    public abstract Integer getFromVersion();

    public void migrateIfNeeded(int versionInDatabase) {
        if (!this.isApplicableOn(versionInDatabase)) {
            return;
        }
        NaMaLogger.info((String)"Starting pos migrator {0}", (Object[])new Object[]{this});
        this.doMigrate();
    }

    public String toString() {
        return MessageFormat.format(" {0}: from ({1})", this.getClass().getName(), this.getFromVersion());
    }

    protected boolean isApplicableOn(int versionInDatabase) {
        if (this.getFromVersion() == null) {
            return true;
        }
        return versionInDatabase <= this.getFromVersion();
    }

    protected abstract void doMigrate();
}

