/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.pos.Migrator.POSMigrator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionScanningUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import com.namasoft.specialserialization.ScanningUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class POSMigratorUtil
implements ReflectionScanningUtil {
    private static List<POSMigrator> migrators;

    private static void collectMigrators() {
        if (migrators == null) {
            migrators = new ArrayList<POSMigrator>();
            Set migratorClasses = ScanningUtils.getSubTypesOf(POSMigrator.class);
            ReflectionUtils.removeAbstractClasses((Collection)migratorClasses);
            for (Class migratorClass : migratorClasses) {
                migrators.add((POSMigrator)ObjectCreatorUtil.creator((Class)migratorClass).create());
            }
            Collections.sort(migrators, Comparator.comparing(POSMigrator::getFromVersion));
        }
    }

    public static void migrateIfNeeded() {
        int versionInDatabase = POSResourcesUtil.currentSetting.getCurrentDBVersion();
        int currentVersion = 46;
        boolean migrated = false;
        if (versionInDatabase > 0 && currentVersion > versionInDatabase) {
            POSMigratorUtil.collectMigrators();
            migrated = true;
            NaMaLogger.info((String)"Starting database migration from version {0} to version {1}", (Object[])new Object[]{versionInDatabase, currentVersion});
            for (POSMigrator migrator : migrators) {
                migrator.migrateIfNeeded(versionInDatabase);
            }
        }
        POSMigratorUtil.updateDBVersionWithCurrent(currentVersion);
        if (!migrated) {
            NaMaLogger.info((Object)"No migration is needed");
        }
    }

    private static void updateDBVersionWithCurrent(int currentVersion) {
        POSResourcesUtil.currentSetting.setCurrentDBVersion(currentVersion);
        POSPersister.saveOrUpdate(POSResourcesUtil.currentSetting);
    }

    public static void changeColumnDataType(Class tableClazz, String type, String ... columns) {
        String table = tableClazz.getSimpleName();
        String tableUnit = "ALTER TABLE " + table;
        for (String column : columns) {
            Object updateQuery = "";
            updateQuery = tableUnit + " ALTER COLUMN " + column + " " + type + ";";
            POSPersister.execute((String)updateQuery);
        }
    }

    public static void copyOldColumnToNew(String oldColumnName, String newColumnName, Class klass) {
        if (!POSMigratorUtil.doesColumnExistInTable(oldColumnName, klass.getSimpleName())) {
            return;
        }
        POSPersister.execute("update " + klass.getSimpleName() + " set " + newColumnName + "  = " + oldColumnName);
    }

    public static boolean doesColumnExistInTable(String colName, String tableName) {
        try {
            POSPersister.executeSelect("SELECT " + colName + " FROM " + tableName, " WHERE 1=1 ", new HashMap<String, Object>());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void copyColumnToColumnAndClearOld(Class table, String newColumn, String oldColumn) {
        POSPersister.execute("update " + table.getSimpleName() + " set " + newColumn + " = " + oldColumn);
        POSPersister.execute("update " + table.getSimpleName() + " set " + oldColumn + " = NULL ");
    }

    public void doSetup() {
        POSMigratorUtil.collectMigrators();
    }

    public int order() {
        return 0;
    }
}

