/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.pos.domain.entities.IPOSFromReplacement;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSSalesReturn;
import java.util.List;

public class POSReplacementReGenProblemFixer {
    public void startFix() {
        this.deleteMultiGeneratedFromReplacement(POSSalesInvoice.class);
        this.deleteMultiGeneratedFromReplacement(POSSalesReturn.class);
    }

    private <T extends POSMasterFile> void deleteMultiGeneratedFromReplacement(Class klass) {
        List<?> invoices = POSPersister.listAll(klass, " where replacementCode is not null order by code desc");
        int i = invoices.size() - 1;
        while (i >= 0 & i < invoices.size()) {
            POSMasterFile inv = (POSMasterFile)invoices.get(i);
            int j = i - 1;
            while (j >= 0 & j < invoices.size()) {
                POSMasterFile anotherInv = (POSMasterFile)invoices.get(j);
                if (ObjectChecker.areEqual((Object)((IPOSFromReplacement)((Object)inv)).getReplacementCode(), (Object)((IPOSFromReplacement)((Object)anotherInv)).getReplacementCode()) && ObjectChecker.areNotEqual((Object)inv.getId(), (Object)anotherInv.getId()) && anotherInv.getCode().compareTo(inv.getCode()) > 0) {
                    invoices.remove(anotherInv);
                    POSPersister.delete(anotherInv);
                }
                --j;
            }
            --i;
        }
    }
}

