/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.Migrator;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.Migrator.POSMigrator;
import com.namasoft.pos.application.POSPersister;
import com.namasoft.pos.domain.AbsPOSInventoryLine;
import com.namasoft.pos.domain.AbsPOSShiftInventory;
import com.namasoft.pos.domain.entities.POSCurrency;
import com.namasoft.pos.domain.entities.POSInventory;
import com.namasoft.pos.domain.entities.POSShift;
import com.namasoft.pos.domain.entities.POSShiftClose;
import com.namasoft.pos.domain.entities.POSShiftOpen;
import java.util.List;

public class POSShiftLinesCurrencyIdMigrator
extends POSMigrator {
    @Override
    protected void doMigrate() {
        List<POSInventory> posCashDrawers = POSPersister.listAll(POSInventory.class);
        for (POSInventory pOSInventory : posCashDrawers) {
            this.updateShiftORCashDrawerLines(pOSInventory);
        }
        List<POSShift> shifts = POSPersister.listAll(POSShift.class);
        for (POSShift pOSShift : shifts) {
            this.updateShiftORCashDrawerLines(pOSShift);
        }
        List<POSShiftOpen> list = POSPersister.listAll(POSShiftOpen.class);
        for (POSShiftOpen open : list) {
            this.updateShiftORCashDrawerLines(open);
        }
        List<POSShiftClose> list2 = POSPersister.listAll(POSShiftClose.class);
        for (POSShiftClose close : list2) {
            this.updateShiftORCashDrawerLines(close);
        }
    }

    private void updateShiftORCashDrawerLines(AbsPOSShiftInventory document) {
        List<AbsPOSInventoryLine> lines = document.fetchDetails();
        for (AbsPOSInventoryLine line : lines) {
            String currencyCode = ObjectChecker.isNotEmptyOrNull((Object)line.getCurrency().split("-")) ? line.getCurrency().split("-")[0] : "";
            if (!ObjectChecker.isNotEmptyOrNull((Object)currencyCode)) continue;
            POSCurrency currency = (POSCurrency)POSPersister.findByCode(POSCurrency.class, currencyCode);
            if (!ObjectChecker.isNotEmptyOrNull((Object)currencyCode)) continue;
            line.setCurrencyId(currency.getId());
        }
        POSPersister.saveOrUpdate(document);
    }

    @Override
    public Integer getFromVersion() {
        return 9;
    }
}

