/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.AdditionalPayMethodBtn;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.domain.POSPaymentMethod;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

public class AdditionalPaymentMethodsDialog
extends NamaDialog<ButtonType> {
    private int additionalMethodsCountPerRow = 5;
    private MultiplePaymentDialog multiplePaymentDialog;
    private List<POSPaymentMethod> additionalMethods;

    public AdditionalPaymentMethodsDialog(MultiplePaymentDialog dialog, List<POSPaymentMethod> methods) {
        super("showAdditionalMethods");
        this.multiplePaymentDialog = dialog;
        this.additionalMethods = methods;
        ScrollPane scrollPane = new ScrollPane();
        GridPane pane = new GridPane();
        pane.setHgap(5.0);
        pane.setVgap(5.0);
        int col = 0;
        int row = 0;
        for (POSPaymentMethod method : this.additionalMethods) {
            if (col == this.additionalMethodsCountPerRow) {
                col = 0;
                ++row;
            }
            pane.add((Node)new AdditionalPayMethodBtn(method, this.multiplePaymentDialog, this), col, row);
            ++col;
        }
        NamaHBox.setHgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        scrollPane.setContent((Node)pane);
        this.content((Node)scrollPane);
        this.fromDialog(dialog);
    }

    public void showDialog() {
        AbsPosSalesScreen screen = this.multiplePaymentDialog.getSalesScreen();
        this.getDialogPane().setPrefHeight(screen.fetchStage().getHeight() / 2.0);
        this.setResizable(true);
        this.addCancelButton("");
        this.showAndWait();
    }
}

