/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.namacontrols.IHasFont;
import com.namasoft.namacontrols.POSLabeledField;
import com.namasoft.pos.domain.POSMasterFile;
import com.namasoft.specialserialization.ObjectCreatorUtil;
import com.namasoft.specialserialization.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.util.Pair;

public class GridPaneDrawer<T extends POSLabeledField, E extends POSMasterFile> {
    private int colsCount = 0;
    private int rowsCount = 0;
    private GridPane grid = new GridPane();
    private E baseEntity;
    private int gridColsPerRow = 2;

    public void setGridColsPerRow(int gridColsPerRow) {
        this.gridColsPerRow = gridColsPerRow;
    }

    public int getGridColsPerRow() {
        return this.gridColsPerRow;
    }

    public GridPaneDrawer(E entity) {
        this.grid.setHgap(4.0);
        this.grid.setVgap(4.0);
        this.grid.setPadding(new Insets(7.0));
        if (entity == null) {
            entity = (POSMasterFile)ObjectCreatorUtil.creator(entity.getClass()).create();
        }
        this.baseEntity = entity;
    }

    public <T extends Region> GridPane addNormalFields(List<T> fields, boolean removePreviousFields) {
        if (removePreviousFields) {
            this.grid.getChildren().clear();
            this.grid.getColumnConstraints().clear();
        }
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        double width = primScreenBounds.getWidth();
        this.addGridColConstrains(this.gridColsPerRow);
        for (Region field : fields) {
            if (field instanceof IHasFont) {
                ((IHasFont)field).setFont(this.calcFont(width));
            }
            this.addField(field);
            int fieldsPerRow = this.gridColsPerRow;
            if (this.colsCount % fieldsPerRow != 0) continue;
            this.resetRowColValues();
        }
        return this.grid;
    }

    public void addField(Region field) {
        POSLabeledField labeledField;
        if (field instanceof POSLabeledField && (labeledField = (POSLabeledField)field).alone().booleanValue()) {
            this.resetRowColValues();
            this.grid.add((Node)labeledField.getLabel(), this.colsCount++, this.rowsCount);
            this.grid.add((Node)labeledField.getField(), this.colsCount, this.rowsCount, Integer.MAX_VALUE, 1);
            this.colsCount = this.fieldsCountPerRow();
        } else if (field instanceof POSLabeledField) {
            POSLabeledField labeledField2 = (POSLabeledField)field;
            this.grid.add((Node)labeledField2.getLabel(), this.colsCount++, this.rowsCount);
            this.grid.add((Node)labeledField2.getField(), this.colsCount++, this.rowsCount);
        } else {
            this.grid.add((Node)field, this.colsCount, this.rowsCount);
            ++this.colsCount;
        }
        if (this.colsCount % this.fieldsCountPerRow() == 0) {
            this.resetRowColValues();
        }
    }

    public GridPane addFields(T ... fields) {
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        double width = primScreenBounds.getWidth();
        this.addGridColConstrains(this.fieldsCountPerRow());
        for (T field : fields) {
            ((POSLabeledField)field).setFont(this.calcFont(width));
            this.linkFieldWithDomainObj(field);
            if (((POSLabeledField)field).alone().booleanValue()) {
                if (this.colsCount > 0) {
                    this.resetRowColValues();
                }
                this.addLabelAndField(field);
                this.resetRowColValues();
                continue;
            }
            this.addLabelAndField(field);
            ++this.colsCount;
            int fieldsPerRow = this.fieldsCountPerRow();
            if (this.colsCount % fieldsPerRow != 0) continue;
            this.resetRowColValues();
        }
        return this.grid;
    }

    private Font calcFont(double width) {
        return new Font(width / 100.0);
    }

    public void addGridColConstrains(double ... percentages) {
        for (int i = 0; i < percentages.length; ++i) {
            ColumnConstraints constraints = new ColumnConstraints();
            constraints.setPercentWidth(percentages[i]);
            constraints.setHgrow(Priority.ALWAYS);
            this.grid.getColumnConstraints().add((Object)constraints);
        }
    }

    private void addGridColConstrains(int fieldsPerRow) {
        int colWidth = 100 / fieldsPerRow;
        for (int i = 0; i < fieldsPerRow; ++i) {
            ColumnConstraints constraints = new ColumnConstraints();
            constraints.setPercentWidth((double)colWidth);
            constraints.setHgrow(Priority.ALWAYS);
            this.grid.getColumnConstraints().add((Object)constraints);
        }
    }

    private int fieldsCountPerRow() {
        return this.gridColsPerRow;
    }

    private void addLabelAndField(T field) {
        this.grid.add((Node)((POSLabeledField)field).getLabel(), this.colsCount, this.rowsCount);
        ++this.colsCount;
        if (((POSLabeledField)field).alone().booleanValue()) {
            GridPane.setColumnSpan((Node)field.getField(), (Integer)(this.fieldsCountPerRow() - 1));
        }
        this.grid.add((Node)field.getField(), this.colsCount, this.rowsCount);
    }

    public void resetRowColValues() {
        ++this.rowsCount;
        this.colsCount = 0;
    }

    private void linkFieldWithDomainObj(T field) {
        String relatedToField = ((POSLabeledField)field).getRelatedToField();
        if (relatedToField == null) {
            return;
        }
        try {
            Pair<Method, Method> setterAndGetter = this.fetchSetterAndGetter(relatedToField, this.baseEntity.getClass());
            if (setterAndGetter.getValue() != null) {
                field.setValue(ReflectionUtils.callMethod(this.baseEntity, (Method)((Method)setterAndGetter.getValue()), (Object[])new Object[0]));
            }
            field.getField().focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue() && setterAndGetter.getKey() != null) {
                    try {
                        ReflectionUtils.callMethod(this.baseEntity, (Method)((Method)setterAndGetter.getKey()), (Object[])new Object[]{field.getValue()});
                    }
                    catch (Exception e) {
                        NaMaLogger.error((Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }

    private Pair<Method, Method> fetchSetterAndGetter(String fieldId, Class klass) {
        String firstLetter = fieldId.substring(0, 1).toUpperCase();
        String filedWithUpperCaseLetter = firstLetter + fieldId.substring(1);
        try {
            Method getterMethod = ReflectionUtils.tryGetMethod((Class)klass, (String)("get" + filedWithUpperCaseLetter));
            Method setterMethod = ReflectionUtils.tryGetMethod((Class)klass, (String)("set" + filedWithUpperCaseLetter));
            return new Pair((Object)setterMethod, (Object)getterMethod);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            return new Pair(null, null);
        }
    }

    public GridPane getPane() {
        return this.grid;
    }
}

