/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.IHasToolBar;
import com.namasoft.pos.application.MultiplePaymentDialog;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSResourcesUtil;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.application.PosScreenCacheUtil;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.util.POSResult;
import java.math.BigDecimal;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.scene.control.Dialog;

public class HeavyPosSalesTest {
    private int invoicesCount = 1000;
    private int currentInvNum = 0;
    private int lineNum = 0;
    private int maxLinesNum = 1;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private String[] availableItems = new String[]{"510787"};

    public void start(IHasToolBar screen) {
        this.executorService.scheduleAtFixedRate(() -> {
            if (this.currentInvNum > this.invoicesCount) {
                this.executorService.shutdown();
                System.out.println("saving " + this.invoicesCount + " invoices ends");
                return;
            }
            Platform.runLater(() -> {
                AbsPosSalesScreen salesScreen = (AbsPosSalesScreen)PosScreenCacheUtil.fetchCachedScreen(POSDocumentType.Invoice);
                salesScreen.draw(screen.fetchStage(), POSDocumentType.Invoice);
                this.lineNum = 0;
                ScheduledExecutorService executorService2 = Executors.newSingleThreadScheduledExecutor();
                executorService2.scheduleAtFixedRate(() -> Platform.runLater(() -> {
                    if (this.lineNum == this.maxLinesNum) {
                        executorService2.shutdown();
                        PosScene.invPayAction(salesScreen, true);
                        ScheduledExecutorService executorService3 = Executors.newSingleThreadScheduledExecutor();
                        Dialog activatedDialog = salesScreen.getActivatedDialog();
                        executorService3.schedule(() -> Platform.runLater(() -> ((MultiplePaymentDialog)activatedDialog).processAction(salesScreen.getSalesDoc())), 1L, TimeUnit.SECONDS);
                        ++this.currentInvNum;
                        return;
                    }
                    AbsPOSSales salesDoc = salesScreen.getSalesDoc();
                    String qtyText = "";
                    if (screen instanceof AbsPosSalesScreen) {
                        qtyText = ((AbsPosSalesScreen)screen).getFavouritesContainerBuilder().getQty().getText();
                    }
                    BigDecimal qty = new BigDecimal((String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{qtyText, "1"}));
                    Random r = new Random();
                    salesDoc.addSalesLine(POSResourcesUtil.fetchMainRegister(), this.availableItems[r.nextInt(this.availableItems.length)], salesDoc.fetchDetails().size(), qty, true, salesScreen, new POSResult());
                    salesDoc.updateTotals(salesScreen);
                    ++this.lineNum;
                }), 0L, 500L, TimeUnit.MILLISECONDS);
            });
        }, 0L, 7L, TimeUnit.SECONDS);
    }
}

