/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.contracts.entities.DTONamaPOSSalesInvoice;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.NamaObservable;
import com.namasoft.pos.application.POSCodeGenerator;
import com.namasoft.pos.application.POSDocumentType;
import com.namasoft.pos.application.POSNewSalesScreen;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.application.PosScene;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.POSSalesInvoiceLine;
import com.namasoft.pos.domain.entities.POSSalesInvoice;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.domain.valueobjects.POSQuantity;
import com.namasoft.pos.factories.POSSalesInvoiceFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class InvoiceSplitter
extends NamaDialog {
    private AbsPosSalesScreen screen;
    private NamaTableView<AbsPOSSalesLine> table = new NamaTableView();
    private List<? extends AbsPOSSalesLine> scrLines = new ArrayList<AbsPOSSalesLine>();
    private ObservableList<AbsPOSSalesLine> items;
    private AbsPOSSales salesDoc;
    private POSSalesInvoice invoiceCopy = new POSSalesInvoice();

    public InvoiceSplitter(AbsPosSalesScreen hasToolBar) {
        super("SplitInvoice");
        this.screen = hasToolBar;
        double width = hasToolBar.fetchStage().getWidth() / 2.0;
        this.setWidth(width);
        POSTableColumn itemCode = new POSTableColumn("itemCode");
        double colWidth = width / 6.0;
        itemCode.setPrefWidth(colWidth);
        itemCode.setCellValueFactory((Callback)new PropertyValueFactory("itemCode"));
        POSTableColumn itemName = new POSTableColumn("itemName");
        itemName.setPrefWidth(colWidth);
        itemName.setCellValueFactory((Callback)new PropertyValueFactory("itemName"));
        POSTableColumn unitPrice = new POSTableColumn("unitPrice");
        unitPrice.setPrefWidth(colWidth);
        unitPrice.setCellValueFactory((Callback)new PropertyValueFactory("unitPrice"));
        POSTableColumn qtyCol = new POSTableColumn("qty");
        qtyCol.setPrefWidth(colWidth);
        qtyCol.setCellValueFactory(param -> new NamaObservable<BigDecimal>(ObjectChecker.isNotEmptyOrNull((Object)((AbsPOSSalesLine)param.getValue()).getQty()) ? ((AbsPOSSalesLine)param.getValue()).getQty().getValue() : BigDecimal.ZERO));
        TableColumn<AbsPOSSalesLine, Node> btnsCol = this.createActionsColumn(colWidth);
        this.table.getColumns().addAll((Object[])new TableColumn[]{itemCode, itemName, unitPrice, qtyCol, btnsCol});
        this.salesDoc = this.screen.salesDoc;
        Object dtoNamaFromPOSInvoice = this.salesDoc.toDTO();
        this.invoiceCopy = POSSalesInvoiceFactory.createPOSInvoiceFromDTO((DTONamaPOSSalesInvoice)dtoNamaFromPOSInvoice);
        this.invoiceCopy.setHold(this.salesDoc.getHold());
        this.invoiceCopy.setPaymentDelayed(this.salesDoc.getPaymentDelayed());
        this.invoiceCopy.setId(null);
        this.invoiceCopy.assignIds();
        this.scrLines = this.invoiceCopy.fetchDetails();
        List copy = this.scrLines.stream().filter(o -> ObjectChecker.isNotEmptyOrNull((Object)o.getUnitPrice()) && o.getUnitPrice().compareTo(BigDecimal.ZERO) > 0).map(l -> {
            POSSalesInvoiceLine line = new POSSalesInvoiceLine();
            line.setItem(l.getItem());
            line.setItemCode(l.getItemCode());
            line.setItemName(l.getItemName());
            line.setQty(new POSQuantity());
            line.getQty().setUom(l.getQty().getUom());
            line.getQty().setValue(BigDecimal.ONE);
            line.setNetPrice(l.getNetPrice());
            line.setUnitPrice(l.getUnitPrice());
            line.setMasterRowId(l.getId());
            line.assignIds();
            return line;
        }).collect(Collectors.toList());
        this.items = FXCollections.observableArrayList(copy);
        this.table.setItems(this.items);
    }

    private TableColumn<AbsPOSSalesLine, Node> createActionsColumn(double width) {
        POSTableColumn<AbsPOSSalesLine, Node> btnsCol = new POSTableColumn<AbsPOSSalesLine, Node>("");
        btnsCol.setPrefWidth(width);
        btnsCol.setCellFactory(param -> {
            POSTableCell cell = new POSTableCell(){

                public void updateItem(Object item, boolean empty) {
                    if (empty) {
                        this.setGraphic(null);
                        return;
                    }
                    NamaButton lineRemove = new NamaButton();
                    lineRemove.setTooltip(new POSTooltip("remove"));
                    lineRemove.setSVGIcon("delete.svg");
                    lineRemove.setOnAction(event -> {
                        AbsPOSSalesLine line = (AbsPOSSalesLine)this.getTableRow().getItem();
                        InvoiceSplitter.this.items.remove((Object)line);
                        InvoiceSplitter.this.table.setItems(InvoiceSplitter.this.items);
                    });
                    NamaButton increaseLineQty = new NamaButton();
                    increaseLineQty.setTooltip(new POSTooltip("increaseLineQty"));
                    increaseLineQty.setSVGIcon("addLine.svg");
                    increaseLineQty.setOnAction(event -> {
                        AbsPOSSalesLine line = (AbsPOSSalesLine)this.getTableRow().getItem();
                        AbsPOSSalesLine srcLine = InvoiceSplitter.this.fetchSrc(line);
                        if (line.getQty().getValue().add(BigDecimal.ONE).compareTo(srcLine.getQty().getValue()) <= 0) {
                            line.getQty().setValue(line.getQty().getValue().add(BigDecimal.ONE));
                            InvoiceSplitter.this.table.getItems().set(this.getTableRow().getIndex(), (Object)line);
                        }
                    });
                    NamaButton decreaseLineQty = new NamaButton();
                    decreaseLineQty.setTooltip(new POSTooltip("decreaseLineQty"));
                    decreaseLineQty.setSVGIcon("minus.svg");
                    decreaseLineQty.setOnAction(event -> {
                        AbsPOSSalesLine line = (AbsPOSSalesLine)this.getTableRow().getItem();
                        if (line.getQty().getValue().compareTo(BigDecimal.ONE) > 0) {
                            line.getQty().setValue(line.getQty().getValue().subtract(BigDecimal.ONE));
                            InvoiceSplitter.this.table.getItems().set(this.getTableRow().getIndex(), (Object)line);
                        }
                    });
                    NamaHBox namaHBox = new NamaHBox();
                    increaseLineQty.setPadding(new Insets(4.0));
                    decreaseLineQty.setPadding(new Insets(4.0));
                    namaHBox.getChildren().addAll((Object[])new Node[]{increaseLineQty, decreaseLineQty, lineRemove});
                    this.setGraphic((Node)namaHBox);
                }
            };
            return cell;
        });
        return btnsCol;
    }

    private AbsPOSSalesLine fetchSrc(AbsPOSSalesLine line) {
        return this.scrLines.stream().filter(l -> ObjectChecker.areEqual((Object)l.getId(), (Object)line.getMasterRowId())).findFirst().get();
    }

    public void display() {
        this.getDialogPane().setPrefWidth(this.screen.fetchStage().getWidth() / 2.0);
        this.getDialogPane().setPrefHeight(this.screen.fetchStage().getHeight() / 2.0);
        this.setResizable(true);
        this.getDialogPane().setContent(this.table);
        this.addOkButton("");
        this.addCancelButton("");
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.splitInvoice();
        }
    }

    private void splitInvoice() {
        ObservableList tableItems = this.table.getItems();
        if (ObjectChecker.isEmptyOrNull((Object)tableItems)) {
            this.close();
            return;
        }
        for (AbsPOSSalesLine l : tableItems) {
            AbsPOSSalesLine absPOSSalesLine = this.fetchSrc(l);
            if (absPOSSalesLine.getQty().getValue().compareTo(l.getQty().getValue()) == 0) {
                this.scrLines.remove(absPOSSalesLine);
                continue;
            }
            absPOSSalesLine.getQty().setValue(absPOSSalesLine.getQty().getValue().subtract(l.getQty().getValue()));
        }
        this.salesDoc.updateDetails(this.scrLines);
        this.screen.salesDoc = this.salesDoc;
        this.salesDoc.updateTotals(this.screen);
        ((POSSalesInvoice)this.salesDoc).setSplitInvoice(true);
        this.screen.holdInvoice();
        this.invoiceCopy.setCode(POSCodeGenerator.generateInvoiceCode(POSDocumentType.Invoice));
        this.invoiceCopy.updateDetails((List<? extends AbsPOSSalesLine>)tableItems);
        tableItems.forEach(item -> item.updateInvoice(this.invoiceCopy));
        POSNewSalesScreen newScreen = new POSNewSalesScreen();
        newScreen.stage = this.screen.stage;
        newScreen.salesDoc = this.invoiceCopy;
        this.invoiceCopy.setSplitInvoice(true);
        newScreen.docType = POSDocumentType.Invoice;
        AbsPosSalesScreen.fillLastScreensDocsMapIfNeeded(newScreen);
        PosScene.drawSalesScreen(newScreen.stage);
        this.invoiceCopy.updateTotals(newScreen);
    }
}

