/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaButton;
import com.namasoft.namacontrols.NamaDialog;
import com.namasoft.namacontrols.NamaHBox;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.namacontrols.NamaTableView;
import com.namasoft.namacontrols.NamaText;
import com.namasoft.namacontrols.POSErrorAndInfoMessagesUtil;
import com.namasoft.namacontrols.tablecells.POSTableCell;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.application.POSTooltip;
import com.namasoft.pos.domain.AbsPOSSales;
import com.namasoft.pos.domain.details.PosTableLine;
import com.namasoft.pos.domain.entities.POSTable;
import com.namasoft.pos.domain.entities.POSTableColumn;
import com.namasoft.pos.util.POSResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class MultiTableDialog
extends NamaDialog {
    private AbsPosSalesScreen hasToolBar;
    private NamaSearchBox tableField;
    private NamaSearchBox originField;
    private NamaTableView<PosTableLine> table;

    public TableView<PosTableLine> getTable() {
        return this.table;
    }

    public NamaSearchBox getOriginField() {
        return this.originField;
    }

    public void setOriginField(NamaSearchBox originField) {
        this.originField = originField;
    }

    public MultiTableDialog(AbsPosSalesScreen screen) {
        super("invTables");
        this.hasToolBar = screen;
    }

    public void showDialog() {
        this.tableField = new NamaSearchBox(POSTable.class, this.hasToolBar, "", this.hasToolBar.fetchStage());
        this.tableField.setFromDialog(this);
        this.tableField.setRelatedTableDialog(this);
        this.tableField.hideName();
        this.table = new NamaTableView();
        BorderPane box = new BorderPane();
        GridPane header = new GridPane();
        header.setHgap(100.0);
        NamaText tableCode_ = new NamaText("tableCode", new Object[0]);
        box.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        header.setPadding(new Insets(10.0, 10.0, 10.0, 400.0));
        double dialogWidth = this.hasToolBar.fetchStage().getWidth() / 2.0;
        this.getDialogPane().setPrefWidth(dialogWidth);
        this.setResizable(true);
        POSTableColumn tableCode = new POSTableColumn("tableCode");
        POSTableColumn tableName1 = new POSTableColumn("tableName1");
        POSTableColumn tableName2 = new POSTableColumn("tableName2");
        POSTableColumn removeLineCol = new POSTableColumn("");
        tableCode.setPrefWidth(dialogWidth / 5.0);
        tableCode.setCellValueFactory((Callback)new PropertyValueFactory("tableCode"));
        tableCode.setCellFactory(POSTableCell.defaultCellFactory());
        tableCode.setEditable(false);
        tableName1.setPrefWidth(dialogWidth / 5.0);
        tableName1.setCellValueFactory((Callback)new PropertyValueFactory("tableName1"));
        tableName1.setCellFactory(POSTableCell.defaultCellFactory());
        tableName1.setEditable(false);
        removeLineCol.setPrefWidth(dialogWidth / 5.0);
        tableName2.setPrefWidth(dialogWidth / 5.0);
        tableName2.setCellValueFactory((Callback)new PropertyValueFactory("tableName2"));
        tableName2.setCellFactory(POSTableCell.defaultCellFactory());
        tableName2.setEditable(false);
        removeLineCol.setCellFactory(param -> {
            POSTableCell cell = new POSTableCell(){

                public void updateItem(Object item, boolean empty) {
                    if (empty) {
                        this.setGraphic(null);
                        return;
                    }
                    NamaButton lineRemove = new NamaButton();
                    lineRemove.setTooltip(new POSTooltip("remove"));
                    lineRemove.setSVGIcon("delete.svg");
                    lineRemove.setOnAction(event -> {
                        PosTableLine line = (PosTableLine)this.getTableRow().getItem();
                        int currentIndex = MultiTableDialog.this.table.getItems().indexOf((Object)line);
                        MultiTableDialog.this.table.getItems().remove(currentIndex);
                    });
                    NamaHBox namaHBox = new NamaHBox();
                    lineRemove.setPadding(new Insets(4.0));
                    namaHBox.getChildren().addAll((Object[])new Node[]{lineRemove});
                    this.setGraphic((Node)namaHBox);
                }
            };
            return cell;
        });
        this.table.getColumns().addAll((Object[])new TableColumn[]{tableCode, tableName1, tableName2, removeLineCol});
        GridPane itemGrid = new GridPane();
        itemGrid.setHgap(10.0);
        HBox title = new HBox(5.0);
        title.getChildren().addAll((Object[])new Node[]{tableCode_, this.tableField});
        title.setAlignment(Pos.CENTER);
        itemGrid.add((Node)title, 0, 0);
        header.add((Node)itemGrid, 0, 1);
        box.setTop((Node)header);
        box.setCenter(this.table);
        this.content((Node)box);
        this.addOkButton("");
        this.addCancelButton("");
        this.onEnterPressed((Node)this.getDialogPane());
        this.onEnterPressed((Node)this.table);
        EventHandler parentOnShowing = this.getOnShowing();
        this.setOnShowing(e -> {
            parentOnShowing.handle(e);
            this.tableField.searchAction(null);
        });
        List tableLines = this.hasToolBar.salesDoc.fetchTables();
        ArrayList lines = new ArrayList();
        if (ObjectChecker.isNotEmptyOrNull(tableLines)) {
            tableLines.stream().forEach(l -> {
                PosTableLine line = MultiTableDialog.createPosTableLine(l.getPosTable());
                lines.add(line);
            });
        }
        this.table.setItems(FXCollections.observableArrayList(lines));
        Optional result = this.showAndWait();
        if (result.isPresent() && ObjectChecker.areEqual((Object)((ButtonType)result.get()).getButtonData(), (Object)ButtonBar.ButtonData.APPLY)) {
            this.setTablesInDoc();
        }
    }

    private void onEnterPressed(Node node) {
        node.setOnKeyPressed(l -> {
            if (ObjectChecker.areEqual((Object)l.getCode(), (Object)KeyCode.ENTER)) {
                this.setTablesInDoc();
                this.close();
            }
        });
    }

    private void setTablesInDoc() {
        this.hasToolBar.salesDoc.updateTables((List<PosTableLine>)this.table.getItems());
        this.hide();
        if (ObjectChecker.isNotEmptyOrNull((Object)this.getOriginField())) {
            this.getOriginField().getCodeBox().setText(this.hasToolBar.salesDoc.getTablesCodes());
            this.getOriginField().getNameBox().setText(this.hasToolBar.salesDoc.getTablesNames());
            this.getOriginField().getIdBox().setText(this.hasToolBar.salesDoc.getTablesIDs());
        }
    }

    public void clearTable() {
        this.table.getItems().clear();
    }

    public void addLineToTable(POSTable posTable) {
        AbsPOSSales salesDoc = this.hasToolBar.getSalesDoc();
        if (ObjectChecker.isNotEmptyOrNull((Object)salesDoc.getTable()) && ObjectChecker.areEqual((Object)salesDoc.getTable().getId(), (Object)posTable.getId())) {
            POSResult result = new POSResult();
            result.failure("repeatedTable", new Object[0]);
            POSErrorAndInfoMessagesUtil.showError(result, this.hasToolBar.fetchStage());
            return;
        }
        if (this.table.getItems().stream().filter(l -> ObjectChecker.areEqual((Object)l.getTableID(), (Object)posTable.getId())).count() > 0L) {
            return;
        }
        ObservableList items = this.table.getItems();
        PosTableLine line = MultiTableDialog.createPosTableLine(posTable);
        items.add((Object)line);
    }

    public static PosTableLine createPosTableLine(POSTable posTable) {
        PosTableLine line = new PosTableLine();
        line.setTableID(posTable.getId());
        line.setTableCode(posTable.getCode());
        line.setTableName1(posTable.getName1());
        line.setTableName2(posTable.getName2());
        return line;
    }
}

