/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.namapos.enums.POSSecurityCapability;
import com.namasoft.pos.application.AbsPosSalesScreen;
import com.namasoft.pos.domain.details.AbsPOSSalesLine;
import com.namasoft.pos.domain.details.HasCheckBox;
import com.namasoft.pos.util.POSResult;
import com.namasoft.pos.util.POSSecurityUtil;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public abstract class NamaCheckBoxCellFactory<T extends HasCheckBox>
implements Callback<TableColumn.CellDataFeatures<T, CheckBox>, ObservableValue<CheckBox>> {
    public static <T extends HasCheckBox> NamaCheckBoxCellFactory<T> createFreeItemCheckbox(final AbsPosSalesScreen salesScreen) {
        return new NamaCheckBoxCellFactory<T>(){

            @Override
            protected void updateValue(HasCheckBox hasCheckBox, Boolean new_val, CheckBox checkBox) {
                POSResult result = POSSecurityUtil.checkIfHasCapability(POSSecurityCapability.CanGiveFreeItems);
                if (!result.isFailed().booleanValue()) {
                    checkBox.setSelected(new_val.booleanValue());
                    hasCheckBox.updateFreeLineProperty(new_val);
                    salesScreen.getSalesTable().getItems().set(salesScreen.getSalesTable().getItems().indexOf((Object)hasCheckBox), (Object)((AbsPOSSalesLine)hasCheckBox));
                    salesScreen.salesDoc.updateTotals(salesScreen);
                }
            }

            @Override
            protected Boolean readValue(HasCheckBox hasCheckBox) {
                return hasCheckBox.fetchFreeLineProperty();
            }
        };
    }

    public static <T extends HasCheckBox> NamaCheckBoxCellFactory<T> createSelectionCheckbox() {
        return new NamaCheckBoxCellFactory<T>(){

            @Override
            protected void updateValue(HasCheckBox hasCheckBox, Boolean new_val, CheckBox checkBox) {
                hasCheckBox.updateSelectionProperty(new_val);
            }

            @Override
            protected Boolean readValue(HasCheckBox hasCheckBox) {
                return hasCheckBox.fetchSelectionProperty();
            }
        };
    }

    public ObservableValue<CheckBox> call(TableColumn.CellDataFeatures<T, CheckBox> param) {
        boolean comitBefore;
        HasCheckBox hasCheckBox = (HasCheckBox)param.getValue();
        CheckBox checkBox = new CheckBox();
        checkBox.setSelected(this.readValue(hasCheckBox).booleanValue());
        checkBox.selectedProperty().addListener((ov, old_val, new_val) -> {
            this.updateValue(hasCheckBox, (Boolean)new_val, checkBox);
            checkBox.setSelected(this.readValue(hasCheckBox).booleanValue());
        });
        boolean selectionBox = ObjectChecker.isEmptyOrNull((Object)param.getTableColumn().getText());
        if (selectionBox) {
            return new SimpleObjectProperty((Object)checkBox);
        }
        boolean bl = comitBefore = ObjectChecker.isNotEmptyOrNull((Object)hasCheckBox.originDoc()) && hasCheckBox.originDoc().getComitBefore() != false;
        if (comitBefore && hasCheckBox.disabledInSavedDocLines().booleanValue() || hasCheckBox.disabledInFromDocLines().booleanValue()) {
            checkBox.setDisable(true);
        }
        return new SimpleObjectProperty((Object)checkBox);
    }

    protected abstract void updateValue(HasCheckBox var1, Boolean var2, CheckBox var3);

    protected abstract Boolean readValue(HasCheckBox var1);
}

