/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.pos.application;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.namacontrols.NamaSearchBox;
import com.namasoft.pos.application.POSSavable;
import com.namasoft.pos.domain.AbsPOSSales;
import java.lang.reflect.Method;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableView;

public class NamaSearchBoxTableCell<S, T>
extends TableCell<S, T> {
    private NamaSearchBox searchBox;
    private String fieldName;
    private String colId;
    private AbsPOSSales doc;

    public NamaSearchBoxTableCell(NamaSearchBox searchBox, String fieldId, String colId, AbsPOSSales doc) {
        this.fieldName = fieldId;
        this.colId = colId;
        this.doc = doc;
        this.searchBox = searchBox;
        this.searchBox.setAfterSelectionFunc(e -> {
            Object newValue = this.searchBox.fetchValue();
            this.commitEdit(newValue);
            return null;
        });
        this.searchBox = searchBox;
        this.setGraphic((Node)this.searchBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    protected void updateItem(T item, boolean empty) {
        boolean invalidIndex;
        super.updateItem(item, empty);
        boolean bl = invalidIndex = this.getIndex() >= this.getTableView().getItems().size() || this.getIndex() < 0;
        if (invalidIndex || ObjectChecker.isEmptyOrNull((Object)this.getTableView().getItems().get(this.getIndex()))) {
            this.setText(null);
            this.setGraphic(null);
            this.disableIfNeeded();
        } else {
            this.disableIfNeeded();
            this.setGraphic((Node)this.searchBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }
    }

    private void disableIfNeeded() {
        POSSavable tableLine = (POSSavable)this.getTableRow().getItem();
        if (tableLine != null && tableLine.mustBeDisable(this.colId).booleanValue()) {
            this.searchBox.setDisable(true);
        }
    }

    public void commitEdit(T newValue) {
        TableView table = this.getTableView();
        int index = this.getIndex();
        Object line = table.getItems().get(index);
        String capitalizedFieldId = this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
        String methodName = "set" + capitalizedFieldId;
        try {
            Method method = line.getClass().getMethod(methodName, newValue.getClass());
            method.invoke(line, newValue);
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
        this.updateItem(newValue, false);
    }

    public void startEdit() {
        super.startEdit();
    }

    public void cancelEdit() {
        super.cancelEdit();
    }
}

